/*
 * Decompiled with CFR 0.152.
 */
package os.shaded_org_apache_tools_zip;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.CRC32;
import os.shaded_org_apache_tools_zip.AbstractUnicodeExtraField;
import os.shaded_org_apache_tools_zip.UnicodeCommentExtraField;
import os.shaded_org_apache_tools_zip.UnicodePathExtraField;
import os.shaded_org_apache_tools_zip.UnsupportedZipFeatureException;
import os.shaded_org_apache_tools_zip.ZipEncodingHelper;
import os.shaded_org_apache_tools_zip.ZipEntry;
import os.shaded_org_apache_tools_zip.ZipLong;

public abstract class ZipUtil {
    private static final byte[] DOS_TIME_MIN = ZipLong.getBytes(8448L);

    public static ZipLong toDosTime(Date date) {
        return new ZipLong(ZipUtil.toDosTime(date.getTime()));
    }

    public static byte[] toDosTime(long l) {
        byte[] byArray = new byte[4];
        ZipUtil.toDosTime(l, byArray, 0);
        return byArray;
    }

    public static void toDosTime(long l, byte[] byArray, int n) {
        ZipUtil.toDosTime(Calendar.getInstance(), l, byArray, n);
    }

    static void toDosTime(Calendar calendar, long l, byte[] byArray, int n) {
        calendar.setTimeInMillis(l);
        int n2 = calendar.get(1);
        if (n2 < 1980) {
            System.arraycopy(DOS_TIME_MIN, 0, byArray, n, DOS_TIME_MIN.length);
            return;
        }
        int n3 = calendar.get(2) + 1;
        long l2 = n2 - 1980 << 25 | n3 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
        ZipLong.putLong(l2, byArray, n);
    }

    public static long adjustToLong(int n) {
        if (n < 0) {
            return 0x100000000L + (long)n;
        }
        return n;
    }

    public static Date fromDosTime(ZipLong zipLong) {
        long l = zipLong.getValue();
        return new Date(ZipUtil.dosToJavaTime(l));
    }

    public static long dosToJavaTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, (int)(l >> 25 & 0x7FL) + 1980);
        calendar.set(2, (int)(l >> 21 & 0xFL) - 1);
        calendar.set(5, (int)(l >> 16) & 0x1F);
        calendar.set(11, (int)(l >> 11) & 0x1F);
        calendar.set(12, (int)(l >> 5) & 0x3F);
        calendar.set(13, (int)(l << 1) & 0x3E);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    static void setNameAndCommentFromExtraFields(ZipEntry zipEntry, byte[] byArray, byte[] byArray2) {
        UnicodeCommentExtraField unicodeCommentExtraField;
        String string;
        UnicodePathExtraField unicodePathExtraField = (UnicodePathExtraField)zipEntry.getExtraField(UnicodePathExtraField.UPATH_ID);
        String string2 = zipEntry.getName();
        String string3 = ZipUtil.getUnicodeStringIfOriginalMatches(unicodePathExtraField, byArray);
        if (string3 != null && !string2.equals(string3)) {
            zipEntry.setName(string3);
        }
        if (byArray2 != null && byArray2.length > 0 && (string = ZipUtil.getUnicodeStringIfOriginalMatches(unicodeCommentExtraField = (UnicodeCommentExtraField)zipEntry.getExtraField(UnicodeCommentExtraField.UCOM_ID), byArray2)) != null) {
            zipEntry.setComment(string);
        }
    }

    private static String getUnicodeStringIfOriginalMatches(AbstractUnicodeExtraField abstractUnicodeExtraField, byte[] byArray) {
        if (abstractUnicodeExtraField != null) {
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            long l = cRC32.getValue();
            if (l == abstractUnicodeExtraField.getNameCRC32()) {
                try {
                    return ZipEncodingHelper.UTF8_ZIP_ENCODING.decode(abstractUnicodeExtraField.getUnicodeName());
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        return null;
    }

    static byte[] copy(byte[] byArray) {
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return null;
    }

    static boolean canHandleEntryData(ZipEntry zipEntry) {
        return ZipUtil.supportsEncryptionOf(zipEntry) && ZipUtil.supportsMethodOf(zipEntry);
    }

    private static boolean supportsEncryptionOf(ZipEntry zipEntry) {
        return !zipEntry.getGeneralPurposeBit().usesEncryption();
    }

    private static boolean supportsMethodOf(ZipEntry zipEntry) {
        return zipEntry.getMethod() == 0 || zipEntry.getMethod() == 8;
    }

    static void checkRequestedFeatures(ZipEntry zipEntry) throws UnsupportedZipFeatureException {
        if (!ZipUtil.supportsEncryptionOf(zipEntry)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.ENCRYPTION, zipEntry);
        }
        if (!ZipUtil.supportsMethodOf(zipEntry)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.METHOD, zipEntry);
        }
    }
}

