/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.lib.xml.DFDLCatalogResolver;
import org.apache.daffodil.lib.xml.DFDLCatalogResolver$;
import org.apache.daffodil.lib.xml.DaffodilConstructingLoader;
import org.apache.daffodil.lib.xml.DaffodilSAXParserFactory$;
import org.apache.daffodil.lib.xml.RethrowSchemaErrorHandler$;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.validation.XercesValidator;
import org.apache.daffodil.validation.XercesValidator$;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.xml.Document;
import scala.xml.Node;
import scala.xml.Source$;
import scala.xml.parsing.FactoryAdapter;
import scala.xml.parsing.NoBindingFactoryAdapter;

public class DaffodilXMLLoader
extends NoBindingFactoryAdapter {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DaffodilXMLLoader.class.getDeclaredField("noSchemaParser$lzy1"));
    private final ErrorHandler errorHandler;
    private volatile Object noSchemaParser$lzy1;

    public DaffodilXMLLoader(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler errorHandler() {
        return this.errorHandler;
    }

    public DaffodilXMLLoader() {
        this(RethrowSchemaErrorHandler$.MODULE$);
    }

    private DFDLCatalogResolver resolver() {
        return DFDLCatalogResolver$.MODULE$.get();
    }

    private XMLSchemaFactory schemaFactory() {
        XMLSchemaFactory sf = new XMLSchemaFactory();
        sf.setResourceResolver((LSResourceResolver)this.resolver());
        sf.setErrorHandler(this.errorHandler());
        sf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        sf.setFeature(XMLUtils$.MODULE$.XML_DISALLOW_DOCTYPE_FEATURE(), true);
        return sf;
    }

    public void validateAsIndividualDFDLSchemaFile(DaffodilSchemaSource source) {
        this.load(source, (Option<URI>)Some$.MODULE$.apply((Object)XMLUtils$.MODULE$.schemaForDFDLSchemas()), true);
    }

    public boolean validateAsCompleteDFDLSchema(DaffodilSchemaSource source) {
        InputSource inputSource = source.newInputSource();
        SAXSource saxSource = new SAXSource(inputSource);
        try {
            this.schemaFactory().newSchema((Source)saxSource);
        }
        finally {
            inputSource.getByteStream().close();
        }
        boolean bl = true;
        return bl;
    }

    public SAXParser parser() {
        throw Assert$.MODULE$.usageError("not to be called.");
    }

    public XMLReader reader() {
        throw Assert$.MODULE$.usageError("not to be called.");
    }

    public FactoryAdapter adapter() {
        throw Assert$.MODULE$.usageError("not to be called.");
    }

    private SAXParser parserFromURI(Option<URI> optSchemaURI) {
        if (optSchemaURI.isEmpty()) {
            return this.noSchemaParser();
        }
        SAXParserFactory f = this.parserFactory();
        Schema schema = this.schemaFromURI((URI)optSchemaURI.get());
        f.setSchema(schema);
        return this.parserFromFactory(f);
    }

    private Schema schemaFromURI(URI schemaURI) {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setErrorHandler(this.errorHandler());
        sf.setResourceResolver(this.resolver());
        Schema schema = sf.newSchema(new StreamSource(schemaURI.toString()));
        return schema;
    }

    private SAXParserFactory parserFactory() {
        SAXParserFactory f = DaffodilSAXParserFactory$.MODULE$.apply();
        f.setNamespaceAware(true);
        f.setFeature(XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), true);
        f.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        f.setValidating(false);
        f.setFeature("http://xml.org/sax/features/validation", true);
        f.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        f.setFeature("http://apache.org/xml/features/validation/schema", true);
        f.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        return f;
    }

    private SAXParser noSchemaParser() {
        Object object = this.noSchemaParser$lzy1;
        if (object instanceof SAXParser) {
            return (SAXParser)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (SAXParser)this.noSchemaParser$lzyINIT1();
    }

    private Object noSchemaParser$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.noSchemaParser$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    SAXParser sAXParser = null;
                    try {
                        sAXParser = this.parserFromFactory(this.parserFactory());
                        object2 = sAXParser == null ? LazyVals.NullValue$.MODULE$ : sAXParser;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.noSchemaParser$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return sAXParser;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private SAXParser parserFromFactory(SAXParserFactory f) {
        SAXParser p = f.newSAXParser();
        return p;
    }

    public Node load(DaffodilSchemaSource source, Option<URI> optSchemaURI, boolean addPositionAttributes) {
        return this.load(source, optSchemaURI, addPositionAttributes, true);
    }

    public boolean load$default$3() {
        return false;
    }

    public Node load(DaffodilSchemaSource source, Option<URI> optSchemaURI, boolean addPositionAttributes, boolean normalizeCRLFtoLF) {
        Node node;
        optSchemaURI.foreach((Function1 & Serializable)schemaURI -> {
            Document document;
            XercesValidator xercesValidator;
            try {
                xercesValidator = XercesValidator$.MODULE$.fromURL(schemaURI.toURL());
            }
            catch (SAXParseException e) {
                throw Assert$.MODULE$.invariantFailed("Failed to load validation schema (" + schemaURI + "), this indicates a bug or incorrect build configuration: " + e);
            }
            XercesValidator validator = xercesValidator;
            InputStream inputStream = source.uriForLoading().toURL().openStream();
            validator.validateXML(inputStream, this.errorHandler());
            inputStream.close();
            SAXParser parser = this.parserFromURI(optSchemaURI);
            XMLReader r = parser.getXMLReader();
            XMLFilterImpl w = new XMLFilterImpl(r){

                public void setEntityResolver(EntityResolver resolver) {
                }

                public void parse(InputSource input) {
                    this.getParent().parse(input);
                }

                public void setContentHandler(ContentHandler handler) {
                    this.getParent().setContentHandler(handler);
                }

                public void setDTDHandler(DTDHandler handler) {
                    this.getParent().setDTDHandler(handler);
                }

                public void setErrorHandler(ErrorHandler handler) {
                    this.getParent().setErrorHandler(handler);
                }

                public ContentHandler getContentHandler() {
                    return this.getParent().getContentHandler();
                }

                public DTDHandler getDTDHandler() {
                    return this.getParent().getDTDHandler();
                }

                public ErrorHandler getErrorHandler() {
                    return this.getParent().getErrorHandler();
                }
            };
            w.setErrorHandler(this.errorHandler());
            w.setProperty("http://apache.org/xml/properties/internal/entity-resolver", this.resolver());
            XMLFilterImpl xrdr = w;
            InputSource saxSource = Source$.MODULE$.fromSysId(source.uriForLoading().toString());
            try {
                document = this.loadDocument(saxSource, xrdr);
            }
            catch (SAXParseException spe) {
                this.errorHandler().error(spe);
                document = BoxedUnit.UNIT;
            }
            return document;
        });
        DaffodilConstructingLoader constructingLoader = new DaffodilConstructingLoader(source.uriForLoading(), this.errorHandler(), addPositionAttributes, normalizeCRLFtoLF);
        try {
            node = constructingLoader.load();
        }
        finally {
            constructingLoader.input().close();
        }
        Node res = node;
        return res;
    }
}

