/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.infoset.DataValue;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

public interface FNRoundHalfToEvenKind {
    public static Object compute$(FNRoundHalfToEvenKind $this, Object value, int precision) {
        return $this.compute(value, precision);
    }

    default public Object compute(Object value, int precision) {
        Double d;
        Object object;
        Float f;
        Object object2 = DataValue$.MODULE$.getAnyRef$extension(value);
        if (object2 instanceof Float && ((f = (Float)object2).isNaN() || BoxesRunTime.equals((Object)f, (Object)BoxesRunTime.boxToInteger((int)0)) || RichFloat$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.floatWrapper(f.floatValue())) || RichFloat$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.floatWrapper(f.floatValue())))) {
            object = DataValue$.MODULE$.toDataValue(f);
        } else if (object2 instanceof Double && ((d = (Double)object2).isNaN() || BoxesRunTime.equals((Object)d, (Object)BoxesRunTime.boxToInteger((int)0)) || RichDouble$.MODULE$.isPosInfinity$extension(Predef$.MODULE$.doubleWrapper(d.doubleValue())) || RichDouble$.MODULE$.isNegInfinity$extension(Predef$.MODULE$.doubleWrapper(d.doubleValue())))) {
            object = DataValue$.MODULE$.toDataValue(d);
        } else if (object2 instanceof Float) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof Double) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof BigDecimal) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof BigInteger) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof Long) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof Integer) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof Byte) {
            object = this.roundIt$1(value, precision);
        } else if (object2 instanceof Short) {
            object = this.roundIt$1(value, precision);
        } else {
            throw Assert$.MODULE$.invariantFailed("Unrecognized numeric type. Must be xs:float, xs:double, xs:decimal, xs:integer or a type derived from these.");
        }
        Object result = object;
        return result;
    }

    private BigDecimal unrounded(Object value) {
        BigDecimal bigDecimal;
        Object object = DataValue$.MODULE$.getAnyRef$extension(value);
        if (object instanceof Float || object instanceof Double || object instanceof BigDecimal) {
            bigDecimal = Numbers$.MODULE$.asBigDecimal(DataValue$.MODULE$.getAnyRef$extension(value));
        } else if (object instanceof BigInteger || object instanceof Long || object instanceof Integer || object instanceof Byte || object instanceof Short) {
            bigDecimal = Numbers$.MODULE$.asBigDecimal(DataValue$.MODULE$.getAnyRef$extension(value));
        } else {
            throw Assert$.MODULE$.usageError("Received a type other than xs:decimal, xs:double, xs:float, xs:integer or any of its sub-types.");
        }
        BigDecimal result = bigDecimal;
        return DataValue$.MODULE$.toDataValue(result);
    }

    private BigDecimal round(BigDecimal value, int precision) {
        BigDecimal rounded = DataValue$.MODULE$.getBigDecimal$extension(value).setScale(precision, RoundingMode.HALF_EVEN);
        return DataValue$.MODULE$.toDataValue(rounded);
    }

    private Object toBaseNumericType(BigDecimal value, Object origValue) {
        DataValue dataValue;
        Object object = DataValue$.MODULE$.getAnyRef$extension(origValue);
        if (object instanceof Float) {
            dataValue = new DataValue((BigInteger)((Object)DataValue$.MODULE$.toDataValue(DataValue$.MODULE$.getBigDecimal$extension(value).floatValue())));
        } else if (object instanceof Double) {
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(DataValue$.MODULE$.getBigDecimal$extension(value).doubleValue()));
        } else if (object instanceof BigDecimal) {
            dataValue = new DataValue(value);
        } else if (object instanceof BigInteger) {
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(DataValue$.MODULE$.getBigDecimal$extension(value).toBigInteger()));
        } else if (object instanceof Long || object instanceof Integer || object instanceof Byte || object instanceof Short) {
            dataValue = new DataValue(DataValue$.MODULE$.toDataValue(DataValue$.MODULE$.getBigDecimal$extension(value).toBigInteger()));
        } else {
            throw Assert$.MODULE$.usageError("Received a type other than xs:decimal, xs:double, xs:float, xs:integer or any of its sub-types.");
        }
        DataValue dataValue2 = dataValue;
        Object result = dataValue2 == null ? null : dataValue2.v();
        return result;
    }

    private Object roundIt$1(Object value$1, int precision$1) {
        BigDecimal unroundedValue = this.unrounded(value$1);
        Object roundedValue = this.toBaseNumericType(this.round(unroundedValue, precision$1), value$1);
        return roundedValue;
    }
}

