/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//! Trait for gRPC eventmesh producer.

use crate::model::response::EventMeshResponse;
use std::future::Future;

/// Trait for gRPC eventmesh producer.
pub trait EventMeshGrpcProducer<M> {
    /// Publish a message.
    fn publish(&mut self, message: M) -> impl Future<Output = crate::Result<EventMeshResponse>>;

    /// Publish a batch of messages.
    fn publish_batch(
        &mut self,
        messages: Vec<M>,
    ) -> impl Future<Output = crate::Result<EventMeshResponse>>;

    /// Request reply for a message.
    fn request_reply(
        &mut self,
        message: M,
        time_out: u64,
    ) -> impl Future<Output = crate::Result<M>>;
}
