/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.adhocquery.service;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.adhocquery.domain.ReportRunFrequency;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class AdHocDataValidator {
    public static final String NAME = "name";
    public static final String QUERY = "query";
    public static final String TABLE_NAME = "tableName";
    public static final String TABLE_FIELDS = "tableFields";
    public static final String EMAIL = "email";
    public static final String REPORT_RUN_FREQUENCY = "reportRunFrequency";
    public static final String REPORT_RUN_EVERY = "reportRunEvery";
    private static final Set<String> supportedParameters = new HashSet<String>(Arrays.asList("name", "query", "tableName", "tableFields", "email", "isActive", "reportRunFrequency", "reportRunEvery"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public AdHocDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        Long reportRunEvery;
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("adhoc");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed(NAME, element);
        baseDataValidator.reset().parameter(NAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String description = this.fromApiJsonHelper.extractStringNamed(QUERY, element);
        baseDataValidator.reset().parameter(QUERY).value((Object)description).notBlank().notExceedingLengthOf(Integer.valueOf(2000));
        String tableName = this.fromApiJsonHelper.extractStringNamed(TABLE_NAME, element);
        baseDataValidator.reset().parameter(TABLE_NAME).value((Object)tableName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        String tableFields = this.fromApiJsonHelper.extractStringNamed(TABLE_FIELDS, element);
        baseDataValidator.reset().parameter(TABLE_FIELDS).value((Object)tableFields).notBlank().notExceedingLengthOf(Integer.valueOf(1000));
        String email = this.fromApiJsonHelper.extractStringNamed(EMAIL, element);
        baseDataValidator.reset().parameter(EMAIL).value((Object)email).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(500));
        Long reportRunFrequencyCode = this.fromApiJsonHelper.extractLongNamed(REPORT_RUN_FREQUENCY, element);
        if (reportRunFrequencyCode != null) {
            baseDataValidator.reset().parameter(REPORT_RUN_FREQUENCY).value((Object)reportRunFrequencyCode).inMinMaxRange(Integer.valueOf((int)ReportRunFrequency.DAILY.getValue()), Integer.valueOf((int)ReportRunFrequency.CUSTOM.getValue()));
        }
        if ((reportRunEvery = this.fromApiJsonHelper.extractLongNamed(REPORT_RUN_EVERY, element)) != null) {
            baseDataValidator.reset().parameter(REPORT_RUN_EVERY).value((Object)reportRunFrequencyCode).integerGreaterThanZero();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)supportedParameters);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("adhoc");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(NAME, element)) {
            String name = this.fromApiJsonHelper.extractStringNamed(NAME, element);
            baseDataValidator.reset().parameter(NAME).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(QUERY, element)) {
            String query = this.fromApiJsonHelper.extractStringNamed(QUERY, element);
            baseDataValidator.reset().parameter(QUERY).value((Object)query).notBlank().notExceedingLengthOf(Integer.valueOf(2000));
        }
        if (this.fromApiJsonHelper.parameterExists(TABLE_NAME, element)) {
            String tableName = this.fromApiJsonHelper.extractStringNamed(TABLE_NAME, element);
            baseDataValidator.reset().parameter(TABLE_NAME).value((Object)tableName).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(TABLE_FIELDS, element)) {
            String tableField = this.fromApiJsonHelper.extractStringNamed(TABLE_FIELDS, element);
            baseDataValidator.reset().parameter(TABLE_FIELDS).value((Object)tableField).notBlank().notExceedingLengthOf(Integer.valueOf(2000));
        }
        if (this.fromApiJsonHelper.parameterExists(EMAIL, element)) {
            String email = this.fromApiJsonHelper.extractStringNamed(EMAIL, element);
            baseDataValidator.reset().parameter(EMAIL).value((Object)email).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(500));
        }
        if (this.fromApiJsonHelper.parameterExists(REPORT_RUN_FREQUENCY, element)) {
            Long reportRunFrequencyCode = this.fromApiJsonHelper.extractLongNamed(REPORT_RUN_FREQUENCY, element);
            baseDataValidator.reset().parameter(REPORT_RUN_FREQUENCY).value((Object)reportRunFrequencyCode).inMinMaxRange(Integer.valueOf((int)ReportRunFrequency.DAILY.getValue()), Integer.valueOf((int)ReportRunFrequency.CUSTOM.getValue()));
        }
        if (this.fromApiJsonHelper.parameterExists(REPORT_RUN_EVERY, element)) {
            Long reportRunEvery = this.fromApiJsonHelper.extractLongNamed(REPORT_RUN_EVERY, element);
            baseDataValidator.reset().parameter(REPORT_RUN_EVERY).value((Object)reportRunEvery).integerGreaterThanZero();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

