/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.domain.LoanAccountLock;
import org.apache.fineract.cob.domain.LoanAccountLockRepository;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.cob.service.LoanAccountLockService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoanAccountLockServiceImpl
implements LoanAccountLockService {
    private final LoanAccountLockRepository loanAccountLockRepository;

    public List<LoanAccountLock> getLockedLoanAccountByPage(int page, int limit) {
        PageRequest loanAccountLockPage = PageRequest.of((int)page, (int)limit);
        Page loanAccountLocks = this.loanAccountLockRepository.findAll((Pageable)loanAccountLockPage);
        return loanAccountLocks.getContent();
    }

    public boolean isLoanHardLocked(Long loanId) {
        return this.loanAccountLockRepository.existsByLoanIdAndLockOwner(loanId, LockOwner.LOAN_COB_CHUNK_PROCESSING) || this.loanAccountLockRepository.existsByLoanIdAndLockOwner(loanId, LockOwner.LOAN_INLINE_COB_PROCESSING);
    }

    public boolean isLockOverrulable(Long loanId) {
        return this.loanAccountLockRepository.existsByLoanIdAndLockOwnerAndErrorIsNotNull(loanId, LockOwner.LOAN_COB_CHUNK_PROCESSING) || this.loanAccountLockRepository.existsByLoanIdAndLockOwnerAndErrorIsNotNull(loanId, LockOwner.LOAN_INLINE_COB_PROCESSING);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateCobAndRemoveLocks() {
        this.loanAccountLockRepository.updateLoanFromAccountLocks();
        this.loanAccountLockRepository.removeLockByOwner();
    }

    @Generated
    public LoanAccountLockServiceImpl(LoanAccountLockRepository loanAccountLockRepository) {
        this.loanAccountLockRepository = loanAccountLockRepository;
    }
}

