/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ChargeSheetPopulator
extends AbstractWorkbookPopulator {
    private List<ChargeData> charges;
    private static final int ID_COL = 0;

    public ChargeSheetPopulator(List<ChargeData> charges) {
        this.charges = charges;
    }

    public void populate(Workbook workbook, String dateFormat) {
        int rowIndex = 1;
        Sheet chargeSheet = workbook.createSheet("Charges");
        this.setLayout(chargeSheet);
        this.populateCharges(chargeSheet, rowIndex);
        chargeSheet.protectSheet("");
    }

    private void populateCharges(Sheet chargeSheet, int rowIndex) {
        for (ChargeData charge : this.charges) {
            Row row = chargeSheet.createRow(rowIndex);
            this.writeLong(0, row, charge.getId().longValue());
            this.writeString(1, row, charge.getName().trim().replaceAll("[ )(]", "_"));
            this.writeBigDecimal(2, row, charge.getAmount());
            this.writeString(3, row, charge.getChargeCalculationType().getValue());
            this.writeString(4, row, charge.getChargeTimeType().getValue());
            ++rowIndex;
        }
    }

    private void setLayout(Sheet worksheet) {
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 6000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 6000);
        worksheet.setColumnWidth(4, 6000);
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        this.writeString(0, rowHeader, "ID");
        this.writeString(1, rowHeader, "Name");
        this.writeString(2, rowHeader, "Charge Amount");
        this.writeString(3, rowHeader, "Charge Calculation Type");
        this.writeString(4, rowHeader, "Charge Time Type");
    }

    public Integer getChargesSize() {
        return this.charges.size();
    }

    public List<ChargeData> getCharges() {
        return this.charges;
    }
}

