/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.cache.service.CacheWritePlatformService;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.FineractRequestContextHolder;
import org.apache.fineract.infrastructure.core.filters.CallerIpTrackingFilter;
import org.apache.fineract.infrastructure.core.filters.CorrelationHeaderFilter;
import org.apache.fineract.infrastructure.core.filters.IdempotencyStoreFilter;
import org.apache.fineract.infrastructure.core.filters.IdempotencyStoreHelper;
import org.apache.fineract.infrastructure.core.filters.RequestResponseFilter;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.MDCWrapper;
import org.apache.fineract.infrastructure.instancemode.filter.FineractInstanceModeApiFilter;
import org.apache.fineract.infrastructure.jobs.filter.LoanCOBApiFilter;
import org.apache.fineract.infrastructure.jobs.filter.LoanCOBFilterHelper;
import org.apache.fineract.infrastructure.security.data.PlatformRequestLog;
import org.apache.fineract.infrastructure.security.filter.TenantAwareBasicAuthenticationFilter;
import org.apache.fineract.infrastructure.security.filter.TwoFactorAuthenticationFilter;
import org.apache.fineract.infrastructure.security.service.AuthTenantDetailsService;
import org.apache.fineract.infrastructure.security.service.TenantAwareJpaPlatformUserDetailsService;
import org.apache.fineract.infrastructure.security.service.TwoFactorService;
import org.apache.fineract.infrastructure.security.vote.SelfServiceUserAuthorizationManager;
import org.apache.fineract.notification.service.UserNotificationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorityAuthorizationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagers;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@ConditionalOnProperty(value={"fineract.security.basicauth.enabled"})
@EnableMethodSecurity
public class SecurityConfig {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private TenantAwareJpaPlatformUserDetailsService userDetailsService;
    @Autowired
    private FineractProperties fineractProperties;
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private ToApiJsonSerializer<PlatformRequestLog> toApiJsonSerializer;
    @Autowired
    private ConfigurationDomainService configurationDomainService;
    @Autowired
    private CacheWritePlatformService cacheWritePlatformService;
    @Autowired
    private UserNotificationService userNotificationService;
    @Autowired
    private AuthTenantDetailsService basicAuthTenantDetailsService;
    @Autowired
    private BusinessDateReadPlatformService businessDateReadPlatformService;
    @Autowired
    private MDCWrapper mdcWrapper;
    @Autowired
    private FineractRequestContextHolder fineractRequestContextHolder;
    @Autowired(required=false)
    private LoanCOBFilterHelper loanCOBFilterHelper;
    @Autowired
    private IdempotencyStoreHelper idempotencyStoreHelper;

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.securityMatcher((RequestMatcher)AntPathRequestMatcher.antMatcher((String)"/api/**")).authorizeHttpRequests(auth -> {
            ArrayList<Object> authorizationManagers = new ArrayList<Object>();
            authorizationManagers.add(AuthenticatedAuthorizationManager.fullyAuthenticated());
            if (this.fineractProperties.getSecurity().getTwoFactor().isEnabled()) {
                authorizationManagers.add(AuthorityAuthorizationManager.hasAuthority((String)"TWOFACTOR_AUTHENTICATED"));
            }
            if (this.fineractProperties.getModule().getSelfService().isEnabled()) {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/self/authentication")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/self/registration")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/self/registration/user")})).permitAll();
                authorizationManagers.add(SelfServiceUserAuthorizationManager.selfServiceUserAuthManager());
            }
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.OPTIONS, (String)"/api/**")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/echo")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/authentication")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.PUT, (String)"/api/*/instance-mode")})).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/api/*/businessdate/*")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_READ", "READ_BUSINESS_DATE"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/businessdate")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_WRITE", "UPDATE_BUSINESS_DATE"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/api/*/externalevents/configuration")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_READ", "READ_EXTERNAL_EVENT_CONFIGURATION"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.PUT, (String)"/api/*/externalevents/configuration")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_WRITE", "UPDATE_EXTERNAL_EVENT_CONFIGURATION"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/api/*/caches")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_READ", "READ_CACHE"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.PUT, (String)"/api/*/caches")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_WRITE", "UPDATE_CACHE"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.GET, (String)"/api/*/currencies")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_READ", "READ_CURRENCY"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/currencies")})).hasAnyAuthority(new String[]{"ALL_FUNCTIONS", "ALL_FUNCTIONS_WRITE", "UPDATE_CURRENCY"}).requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.POST, (String)"/api/*/twofactor/validate")})).fullyAuthenticated().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/*/twofactor")})).fullyAuthenticated().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/**")})).access(AuthorizationManagers.allOf((AuthorizationManager[])authorizationManagers.toArray(new AuthorizationManager[0])));
        }).httpBasic(httpBasic -> httpBasic.authenticationEntryPoint((AuthenticationEntryPoint)this.basicAuthenticationEntryPoint())).csrf(AbstractHttpConfigurer::disable).sessionManagement(smc -> smc.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).addFilterBefore((Filter)this.tenantAwareBasicAuthenticationFilter(), SecurityContextHolderFilter.class).addFilterAfter((Filter)this.requestResponseFilter(), ExceptionTranslationFilter.class).addFilterAfter((Filter)this.correlationHeaderFilter(), RequestResponseFilter.class).addFilterAfter((Filter)this.fineractInstanceModeApiFilter(), CorrelationHeaderFilter.class);
        if (!Objects.isNull(this.loanCOBFilterHelper)) {
            http.addFilterAfter((Filter)this.loanCOBApiFilter(), FineractInstanceModeApiFilter.class).addFilterAfter((Filter)this.idempotencyStoreFilter(), LoanCOBApiFilter.class);
        } else {
            http.addFilterAfter((Filter)this.idempotencyStoreFilter(), FineractInstanceModeApiFilter.class);
        }
        if (this.fineractProperties.getIpTracking().isEnabled()) {
            http.addFilterAfter((Filter)this.callerIpTrackingFilter(), RequestResponseFilter.class);
        }
        if (this.fineractProperties.getSecurity().getTwoFactor().isEnabled()) {
            http.addFilterAfter((Filter)this.twoFactorAuthenticationFilter(), CorrelationHeaderFilter.class);
        }
        if (this.serverProperties.getSsl().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/api/**")})).requiresSecure());
        }
        if (this.fineractProperties.getSecurity().getHsts().isEnabled()) {
            http.requiresChannel(channel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)channel.anyRequest()).requiresSecure()).headers(headers -> headers.httpStrictTransportSecurity(hsts -> hsts.includeSubDomains(true).maxAgeInSeconds(31536000L)));
        }
        if (this.fineractProperties.getSecurity().getCors().isEnabled()) {
            http.cors(Customizer.withDefaults());
        }
        return (SecurityFilterChain)http.build();
    }

    public RequestResponseFilter requestResponseFilter() {
        return new RequestResponseFilter();
    }

    public LoanCOBApiFilter loanCOBApiFilter() {
        return new LoanCOBApiFilter(this.loanCOBFilterHelper);
    }

    public TwoFactorAuthenticationFilter twoFactorAuthenticationFilter() {
        TwoFactorService twoFactorService = (TwoFactorService)this.applicationContext.getBean(TwoFactorService.class);
        return new TwoFactorAuthenticationFilter(twoFactorService);
    }

    public FineractInstanceModeApiFilter fineractInstanceModeApiFilter() {
        return new FineractInstanceModeApiFilter(this.fineractProperties);
    }

    public IdempotencyStoreFilter idempotencyStoreFilter() {
        return new IdempotencyStoreFilter(this.fineractRequestContextHolder, this.idempotencyStoreHelper, this.fineractProperties);
    }

    public CorrelationHeaderFilter correlationHeaderFilter() {
        return new CorrelationHeaderFilter(this.fineractProperties, this.mdcWrapper);
    }

    public CallerIpTrackingFilter callerIpTrackingFilter() {
        return new CallerIpTrackingFilter(this.fineractProperties);
    }

    public TenantAwareBasicAuthenticationFilter tenantAwareBasicAuthenticationFilter() throws Exception {
        TenantAwareBasicAuthenticationFilter filter = new TenantAwareBasicAuthenticationFilter(this.authenticationManagerBean(), (AuthenticationEntryPoint)this.basicAuthenticationEntryPoint(), this.toApiJsonSerializer, this.configurationDomainService, this.cacheWritePlatformService, this.userNotificationService, this.basicAuthTenantDetailsService, this.businessDateReadPlatformService);
        filter.setRequestMatcher((RequestMatcher)AntPathRequestMatcher.antMatcher((String)"/api/**"));
        return filter;
    }

    @Bean
    public BasicAuthenticationEntryPoint basicAuthenticationEntryPoint() {
        BasicAuthenticationEntryPoint basicAuthenticationEntryPoint = new BasicAuthenticationEntryPoint();
        basicAuthenticationEntryPoint.setRealmName("Fineract Platform API");
        return basicAuthenticationEntryPoint;
    }

    @Bean(name={"customAuthenticationProvider"})
    public DaoAuthenticationProvider authProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setUserDetailsService((UserDetailsService)this.userDetailsService);
        authProvider.setPasswordEncoder(this.passwordEncoder());
        return authProvider;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        ProviderManager providerManager = new ProviderManager(new AuthenticationProvider[]{this.authProvider()});
        providerManager.setEraseCredentialsAfterAuthentication(false);
        return providerManager;
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration config = new CorsConfiguration();
        FineractProperties.CorsProperties corsConfiguration = this.fineractProperties.getSecurity().getCors();
        config.setAllowedOriginPatterns(corsConfiguration.getAllowedOriginPatterns());
        config.setAllowedMethods(corsConfiguration.getAllowedMethods());
        config.setAllowedHeaders(corsConfiguration.getAllowedHeaders());
        config.setExposedHeaders(corsConfiguration.getExposedHeaders());
        config.setAllowCredentials(Boolean.valueOf(corsConfiguration.isAllowCredentials()));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return source;
    }
}

