/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.springframework.stereotype.Component;

@Component
public class DateJsonConverter
implements JsonConverter<Date> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

    public Date convertToObject(JsonParser parser) throws IOException {
        Date result = null;
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            String formattedDate = parser.getText();
            result = Date.from(Instant.from(FORMATTER.parse(formattedDate)));
        }
        return result;
    }

    public void convertToJson(Date value, JsonGenerator generator) throws IOException {
        if (value != null) {
            generator.writeString(FORMATTER.format(value.toInstant()));
        }
    }

    public Class<Date> convertedType() {
        return Date.class;
    }
}

