/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.springframework.stereotype.Component;

@Component
public class ExternalIdJsonConverter
implements JsonConverter<ExternalId> {
    public ExternalId convertToObject(JsonParser parser) throws IOException {
        ExternalId result = ExternalId.empty();
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            String externalId = parser.getText();
            result = new ExternalId(externalId);
        }
        return result;
    }

    public void convertToJson(ExternalId value, JsonGenerator generator) throws IOException {
        if (value != null && !value.isEmpty()) {
            generator.writeString(value.getValue());
        } else {
            generator.writeNull();
        }
    }

    public Class<ExternalId> convertedType() {
        return ExternalId.class;
    }
}

