/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.exception.JobIsNotFoundOrNotEnabledException;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.domain.SchedulerDetail;
import org.apache.fineract.infrastructure.jobs.service.JobRegisterService;
import org.apache.fineract.infrastructure.jobs.service.SchedularWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class JobSchedulerServiceImpl
implements ApplicationListener<ContextRefreshedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobSchedulerServiceImpl.class);
    private final FineractProperties fineractProperties;
    private final SchedularWritePlatformService schedularWritePlatformService;
    private final TenantDetailsService tenantDetailsService;
    private final JobRegisterService jobRegisterService;
    private final BusinessDateReadPlatformService businessDateReadPlatformService;

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.fineractProperties.getMode().isBatchManagerEnabled()) {
            log.warn("Batch job scheduling is disabled since this instance is not a batch manager");
            return;
        }
        List allTenants = this.tenantDetailsService.findAllTenants();
        for (FineractPlatformTenant tenant : allTenants) {
            ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
            HashMap businessDates = this.businessDateReadPlatformService.getBusinessDates();
            ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.DEFAULT);
            ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
            List scheduledJobDetails = this.schedularWritePlatformService.retrieveAllJobs(this.fineractProperties.getNodeId());
            for (ScheduledJobDetail jobDetails : scheduledJobDetails) {
                try {
                    this.jobRegisterService.scheduleJob(jobDetails);
                }
                catch (JobIsNotFoundOrNotEnabledException e) {
                    log.warn("{}", (Object)e.getMessage());
                }
                jobDetails.setTriggerMisfired(false);
                this.schedularWritePlatformService.saveOrUpdate(jobDetails);
            }
            SchedulerDetail schedulerDetail = this.schedularWritePlatformService.retriveSchedulerDetail();
            if (schedulerDetail.isResetSchedulerOnBootup()) {
                schedulerDetail.setSuspended(false);
                this.schedularWritePlatformService.updateSchedulerDetail(schedulerDetail);
            }
            ThreadLocalContextUtil.reset();
        }
        log.info("Scheduling batch jobs has finished");
    }

    @Generated
    public JobSchedulerServiceImpl(FineractProperties fineractProperties, SchedularWritePlatformService schedularWritePlatformService, TenantDetailsService tenantDetailsService, JobRegisterService jobRegisterService, BusinessDateReadPlatformService businessDateReadPlatformService) {
        this.fineractProperties = fineractProperties;
        this.schedularWritePlatformService = schedularWritePlatformService;
        this.tenantDetailsService = tenantDetailsService;
        this.jobRegisterService = jobRegisterService;
        this.businessDateReadPlatformService = businessDateReadPlatformService;
    }
}

