/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.reportmailingjob.service;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobConfigurationData;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobEmailData;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobEmailService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class ReportMailingJobEmailServiceImpl
implements ReportMailingJobEmailService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportMailingJobEmailServiceImpl.class);
    private final ReportMailingJobConfigurationReadPlatformService reportMailingJobConfigurationReadPlatformService;

    @Autowired
    public ReportMailingJobEmailServiceImpl(ReportMailingJobConfigurationReadPlatformService reportMailingJobConfigurationReadPlatformService) {
        this.reportMailingJobConfigurationReadPlatformService = reportMailingJobConfigurationReadPlatformService;
    }

    public void sendEmailWithAttachment(ReportMailingJobEmailData reportMailingJobEmailData) {
        try {
            Collection reportMailingJobConfigurationDataCollection = this.reportMailingJobConfigurationReadPlatformService.retrieveAllReportMailingJobConfigurations();
            JavaMailSenderImpl javaMailSenderImpl = new JavaMailSenderImpl();
            javaMailSenderImpl.setHost(this.getGmailSmtpServer(reportMailingJobConfigurationDataCollection));
            javaMailSenderImpl.setPort(this.getGmailSmtpPort(reportMailingJobConfigurationDataCollection).intValue());
            javaMailSenderImpl.setUsername(this.getGmailSmtpUsername(reportMailingJobConfigurationDataCollection));
            javaMailSenderImpl.setPassword(this.getGmailSmtpPassword(reportMailingJobConfigurationDataCollection));
            javaMailSenderImpl.setJavaMailProperties(this.getJavaMailProperties(reportMailingJobConfigurationDataCollection));
            MimeMessage mimeMessage = javaMailSenderImpl.createMimeMessage();
            MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, true);
            mimeMessageHelper.setTo(reportMailingJobEmailData.getTo());
            mimeMessageHelper.setText(reportMailingJobEmailData.getText());
            mimeMessageHelper.setSubject(reportMailingJobEmailData.getSubject());
            if (reportMailingJobEmailData.getAttachment() != null) {
                mimeMessageHelper.addAttachment(reportMailingJobEmailData.getAttachment().getName(), reportMailingJobEmailData.getAttachment());
            }
            javaMailSenderImpl.send(mimeMessage);
        }
        catch (MessagingException e) {
            LOG.error("Problem occurred in sendEmailWithAttachment function", (Throwable)e);
        }
    }

    private Properties getJavaMailProperties(Collection<ReportMailingJobConfigurationData> reportMailingJobConfigurationDataCollection) {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.auth", "true");
        properties.setProperty("mail.smtp.starttls.enable", "true");
        properties.setProperty("mail.smtp.ssl.trust", this.getGmailSmtpServer(reportMailingJobConfigurationDataCollection));
        return properties;
    }

    private ReportMailingJobConfigurationData getReportMailingJobConfigurationData(Collection<ReportMailingJobConfigurationData> reportMailingJobConfigurationDataCollection, String name) {
        ReportMailingJobConfigurationData reportMailingJobConfigurationData = null;
        if (reportMailingJobConfigurationDataCollection != null && !reportMailingJobConfigurationDataCollection.isEmpty()) {
            for (ReportMailingJobConfigurationData reportMailingJobConfigurationDataObject : reportMailingJobConfigurationDataCollection) {
                String configurationName = reportMailingJobConfigurationDataObject.getName();
                if (StringUtils.isEmpty((CharSequence)configurationName) || !configurationName.equals(name)) continue;
                reportMailingJobConfigurationData = reportMailingJobConfigurationDataObject;
                break;
            }
        }
        return reportMailingJobConfigurationData;
    }

    private String getGmailSmtpServer(Collection<ReportMailingJobConfigurationData> reportMailingJobConfigurationDataCollection) {
        ReportMailingJobConfigurationData reportMailingJobConfigurationData = this.getReportMailingJobConfigurationData(reportMailingJobConfigurationDataCollection, "GMAIL_SMTP_SERVER");
        return reportMailingJobConfigurationData != null ? reportMailingJobConfigurationData.getValue() : null;
    }

    private Integer getGmailSmtpPort(Collection<ReportMailingJobConfigurationData> reportMailingJobConfigurationDataCollection) {
        ReportMailingJobConfigurationData reportMailingJobConfigurationData = this.getReportMailingJobConfigurationData(reportMailingJobConfigurationDataCollection, "GMAIL_SMTP_PORT");
        String portNumber = reportMailingJobConfigurationData != null ? reportMailingJobConfigurationData.getValue() : null;
        return portNumber != null ? Integer.valueOf(Integer.parseInt(portNumber)) : null;
    }

    private String getGmailSmtpUsername(Collection<ReportMailingJobConfigurationData> reportMailingJobConfigurationDataCollection) {
        ReportMailingJobConfigurationData reportMailingJobConfigurationData = this.getReportMailingJobConfigurationData(reportMailingJobConfigurationDataCollection, "GMAIL_SMTP_USERNAME");
        return reportMailingJobConfigurationData != null ? reportMailingJobConfigurationData.getValue() : null;
    }

    private String getGmailSmtpPassword(Collection<ReportMailingJobConfigurationData> reportMailingJobConfigurationDataCollection) {
        ReportMailingJobConfigurationData reportMailingJobConfigurationData = this.getReportMailingJobConfigurationData(reportMailingJobConfigurationDataCollection, "GMAIL_SMTP_PASSWORD");
        return reportMailingJobConfigurationData != null ? reportMailingJobConfigurationData.getValue() : null;
    }
}

