/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.notification.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.notification.domain.Notification;
import org.apache.fineract.notification.domain.NotificationMapper;
import org.apache.fineract.notification.service.NotificationGeneratorReadRepositoryWrapper;
import org.apache.fineract.notification.service.NotificationGeneratorWritePlatformService;
import org.apache.fineract.notification.service.NotificationMapperWritePlatformService;
import org.apache.fineract.notification.service.NotificationWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class NotificationWritePlatformServiceImpl
implements NotificationWritePlatformService {
    private final NotificationGeneratorWritePlatformService notificationGeneratorWritePlatformService;
    private final NotificationGeneratorReadRepositoryWrapper notificationGeneratorReadRepositoryWrapper;
    private final AppUserRepository appUserRepository;
    private final NotificationMapperWritePlatformService notificationMapperWritePlatformService;

    private Long insertIntoNotificationGenerator(String objectType, Long objectIdentifier, String action, Long actorId, String notificationContent, boolean isSystemGenerated) {
        Notification notification = new Notification().setObjectType(objectType).setObjectIdentifier(objectIdentifier).setAction(action).setActorId(actorId).setSystemGenerated(isSystemGenerated).setNotificationContent(notificationContent).setCreatedAt(DateUtils.getLocalDateTimeOfSystem());
        return this.notificationGeneratorWritePlatformService.create(notification);
    }

    public Long notify(Collection<Long> userIds, String objectType, Long objectId, String action, Long actorId, String notificationContent, boolean isSystemGenerated) {
        Long generatedNotificationId = this.insertIntoNotificationGenerator(objectType, objectId, action, actorId, notificationContent, isSystemGenerated);
        this.insertIntoNotificationMapper(userIds, generatedNotificationId);
        return generatedNotificationId;
    }

    private List<Long> insertIntoNotificationMapper(Collection<Long> userIds, Long generatedNotificationId) {
        ArrayList<Long> mappedIds = new ArrayList<Long>();
        for (Long userId : userIds) {
            AppUser appUser = (AppUser)this.appUserRepository.findById((Object)userId).orElseThrow();
            NotificationMapper notificationMapper = new NotificationMapper().setNotification(this.notificationGeneratorReadRepositoryWrapper.findById(generatedNotificationId)).setUserId(appUser).setRead(false).setCreatedAt(DateUtils.getLocalDateTimeOfSystem());
            this.notificationMapperWritePlatformService.create(notificationMapper);
            mappedIds.add((Long)notificationMapper.getId());
        }
        return mappedIds;
    }

    @Generated
    public NotificationWritePlatformServiceImpl(NotificationGeneratorWritePlatformService notificationGeneratorWritePlatformService, NotificationGeneratorReadRepositoryWrapper notificationGeneratorReadRepositoryWrapper, AppUserRepository appUserRepository, NotificationMapperWritePlatformService notificationMapperWritePlatformService) {
        this.notificationGeneratorWritePlatformService = notificationGeneratorWritePlatformService;
        this.notificationGeneratorReadRepositoryWrapper = notificationGeneratorReadRepositoryWrapper;
        this.appUserRepository = appUserRepository;
        this.notificationMapperWritePlatformService = notificationMapperWritePlatformService;
    }
}

