/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.group.data.GroupRoleData;
import org.apache.fineract.portfolio.group.exception.GroupRoleNotFoundException;
import org.apache.fineract.portfolio.group.service.GroupRolesReadPlatformService;
import org.apache.fineract.portfolio.group.service.GroupRolesReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class GroupRolesReadPlatformServiceImpl
implements GroupRolesReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    public Collection<GroupRoleData> retrieveGroupRoles(Long groupId) {
        this.context.authenticatedUser();
        GroupRolesDataMapper mapper = new GroupRolesDataMapper();
        String sql = "Select " + mapper.schema() + " where role.group_id=?";
        return this.jdbcTemplate.query(sql, (RowMapper)mapper, new Object[]{groupId});
    }

    public GroupRoleData retrieveGroupRole(Long groupId, Long roleId) {
        try {
            this.context.authenticatedUser();
            GroupRolesDataMapper mapper = new GroupRolesDataMapper();
            String sql = "Select " + mapper.schema() + " where role.group_id=? and role.id=?";
            return (GroupRoleData)this.jdbcTemplate.queryForObject(sql, (RowMapper)mapper, new Object[]{groupId, roleId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new GroupRoleNotFoundException(roleId, e);
        }
    }

    @Generated
    public GroupRolesReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
    }
}

