/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.rescheduleloan.service;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBalanceChangedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRescheduledDueAdjustScheduleBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.monetary.domain.MoneyHelper;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallmentRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRescheduleRequestToTermVariationMapping;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTermVariations;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleDTO;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.DefaultScheduledDateGenerator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanApplicationTerms;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanRepaymentScheduleHistoryRepository;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGenerator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleGeneratorFactory;
import org.apache.fineract.portfolio.loanaccount.loanschedule.service.LoanScheduleHistoryWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.mapper.LoanTermVariationsMapper;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.data.LoanRescheduleRequestDataValidator;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.domain.LoanRescheduleRequest;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.domain.LoanRescheduleRequestRepository;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.exception.LoanRescheduleRequestNotFoundException;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.service.LoanRescheduleRequestWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.schedule.LoanScheduleComponent;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoanRescheduleRequestWritePlatformServiceImpl
implements LoanRescheduleRequestWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanRescheduleRequestWritePlatformServiceImpl.class);
    private static final DefaultScheduledDateGenerator DEFAULT_SCHEDULED_DATE_GENERATOR = new DefaultScheduledDateGenerator();
    private final CodeValueRepositoryWrapper codeValueRepositoryWrapper;
    private final PlatformSecurityContext platformSecurityContext;
    @Qualifier(value="loanRescheduleRequestDataValidator")
    private final LoanRescheduleRequestDataValidator loanRescheduleRequestDataValidator;
    private final LoanRescheduleRequestRepository loanRescheduleRequestRepository;
    private final LoanRepaymentScheduleHistoryRepository loanRepaymentScheduleHistoryRepository;
    private final LoanScheduleHistoryWritePlatformService loanScheduleHistoryWritePlatformService;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanAssembler loanAssembler;
    private final LoanUtilService loanUtilService;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final LoanScheduleGeneratorFactory loanScheduleFactory;
    private final LoanRepaymentScheduleInstallmentRepository repaymentScheduleInstallmentRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanChargeService loanChargeService;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanTermVariationsMapper loanTermVariationsMapper;
    private final LoanScheduleComponent loanSchedule;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;

    @Transactional
    public CommandProcessingResult create(JsonCommand jsonCommand) {
        try {
            Long loanId = jsonCommand.longValueOfParameterNamed("loanId");
            Loan loan = this.loanAssembler.assembleFrom(loanId);
            this.loanRescheduleRequestDataValidator.validateForCreateAction(jsonCommand, loan);
            Long rescheduleReasonId = jsonCommand.longValueOfParameterNamed("rescheduleReasonId");
            CodeValue rescheduleReasonCodeValue = this.codeValueRepositoryWrapper.findOneWithNotFoundDetection(rescheduleReasonId);
            Integer graceOnPrincipal = jsonCommand.integerValueOfParameterNamed("graceOnPrincipal");
            Integer graceOnInterest = jsonCommand.integerValueOfParameterNamed("graceOnInterest");
            Integer extraTerms = jsonCommand.integerValueOfParameterNamed("extraTerms");
            BigDecimal interestRate = jsonCommand.bigDecimalValueOfParameterNamed("newInterestRate");
            String rescheduleReasonComment = jsonCommand.stringValueOfParameterNamed("rescheduleReasonComment");
            Boolean recalculateInterest = jsonCommand.booleanObjectValueOfParameterNamed("recalculateInterest");
            LocalDate endDate = jsonCommand.localDateValueOfParameterNamed("endDate");
            BigDecimal emi = jsonCommand.bigDecimalValueOfParameterNamed("emi");
            LocalDate submittedOnDate = null;
            if (jsonCommand.hasParameter("submittedOnDate")) {
                submittedOnDate = jsonCommand.localDateValueOfParameterNamed("submittedOnDate");
            }
            Integer rescheduleFromInstallment = null;
            LocalDate adjustedDueDate = null;
            LocalDate rescheduleFromDate = jsonCommand.localDateValueOfParameterNamed("rescheduleFromDate");
            if (rescheduleFromDate != null) {
                rescheduleFromInstallment = loan.getRelatedRepaymentScheduleInstallment(rescheduleFromDate).getInstallmentNumber();
            }
            if (jsonCommand.hasParameter("adjustedDueDate")) {
                adjustedDueDate = jsonCommand.localDateValueOfParameterNamed("adjustedDueDate");
            }
            LoanRescheduleRequest loanRescheduleRequest = LoanRescheduleRequest.instance((Loan)loan, (Integer)LoanStatus.SUBMITTED_AND_PENDING_APPROVAL.getValue(), (Integer)rescheduleFromInstallment, (LocalDate)rescheduleFromDate, (Boolean)recalculateInterest, (CodeValue)rescheduleReasonCodeValue, (String)rescheduleReasonComment, (LocalDate)submittedOnDate, (AppUser)this.platformSecurityContext.authenticatedUser(), null, null, null, null);
            ArrayList loanRescheduleRequestToTermVariationMappings = new ArrayList();
            Boolean isActive = false;
            boolean isSpecificToInstallment = false;
            BigDecimal decimalValue = null;
            LocalDate dueDate = null;
            this.createLoanTermVariationsForRegularLoans(loan, graceOnPrincipal, graceOnInterest, extraTerms, interestRate, rescheduleFromDate, adjustedDueDate, loanRescheduleRequest, loanRescheduleRequestToTermVariationMappings, isActive, false, decimalValue, dueDate, endDate, emi);
            this.loanRescheduleRequestRepository.saveAndFlush((Object)loanRescheduleRequest);
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId((Long)loanRescheduleRequest.getId()).withLoanId((Long)loan.getId()).withClientId(loan.getClientId()).withOfficeId(loan.getOfficeId()).withGroupId(loan.getGroupId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityViolation((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void createLoanTermVariationsForRegularLoans(Loan loan, Integer graceOnPrincipal, Integer graceOnInterest, Integer extraTerms, BigDecimal interestRate, LocalDate rescheduleFromDate, LocalDate adjustedDueDate, LoanRescheduleRequest loanRescheduleRequest, List<LoanRescheduleRequestToTermVariationMapping> loanRescheduleRequestToTermVariationMappings, Boolean isActive, boolean isSpecificToInstallment, BigDecimal decimalValue, LocalDate dueDate, LocalDate endDate, BigDecimal emi) {
        Integer termType;
        LoanTermVariations parent;
        if (rescheduleFromDate != null && endDate != null && emi != null) {
            parent = null;
            termType = LoanTermVariationType.EMI_AMOUNT.getValue();
            List installments = loan.getRepaymentScheduleInstallments();
            for (LoanRepaymentScheduleInstallment installment : installments) {
                if (!DateUtils.isBefore((LocalDate)installment.getDueDate(), (LocalDate)rescheduleFromDate) && !DateUtils.isAfter((LocalDate)installment.getDueDate(), (LocalDate)endDate)) {
                    this.createLoanTermVariations(loanRescheduleRequest, termType, loan, installment.getDueDate(), installment.getDueDate(), loanRescheduleRequestToTermVariationMappings, isActive, true, emi, parent);
                }
                if (!DateUtils.isAfter((LocalDate)installment.getDueDate(), (LocalDate)endDate)) continue;
                break;
            }
        }
        if (rescheduleFromDate != null && adjustedDueDate != null) {
            parent = null;
            termType = LoanTermVariationType.DUE_DATE.getValue();
            this.createLoanTermVariations(loanRescheduleRequest, termType, loan, rescheduleFromDate, adjustedDueDate, loanRescheduleRequestToTermVariationMappings, isActive, isSpecificToInstallment, decimalValue, parent);
        }
        if (rescheduleFromDate != null && interestRate != null) {
            parent = null;
            termType = LoanTermVariationType.INTEREST_RATE_FROM_INSTALLMENT.getValue();
            this.createLoanTermVariations(loanRescheduleRequest, termType, loan, rescheduleFromDate, dueDate, loanRescheduleRequestToTermVariationMappings, isActive, isSpecificToInstallment, interestRate, parent);
        }
        if (rescheduleFromDate != null && graceOnPrincipal != null) {
            Integer termType2 = LoanTermVariationType.GRACE_ON_PRINCIPAL.getValue();
            LoanTermVariations parent2 = null;
            parent2 = this.createLoanTermVariations(loanRescheduleRequest, termType2, loan, rescheduleFromDate, dueDate, loanRescheduleRequestToTermVariationMappings, isActive, isSpecificToInstallment, BigDecimal.valueOf(graceOnPrincipal.intValue()), parent2);
            BigDecimal extraTermsBasedOnGracePeriods = BigDecimal.valueOf(graceOnPrincipal.intValue());
            this.createLoanTermVariations(loanRescheduleRequest, LoanTermVariationType.EXTEND_REPAYMENT_PERIOD.getValue(), loan, rescheduleFromDate, dueDate, loanRescheduleRequestToTermVariationMappings, isActive, isSpecificToInstallment, extraTermsBasedOnGracePeriods, parent2);
        }
        if (rescheduleFromDate != null && graceOnInterest != null) {
            parent = null;
            termType = LoanTermVariationType.GRACE_ON_INTEREST.getValue();
            this.createLoanTermVariations(loanRescheduleRequest, termType, loan, rescheduleFromDate, dueDate, loanRescheduleRequestToTermVariationMappings, isActive, isSpecificToInstallment, BigDecimal.valueOf(graceOnInterest.intValue()), parent);
        }
        if (rescheduleFromDate != null && extraTerms != null) {
            parent = null;
            termType = LoanTermVariationType.EXTEND_REPAYMENT_PERIOD.getValue();
            this.createLoanTermVariations(loanRescheduleRequest, termType, loan, rescheduleFromDate, dueDate, loanRescheduleRequestToTermVariationMappings, isActive, isSpecificToInstallment, BigDecimal.valueOf(extraTerms.intValue()), parent);
        }
        loanRescheduleRequest.updateLoanRescheduleRequestToTermVariationMappings(loanRescheduleRequestToTermVariationMappings);
    }

    private LoanTermVariations createLoanTermVariations(LoanRescheduleRequest loanRescheduleRequest, Integer termType, Loan loan, LocalDate rescheduleFromDate, LocalDate adjustedDueDate, List<LoanRescheduleRequestToTermVariationMapping> loanRescheduleRequestToTermVariationMappings, Boolean isActive, boolean isSpecificToInstallment, BigDecimal decimalValue, LoanTermVariations parent) {
        LoanTermVariations loanTermVariation = new LoanTermVariations(termType, rescheduleFromDate, decimalValue, adjustedDueDate, isSpecificToInstallment, loan, loan.getStatus().getValue(), isActive, parent);
        loan.getLoanTermVariations().add(loanTermVariation);
        loanRescheduleRequestToTermVariationMappings.add(LoanRescheduleRequestToTermVariationMapping.createNew((LoanRescheduleRequest)loanRescheduleRequest, (LoanTermVariations)loanTermVariation));
        return loanTermVariation;
    }

    @Transactional
    public CommandProcessingResult approve(JsonCommand jsonCommand) {
        try {
            Long loanRescheduleRequestId = jsonCommand.entityId();
            LoanRescheduleRequest loanRescheduleRequest = (LoanRescheduleRequest)this.loanRescheduleRequestRepository.findById((Object)loanRescheduleRequestId).orElseThrow(() -> new LoanRescheduleRequestNotFoundException(loanRescheduleRequestId));
            this.loanRescheduleRequestDataValidator.validateForApproveAction(jsonCommand, loanRescheduleRequest);
            AppUser appUser = this.platformSecurityContext.authenticatedUser();
            LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
            LocalDate approvedOnDate = jsonCommand.localDateValueOfParameterNamed("approvedOnDate");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(jsonCommand.dateFormat()).withLocale(jsonCommand.extractLocale());
            changes.put("locale", jsonCommand.locale());
            changes.put("dateFormat", jsonCommand.dateFormat());
            changes.put("approvedOnDate", approvedOnDate.format(dateTimeFormatter));
            changes.put("approvedByUserId", appUser.getId());
            Loan loan = loanRescheduleRequest.getLoan();
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, loanRescheduleRequest.getRescheduleFromDate());
            List loanRepaymentScheduleHistoryList = this.loanScheduleHistoryWritePlatformService.createLoanScheduleArchive(loan.getRepaymentScheduleInstallments(), loan, loanRescheduleRequest);
            LoanApplicationTerms loanApplicationTerms = this.loanTermVariationsMapper.constructLoanApplicationTerms(scheduleGeneratorDTO, loan);
            LocalDate rescheduleFromDate = null;
            List activeLoanTermVariations = loan.getActiveLoanTermVariations();
            LoanTermVariations dueDateVariationInCurrentRequest = loanRescheduleRequest.getDueDateTermVariationIfExists();
            if (dueDateVariationInCurrentRequest != null && !activeLoanTermVariations.isEmpty()) {
                LocalDate fromScheduleDate = dueDateVariationInCurrentRequest.fetchTermApplicaDate();
                Object currentScheduleDate = fromScheduleDate;
                LocalDate modifiedScheduleDate = dueDateVariationInCurrentRequest.fetchDateValue();
                HashMap<Object, LocalDate> changeMap = new HashMap<Object, LocalDate>();
                changeMap.put(currentScheduleDate, modifiedScheduleDate);
                for (LoanTermVariations activeLoanTermVariation : activeLoanTermVariations) {
                    if (activeLoanTermVariation.getTermType().isDueDateVariation() && activeLoanTermVariation.fetchDateValue().equals(dueDateVariationInCurrentRequest.fetchTermApplicaDate())) {
                        activeLoanTermVariation.markAsInactive();
                        rescheduleFromDate = activeLoanTermVariation.fetchTermApplicaDate();
                        dueDateVariationInCurrentRequest.setTermApplicableFrom(rescheduleFromDate);
                        continue;
                    }
                    if (DateUtils.isBefore((LocalDate)activeLoanTermVariation.fetchTermApplicaDate(), (LocalDate)fromScheduleDate)) continue;
                    while (DateUtils.isBefore((LocalDate)currentScheduleDate, (LocalDate)activeLoanTermVariation.fetchTermApplicaDate())) {
                        currentScheduleDate = DEFAULT_SCHEDULED_DATE_GENERATOR.generateNextRepaymentDate((LocalDate)currentScheduleDate, loanApplicationTerms, false);
                        modifiedScheduleDate = DEFAULT_SCHEDULED_DATE_GENERATOR.generateNextRepaymentDate(modifiedScheduleDate, loanApplicationTerms, false);
                        changeMap.put(currentScheduleDate, modifiedScheduleDate);
                    }
                    if (!changeMap.containsKey(activeLoanTermVariation.fetchTermApplicaDate())) continue;
                    activeLoanTermVariation.setTermApplicableFrom((LocalDate)changeMap.get(activeLoanTermVariation.fetchTermApplicaDate()));
                }
            }
            if (rescheduleFromDate == null) {
                rescheduleFromDate = loanRescheduleRequest.getRescheduleFromDate();
            }
            boolean hasInterestRateChange = false;
            for (LoanRescheduleRequestToTermVariationMapping mapping : loanRescheduleRequest.getLoanRescheduleRequestToTermVariationMappings()) {
                mapping.getLoanTermVariations().updateIsActive(Boolean.valueOf(true));
                LoanTermVariationType termType = mapping.getLoanTermVariations().getTermType();
                if (!termType.isInterestRateVariation() && !termType.isInterestRateFromInstallment() && !termType.isExtendRepaymentPeriod()) continue;
                hasInterestRateChange = true;
            }
            BigDecimal annualNominalInterestRate = null;
            ArrayList loanTermVariations = new ArrayList();
            this.loanTermVariationsMapper.constructLoanTermVariations(scheduleGeneratorDTO.getFloatingRateDTO(), annualNominalInterestRate, loanTermVariations, loan);
            loanApplicationTerms.getLoanTermVariations().setExceptionData(loanTermVariations);
            MathContext mathContext = MoneyHelper.getMathContext();
            LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(loan.transactionProcessingStrategy());
            LoanScheduleGenerator loanScheduleGenerator = this.loanScheduleFactory.create(loanApplicationTerms.getLoanScheduleType(), loanApplicationTerms.getInterestMethod());
            LoanScheduleDTO loanScheduleDTO = loanScheduleGenerator.rescheduleNextInstallments(mathContext, loanApplicationTerms, loan, loanApplicationTerms.getHolidayDetailDTO(), loanRepaymentScheduleTransactionProcessor, rescheduleFromDate);
            if (loanScheduleDTO.getInstallments() != null) {
                this.loanSchedule.updateLoanSchedule(loan, loanScheduleDTO.getInstallments());
            } else {
                this.loanSchedule.updateLoanSchedule(loan, loanScheduleDTO.getLoanScheduleModel());
            }
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanChargeService.recalculateAllCharges(loan);
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
            this.loanRepaymentScheduleHistoryRepository.saveAll((Iterable)loanRepaymentScheduleHistoryList);
            loan.updateRescheduledByUser(appUser);
            loan.updateRescheduledOnDate(DateUtils.getBusinessLocalDate());
            loanRescheduleRequest.approve(appUser, approvedOnDate);
            Optional lastTransactionDateForReprocessing = this.loanTransactionRepository.findLastTransactionDateForReprocessing(loan);
            if (lastTransactionDateForReprocessing.isPresent()) {
                this.loanLifecycleStateMachine.determineAndTransition(loan, (LocalDate)lastTransactionDateForReprocessing.get());
            }
            loan = this.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, true, true);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRescheduledDueAdjustScheduleBusinessEvent(loan));
            if (hasInterestRateChange) {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(loanRescheduleRequestId).withLoanId((Long)loanRescheduleRequest.getLoan().getId()).with(changes).withClientId(loan.getClientId()).withOfficeId(loan.getOfficeId()).withGroupId(loan.getGroupId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityViolation((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private Loan saveAndFlushLoanWithDataIntegrityViolationChecks(Loan loan) {
        try {
            List installments = loan.getRepaymentScheduleInstallments();
            for (LoanRepaymentScheduleInstallment installment : installments) {
                if (installment.getId() != null) continue;
                this.repaymentScheduleInstallmentRepository.save((Object)installment);
            }
            return this.loanRepositoryWrapper.saveAndFlush(loan);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            Throwable realCause = e.getCause();
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
            if (realCause.getMessage().toLowerCase().contains("external_id_unique")) {
                baseDataValidator.reset().parameter("externalId").failWithCode("value.must.be.unique", new Object[0]);
            }
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, e);
            }
            throw e;
        }
    }

    @Transactional
    public CommandProcessingResult reject(JsonCommand jsonCommand) {
        try {
            Long loanRescheduleRequestId = jsonCommand.entityId();
            LoanRescheduleRequest loanRescheduleRequest = (LoanRescheduleRequest)this.loanRescheduleRequestRepository.findById((Object)loanRescheduleRequestId).orElseThrow(() -> new LoanRescheduleRequestNotFoundException(loanRescheduleRequestId));
            this.loanRescheduleRequestDataValidator.validateForRejectAction(jsonCommand, loanRescheduleRequest);
            AppUser appUser = this.platformSecurityContext.authenticatedUser();
            LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
            LocalDate rejectedOnDate = jsonCommand.localDateValueOfParameterNamed("rejectedOnDate");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(jsonCommand.dateFormat()).withLocale(jsonCommand.extractLocale());
            changes.put("locale", jsonCommand.locale());
            changes.put("dateFormat", jsonCommand.dateFormat());
            changes.put("rejectedOnDate", rejectedOnDate.format(dateTimeFormatter));
            changes.put("rejectedByUserId", appUser.getId());
            if (!changes.isEmpty()) {
                loanRescheduleRequest.reject(appUser, rejectedOnDate);
                Set loanRescheduleRequestToTermVariationMappings = loanRescheduleRequest.getLoanRescheduleRequestToTermVariationMappings();
                for (LoanRescheduleRequestToTermVariationMapping loanRescheduleRequestToTermVariationMapping : loanRescheduleRequestToTermVariationMappings) {
                    loanRescheduleRequestToTermVariationMapping.getLoanTermVariations().markAsInactive();
                }
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(loanRescheduleRequestId).withLoanId((Long)loanRescheduleRequest.getLoan().getId()).with(changes).withClientId(loanRescheduleRequest.getLoan().getClientId()).withOfficeId(loanRescheduleRequest.getLoan().getOfficeId()).withGroupId(loanRescheduleRequest.getLoan().getGroupId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityViolation((NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void handleDataIntegrityViolation(NonTransientDataAccessException dve) {
        log.error("Error occurred.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.loan.reschedule.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    @Generated
    public LoanRescheduleRequestWritePlatformServiceImpl(CodeValueRepositoryWrapper codeValueRepositoryWrapper, PlatformSecurityContext platformSecurityContext, @Qualifier(value="loanRescheduleRequestDataValidator") LoanRescheduleRequestDataValidator loanRescheduleRequestDataValidator, LoanRescheduleRequestRepository loanRescheduleRequestRepository, LoanRepaymentScheduleHistoryRepository loanRepaymentScheduleHistoryRepository, LoanScheduleHistoryWritePlatformService loanScheduleHistoryWritePlatformService, LoanRepositoryWrapper loanRepositoryWrapper, LoanAssembler loanAssembler, LoanUtilService loanUtilService, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, LoanScheduleGeneratorFactory loanScheduleFactory, LoanRepaymentScheduleInstallmentRepository repaymentScheduleInstallmentRepository, BusinessEventNotifierService businessEventNotifierService, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanChargeService loanChargeService, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanTermVariationsMapper loanTermVariationsMapper, LoanScheduleComponent loanSchedule, LoanTransactionRepository loanTransactionRepository, LoanLifecycleStateMachine loanLifecycleStateMachine) {
        this.codeValueRepositoryWrapper = codeValueRepositoryWrapper;
        this.platformSecurityContext = platformSecurityContext;
        this.loanRescheduleRequestDataValidator = loanRescheduleRequestDataValidator;
        this.loanRescheduleRequestRepository = loanRescheduleRequestRepository;
        this.loanRepaymentScheduleHistoryRepository = loanRepaymentScheduleHistoryRepository;
        this.loanScheduleHistoryWritePlatformService = loanScheduleHistoryWritePlatformService;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanAssembler = loanAssembler;
        this.loanUtilService = loanUtilService;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.loanScheduleFactory = loanScheduleFactory;
        this.repaymentScheduleInstallmentRepository = repaymentScheduleInstallmentRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanChargeService = loanChargeService;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanTermVariationsMapper = loanTermVariationsMapper;
        this.loanSchedule = loanSchedule;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
    }
}

