/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.loanaccount.data.DisbursementData;
import org.apache.fineract.portfolio.loanaccount.data.LoanPrincipalRelatedDataHolder;
import org.apache.fineract.portfolio.loanaccount.data.LoanSchedulePeriodDataWrapper;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallmentRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepaymentPeriodData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanSchedulePeriodData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.springframework.stereotype.Service;

@Service
public class LoanRepaymentScheduleService {
    private final LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository;

    public LoanScheduleData findLoanScheduleData(Long loanId, RepaymentScheduleRelatedLoanData repaymentScheduleRelatedLoanData, Collection<DisbursementData> disbursementData, Collection<LoanTransactionRepaymentPeriodData> capitalizedIncomeData, boolean isInterestRecalculationEnabled, LoanScheduleType loanScheduleType) {
        List installments = this.loanRepaymentScheduleInstallmentRepository.findByLoanId(loanId);
        return this.extractLoanScheduleData(installments, repaymentScheduleRelatedLoanData, disbursementData, capitalizedIncomeData, isInterestRecalculationEnabled, loanScheduleType);
    }

    public LoanScheduleData extractLoanScheduleData(List<LoanRepaymentScheduleInstallment> installments, RepaymentScheduleRelatedLoanData repaymentScheduleRelatedLoanData, Collection<DisbursementData> disbursementData, Collection<LoanTransactionRepaymentPeriodData> capitalizedIncomeData, boolean isInterestRecalculationEnabled, LoanScheduleType loanScheduleType) {
        CurrencyData currency = repaymentScheduleRelatedLoanData.getCurrency();
        DisbursementData disbursement = repaymentScheduleRelatedLoanData.disbursementData();
        BigDecimal totalFeeChargesDueAtDisbursement = repaymentScheduleRelatedLoanData.getTotalFeeChargesAtDisbursement();
        LocalDate lastDueDate = disbursement.disbursementDate();
        BigDecimal outstandingLoanPrincipalBalance = disbursement.getPrincipal();
        boolean excludePastUnDisbursed = LoanScheduleType.PROGRESSIVE.equals((Object)loanScheduleType) && isInterestRecalculationEnabled;
        BigDecimal waivedChargeAmount = BigDecimal.ZERO;
        for (DisbursementData disbursementDetail : disbursementData) {
            waivedChargeAmount = waivedChargeAmount.add(disbursementDetail.getWaivedChargeAmount());
        }
        LoanSchedulePeriodData disbursementPeriod = LoanSchedulePeriodData.disbursementOnlyPeriod((LocalDate)disbursement.disbursementDate(), (BigDecimal)disbursement.getPrincipal(), (BigDecimal)totalFeeChargesDueAtDisbursement, (boolean)disbursement.isDisbursed());
        ArrayList<LoanSchedulePeriodData> periods = new ArrayList<LoanSchedulePeriodData>();
        MonetaryCurrency monCurrency = new MonetaryCurrency(currency.getCode(), currency.getDecimalPlaces(), currency.getInMultiplesOf());
        BigDecimal totalPrincipalDisbursed = BigDecimal.ZERO;
        BigDecimal disbursementChargeAmount = totalFeeChargesDueAtDisbursement;
        if (disbursementData.isEmpty()) {
            periods.add(disbursementPeriod);
            totalPrincipalDisbursed = Money.of((MonetaryCurrency)monCurrency, (BigDecimal)disbursement.getPrincipal()).getAmount();
        } else {
            if (!disbursement.isDisbursed()) {
                excludePastUnDisbursed = false;
            }
            for (DisbursementData data : disbursementData) {
                if (data.getChargeAmount() == null) continue;
                disbursementChargeAmount = disbursementChargeAmount.subtract(data.getChargeAmount());
            }
            outstandingLoanPrincipalBalance = BigDecimal.ZERO;
        }
        Money totalPrincipalExpected = Money.zero((MonetaryCurrency)monCurrency);
        Money totalPrincipalPaid = Money.zero((MonetaryCurrency)monCurrency);
        Money totalInterestCharged = Money.zero((MonetaryCurrency)monCurrency);
        Money totalFeeChargesCharged = Money.zero((MonetaryCurrency)monCurrency);
        Money totalPenaltyChargesCharged = Money.zero((MonetaryCurrency)monCurrency);
        Money totalWaived = Money.zero((MonetaryCurrency)monCurrency);
        Money totalWrittenOff = Money.zero((MonetaryCurrency)monCurrency);
        Money totalRepaymentExpected = Money.zero((MonetaryCurrency)monCurrency);
        Money totalRepayment = Money.zero((MonetaryCurrency)monCurrency);
        Money totalPaidInAdvance = Money.zero((MonetaryCurrency)monCurrency);
        Money totalPaidLate = Money.zero((MonetaryCurrency)monCurrency);
        Money totalOutstanding = Money.zero((MonetaryCurrency)monCurrency);
        Money totalCredits = Money.zero((MonetaryCurrency)monCurrency);
        totalFeeChargesCharged = totalFeeChargesCharged.plus(disbursementPeriod.getFeeChargesDue().subtract(waivedChargeAmount));
        totalRepaymentExpected = totalRepaymentExpected.plus(disbursementPeriod.getFeeChargesDue()).minus(waivedChargeAmount);
        totalRepayment = totalRepayment.plus(disbursementPeriod.getFeeChargesPaid()).minus(waivedChargeAmount);
        totalOutstanding = totalOutstanding.plus(disbursementPeriod.getFeeChargesDue()).minus(disbursementPeriod.getFeeChargesPaid());
        Integer loanTermInDays = 0;
        HashSet disbursementPeriodIds = new HashSet();
        for (LoanRepaymentScheduleInstallment installment : installments) {
            Integer period = installment.getInstallmentNumber();
            LocalDate fromDate = installment.getFromDate();
            LocalDate dueDate = installment.getDueDate();
            LocalDate obligationsMetOnDate = installment.getObligationsMetOnDate();
            boolean complete = installment.isObligationsMet();
            ArrayList combinedDataList = new ArrayList();
            combinedDataList.addAll(this.collectEligibleDisbursementData(loanScheduleType, disbursementData, fromDate, dueDate, disbursementPeriodIds, disbursement, excludePastUnDisbursed));
            combinedDataList.addAll(this.collectEligibleCapitalizedIncomeData(capitalizedIncomeData, fromDate, dueDate, disbursementPeriodIds));
            combinedDataList.sort((arg_0, arg_1) -> this.sortPeriodDataHolders(arg_0, arg_1));
            outstandingLoanPrincipalBalance = this.fillLoanSchedulePeriodData(periods, combinedDataList, disbursementChargeAmount, waivedChargeAmount, outstandingLoanPrincipalBalance);
            BigDecimal disbursedAmount = this.calculateDisbursedAmount(combinedDataList);
            BigDecimal principalCredits = installment.getCreditedPrincipal() != null ? installment.getCreditedPrincipal() : BigDecimal.ZERO;
            BigDecimal feeCredits = installment.getCreditedFee() != null ? installment.getCreditedFee() : BigDecimal.ZERO;
            BigDecimal penaltyCredits = installment.getCreditedPenalty() != null ? installment.getCreditedPenalty() : BigDecimal.ZERO;
            BigDecimal credits = principalCredits.add(feeCredits).add(penaltyCredits);
            outstandingLoanPrincipalBalance = outstandingLoanPrincipalBalance.add(principalCredits);
            totalPrincipalDisbursed = totalPrincipalDisbursed.add(disbursedAmount);
            Integer daysInPeriod = 0;
            if (fromDate != null) {
                daysInPeriod = DateUtils.getExactDifferenceInDays((LocalDate)fromDate, (LocalDate)dueDate);
                loanTermInDays = loanTermInDays + daysInPeriod;
            }
            BigDecimal principalDue = installment.getPrincipal() != null ? installment.getPrincipal() : BigDecimal.ZERO;
            totalPrincipalExpected = totalPrincipalExpected.plus(principalDue);
            BigDecimal principalPaid = installment.getPrincipalCompleted() != null ? installment.getPrincipalCompleted() : BigDecimal.ZERO;
            totalPrincipalPaid = totalPrincipalPaid.plus(principalPaid);
            BigDecimal principalWrittenOff = installment.getPrincipalWrittenOff() != null ? installment.getPrincipalWrittenOff() : BigDecimal.ZERO;
            BigDecimal principalOutstanding = principalDue.subtract(principalPaid).subtract(principalWrittenOff);
            BigDecimal interestExpectedDue = installment.getInterestCharged() != null ? installment.getInterestCharged() : BigDecimal.ZERO;
            totalInterestCharged = totalInterestCharged.plus(interestExpectedDue);
            BigDecimal interestPaid = installment.getInterestPaid() != null ? installment.getInterestPaid() : BigDecimal.ZERO;
            BigDecimal interestWaived = installment.getInterestWaived() != null ? installment.getInterestWaived() : BigDecimal.ZERO;
            BigDecimal interestWrittenOff = installment.getInterestWrittenOff() != null ? installment.getInterestWrittenOff() : BigDecimal.ZERO;
            BigDecimal accrualInterest = installment.getInterestAccrued() != null ? installment.getInterestAccrued() : BigDecimal.ZERO;
            BigDecimal interestActualDue = interestExpectedDue.subtract(interestWaived).subtract(interestWrittenOff);
            BigDecimal interestOutstanding = interestActualDue.subtract(interestPaid);
            BigDecimal feeChargesExpectedDue = installment.getFeeChargesCharged() != null ? installment.getFeeChargesCharged() : BigDecimal.ZERO;
            totalFeeChargesCharged = totalFeeChargesCharged.plus(feeChargesExpectedDue);
            BigDecimal feeChargesPaid = installment.getFeeChargesPaid() != null ? installment.getFeeChargesPaid() : BigDecimal.ZERO;
            BigDecimal feeChargesWaived = installment.getFeeChargesWaived() != null ? installment.getFeeChargesWaived() : BigDecimal.ZERO;
            BigDecimal feeChargesWrittenOff = installment.getFeeChargesWrittenOff() != null ? installment.getFeeChargesWrittenOff() : BigDecimal.ZERO;
            BigDecimal feeChargesActualDue = feeChargesExpectedDue.subtract(feeChargesWaived).subtract(feeChargesWrittenOff);
            BigDecimal feeChargesOutstanding = feeChargesActualDue.subtract(feeChargesPaid);
            BigDecimal penaltyChargesExpectedDue = installment.getPenaltyCharges() != null ? installment.getPenaltyCharges() : BigDecimal.ZERO;
            totalPenaltyChargesCharged = totalPenaltyChargesCharged.plus(penaltyChargesExpectedDue);
            BigDecimal penaltyChargesPaid = installment.getPenaltyChargesPaid() != null ? installment.getPenaltyChargesPaid() : BigDecimal.ZERO;
            BigDecimal penaltyChargesWaived = installment.getPenaltyChargesWaived() != null ? installment.getPenaltyChargesWaived() : BigDecimal.ZERO;
            BigDecimal penaltyChargesWrittenOff = installment.getPenaltyChargesWrittenOff() != null ? installment.getPenaltyChargesWrittenOff() : BigDecimal.ZERO;
            BigDecimal totalPaidInAdvanceForPeriod = installment.getTotalPaidInAdvance() != null ? installment.getTotalPaidInAdvance() : BigDecimal.ZERO;
            BigDecimal totalPaidLateForPeriod = installment.getTotalPaidLate() != null ? installment.getTotalPaidLate() : BigDecimal.ZERO;
            BigDecimal penaltyChargesActualDue = penaltyChargesExpectedDue.subtract(penaltyChargesWaived).subtract(penaltyChargesWrittenOff);
            BigDecimal penaltyChargesOutstanding = penaltyChargesActualDue.subtract(penaltyChargesPaid);
            BigDecimal totalExpectedCostOfLoanForPeriod = interestExpectedDue.add(feeChargesExpectedDue).add(penaltyChargesExpectedDue);
            BigDecimal totalDueForPeriod = principalDue.add(totalExpectedCostOfLoanForPeriod);
            BigDecimal totalPaidForPeriod = principalPaid.add(interestPaid).add(feeChargesPaid).add(penaltyChargesPaid);
            BigDecimal totalWaivedForPeriod = interestWaived.add(feeChargesWaived).add(penaltyChargesWaived);
            totalWaived = totalWaived.plus(totalWaivedForPeriod);
            BigDecimal totalWrittenOffForPeriod = principalWrittenOff.add(interestWrittenOff).add(feeChargesWrittenOff).add(penaltyChargesWrittenOff);
            totalWrittenOff = totalWrittenOff.plus(totalWrittenOffForPeriod);
            BigDecimal totalOutstandingForPeriod = principalOutstanding.add(interestOutstanding).add(feeChargesOutstanding).add(penaltyChargesOutstanding);
            totalRepaymentExpected = totalRepaymentExpected.plus(totalDueForPeriod);
            totalRepayment = totalRepayment.plus(totalPaidForPeriod);
            totalPaidInAdvance = totalPaidInAdvance.plus(totalPaidInAdvanceForPeriod);
            totalPaidLate = totalPaidLate.plus(totalPaidLateForPeriod);
            totalOutstanding = totalOutstanding.plus(totalOutstandingForPeriod);
            totalCredits = totalCredits.add(credits);
            if (fromDate == null) {
                fromDate = lastDueDate;
            }
            BigDecimal outstandingPrincipalBalanceOfLoan = outstandingLoanPrincipalBalance.subtract(principalDue);
            lastDueDate = dueDate;
            outstandingLoanPrincipalBalance = outstandingLoanPrincipalBalance.subtract(principalDue);
            boolean isDownPayment = installment.isDownPayment();
            LoanSchedulePeriodData periodData = LoanSchedulePeriodData.periodWithPayments((Integer)period, (LocalDate)fromDate, (LocalDate)dueDate, (LocalDate)obligationsMetOnDate, (boolean)complete, (BigDecimal)principalDue, (BigDecimal)principalPaid, (BigDecimal)principalWrittenOff, (BigDecimal)principalOutstanding, (BigDecimal)outstandingPrincipalBalanceOfLoan, (BigDecimal)interestExpectedDue, (BigDecimal)interestPaid, (BigDecimal)interestWaived, (BigDecimal)interestWrittenOff, (BigDecimal)interestOutstanding, (BigDecimal)feeChargesExpectedDue, (BigDecimal)feeChargesPaid, (BigDecimal)feeChargesWaived, (BigDecimal)feeChargesWrittenOff, (BigDecimal)feeChargesOutstanding, (BigDecimal)penaltyChargesExpectedDue, (BigDecimal)penaltyChargesPaid, (BigDecimal)penaltyChargesWaived, (BigDecimal)penaltyChargesWrittenOff, (BigDecimal)penaltyChargesOutstanding, (BigDecimal)totalPaidForPeriod, (BigDecimal)totalPaidInAdvanceForPeriod, (BigDecimal)totalPaidLateForPeriod, (BigDecimal)totalWaivedForPeriod, (BigDecimal)totalWrittenOffForPeriod, (BigDecimal)credits, (boolean)isDownPayment, (BigDecimal)accrualInterest);
            periods.add(periodData);
        }
        return new LoanScheduleData(currency, periods, loanTermInDays, totalPrincipalDisbursed, totalPrincipalExpected.getAmount(), totalPrincipalPaid.getAmount(), totalInterestCharged.getAmount(), totalFeeChargesCharged.getAmount(), totalPenaltyChargesCharged.getAmount(), totalWaived.getAmount(), totalWrittenOff.getAmount(), totalRepaymentExpected.getAmount(), totalRepayment.getAmount(), totalPaidInAdvance.getAmount(), totalPaidLate.getAmount(), totalOutstanding.getAmount(), totalCredits.getAmount());
    }

    private List<LoanSchedulePeriodDataWrapper> collectEligibleDisbursementData(LoanScheduleType loanScheduleType, Collection<DisbursementData> disbursementData, LocalDate fromDate, LocalDate dueDate, Set<Long> disbursementPeriodIds, DisbursementData mainDisbursement, boolean excludePastUnDisbursed) {
        ArrayList<LoanSchedulePeriodDataWrapper> disbursementDataList = new ArrayList<LoanSchedulePeriodDataWrapper>();
        boolean hasMultipleTranchesOnSameDate = this.hasMultipleTranchesOnSameDate(disbursementData);
        if (hasMultipleTranchesOnSameDate) {
            HashMap<LocalDate, List> disbursementsByDate = new HashMap<LocalDate, List>();
            for (DisbursementData disbursementData2 : disbursementData) {
                boolean isDueForDisbursement = disbursementData2.isDueForDisbursement(loanScheduleType, fromDate, dueDate);
                boolean isEligible = (fromDate.equals(mainDisbursement.disbursementDate()) && disbursementData2.disbursementDate().equals(fromDate) || fromDate.equals(dueDate) && disbursementData2.disbursementDate().equals(fromDate) || this.canAddDisbursementData(disbursementData2, isDueForDisbursement, excludePastUnDisbursed)) && !disbursementPeriodIds.contains(disbursementData2.getId());
                if (!isEligible) continue;
                disbursementsByDate.computeIfAbsent(disbursementData2.disbursementDate(), k -> new ArrayList()).add(disbursementData2);
                disbursementPeriodIds.add(disbursementData2.getId());
            }
            for (Map.Entry entry : disbursementsByDate.entrySet()) {
                List sameDateDisbursements = (List)entry.getValue();
                if (sameDateDisbursements.size() > 1) {
                    List disbursedTranches = sameDateDisbursements.stream().filter(DisbursementData::isDisbursed).collect(Collectors.toList());
                    if (!disbursedTranches.isEmpty()) {
                        for (DisbursementData data : disbursedTranches) {
                            disbursementDataList.add(new LoanSchedulePeriodDataWrapper((LoanPrincipalRelatedDataHolder)data, data.disbursementDate(), true, data.isDisbursed()));
                        }
                        continue;
                    }
                    for (DisbursementData data : sameDateDisbursements) {
                        disbursementDataList.add(new LoanSchedulePeriodDataWrapper((LoanPrincipalRelatedDataHolder)data, data.disbursementDate(), true, data.isDisbursed()));
                    }
                    continue;
                }
                DisbursementData data = (DisbursementData)sameDateDisbursements.get(0);
                disbursementDataList.add(new LoanSchedulePeriodDataWrapper((LoanPrincipalRelatedDataHolder)data, data.disbursementDate(), true, data.isDisbursed()));
            }
        } else {
            for (DisbursementData data : disbursementData) {
                boolean bl = data.isDueForDisbursement(loanScheduleType, fromDate, dueDate);
                boolean isEligible = (fromDate.equals(mainDisbursement.disbursementDate()) && data.disbursementDate().equals(fromDate) || fromDate.equals(dueDate) && data.disbursementDate().equals(fromDate) || this.canAddDisbursementData(data, bl, excludePastUnDisbursed)) && !disbursementPeriodIds.contains(data.getId());
                if (!isEligible) continue;
                disbursementDataList.add(new LoanSchedulePeriodDataWrapper((LoanPrincipalRelatedDataHolder)data, data.disbursementDate(), true, data.isDisbursed()));
                disbursementPeriodIds.add(data.getId());
            }
        }
        return disbursementDataList;
    }

    private boolean hasMultipleTranchesOnSameDate(Collection<DisbursementData> disbursementData) {
        if (disbursementData == null || disbursementData.size() <= 1) {
            return false;
        }
        return disbursementData.stream().collect(Collectors.groupingBy(DisbursementData::disbursementDate, Collectors.counting())).values().stream().anyMatch(count -> count > 1L);
    }

    private List<LoanSchedulePeriodDataWrapper> collectEligibleCapitalizedIncomeData(Collection<LoanTransactionRepaymentPeriodData> capitalizedIncomeData, LocalDate fromDate, LocalDate dueDate, Set<Long> disbursementPeriodIds) {
        ArrayList<LoanSchedulePeriodDataWrapper> capitalizedIncomeDataList = new ArrayList<LoanSchedulePeriodDataWrapper>();
        for (LoanTransactionRepaymentPeriodData data : capitalizedIncomeData) {
            boolean isEligible = this.canAddCapitalizedIncomeData(data, fromDate, dueDate) && !disbursementPeriodIds.contains(data.getTransactionId());
            if (!isEligible) continue;
            capitalizedIncomeDataList.add(new LoanSchedulePeriodDataWrapper((LoanPrincipalRelatedDataHolder)data, data.getDate(), false, false));
            disbursementPeriodIds.add(data.getTransactionId());
        }
        return capitalizedIncomeDataList;
    }

    private BigDecimal fillLoanSchedulePeriodData(List<LoanSchedulePeriodData> periods, List<LoanSchedulePeriodDataWrapper> combinedDataList, BigDecimal disbursementChargeAmount, BigDecimal waivedChargeAmount, BigDecimal outstandingLoanPrincipalBalance) {
        for (LoanSchedulePeriodDataWrapper dataItem : combinedDataList) {
            LoanSchedulePeriodData periodData;
            if (dataItem.isDisbursement()) {
                data = (DisbursementData)dataItem.getData();
                periodData = this.createLoanSchedulePeriodData(data, disbursementChargeAmount, waivedChargeAmount);
            } else {
                data = (LoanTransactionRepaymentPeriodData)dataItem.getData();
                periodData = this.createLoanSchedulePeriodData((LoanTransactionRepaymentPeriodData)data);
            }
            periods.add(periodData);
            outstandingLoanPrincipalBalance = outstandingLoanPrincipalBalance.add(periodData.getPrincipalDisbursed());
        }
        return outstandingLoanPrincipalBalance;
    }

    private BigDecimal calculateDisbursedAmount(List<LoanSchedulePeriodDataWrapper> combinedDataList) {
        BigDecimal disbursedAmount = BigDecimal.ZERO;
        for (LoanSchedulePeriodDataWrapper dataItem : combinedDataList) {
            if (!dataItem.isDisbursement()) continue;
            DisbursementData data = (DisbursementData)dataItem.getData();
            disbursedAmount = disbursedAmount.add(data.getPrincipal());
        }
        return disbursedAmount;
    }

    private int sortPeriodDataHolders(LoanSchedulePeriodDataWrapper item1, LoanSchedulePeriodDataWrapper item2) {
        int dateComparison = item1.getDate().compareTo(item2.getDate());
        if (dateComparison == 0 && item1.isDisbursement() != item2.isDisbursement()) {
            return item1.isDisbursement() ? -1 : 1;
        }
        return dateComparison;
    }

    private LoanSchedulePeriodData createLoanSchedulePeriodData(DisbursementData data, BigDecimal disbursementChargeAmount, BigDecimal waivedChargeAmount) {
        BigDecimal chargeAmount = data.getChargeAmount() == null ? disbursementChargeAmount : disbursementChargeAmount.add(data.getChargeAmount()).subtract(waivedChargeAmount);
        return LoanSchedulePeriodData.disbursementOnlyPeriod((LocalDate)data.disbursementDate(), (BigDecimal)data.getPrincipal(), (BigDecimal)chargeAmount, (boolean)data.isDisbursed());
    }

    private LoanSchedulePeriodData createLoanSchedulePeriodData(LoanTransactionRepaymentPeriodData data) {
        BigDecimal feeCharges = Objects.isNull(data.getFeeChargesPortion()) ? BigDecimal.ZERO : data.getFeeChargesPortion();
        return LoanSchedulePeriodData.disbursementOnlyPeriod((LocalDate)data.getDate(), (BigDecimal)data.getAmount(), (BigDecimal)feeCharges, (!data.isReversed() ? 1 : 0) != 0);
    }

    private boolean canAddDisbursementData(DisbursementData data, boolean isDueForDisbursement, boolean excludePastUnDisbursed) {
        return (!excludePastUnDisbursed || data.isDisbursed() || !DateUtils.isBeforeBusinessDate((LocalDate)data.disbursementDate())) && isDueForDisbursement;
    }

    private boolean canAddCapitalizedIncomeData(LoanTransactionRepaymentPeriodData data, LocalDate fromDate, LocalDate dueDate) {
        return !data.isReversed() && DateUtils.isDateInRangeFromInclusiveToExclusive((LocalDate)fromDate, (LocalDate)dueDate, (LocalDate)data.getDate());
    }

    @Generated
    public LoanRepaymentScheduleService(LoanRepaymentScheduleInstallmentRepository loanRepaymentScheduleInstallmentRepository) {
        this.loanRepaymentScheduleInstallmentRepository = loanRepaymentScheduleInstallmentRepository;
    }
}

