/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.productmix.domain;

import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_product_mix")
public class ProductMix
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne
    @JoinColumn(name="product_id", nullable=false)
    private LoanProduct product;
    @ManyToOne
    @JoinColumn(name="restricted_product_id", nullable=false)
    private LoanProduct restrictedProduct;
    static final long serialVersionUID = -48235760782882263L;

    public ProductMix() {
    }

    private ProductMix(LoanProduct product, LoanProduct restrictedProduct) {
        this.product = product;
        this.restrictedProduct = restrictedProduct;
    }

    public static ProductMix createNew(LoanProduct product, LoanProduct restrictedProduct) {
        return new ProductMix(product, restrictedProduct);
    }

    public Long getRestrictedProductId() {
        return (Long)this._persistence_get_restrictedProduct().getId();
    }

    public Long getProductId() {
        return (Long)this._persistence_get_product().getId();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProductMix(persistenceObject);
    }

    public ProductMix(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "product") {
            return this.product;
        }
        if (string == "restrictedProduct") {
            return this.restrictedProduct;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "product") {
            this.product = (LoanProduct)object;
            return;
        }
        if (string == "restrictedProduct") {
            this.restrictedProduct = (LoanProduct)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public LoanProduct _persistence_get_product() {
        this._persistence_checkFetched("product");
        return this.product;
    }

    public void _persistence_set_product(LoanProduct loanProduct) {
        this._persistence_checkFetchedForSet("product");
        this._persistence_propertyChange("product", (Object)this.product, (Object)loanProduct);
        this.product = loanProduct;
    }

    public LoanProduct _persistence_get_restrictedProduct() {
        this._persistence_checkFetched("restrictedProduct");
        return this.restrictedProduct;
    }

    public void _persistence_set_restrictedProduct(LoanProduct loanProduct) {
        this._persistence_checkFetchedForSet("restrictedProduct");
        this._persistence_propertyChange("restrictedProduct", (Object)this.restrictedProduct, (Object)loanProduct);
        this.restrictedProduct = loanProduct;
    }
}

