/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositsApiConstants;
import org.apache.fineract.portfolio.savings.api.RecurringDepositAccountsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.data.DepositAccountData;
import org.apache.fineract.portfolio.savings.data.RecurringDepositAccountData;
import org.apache.fineract.portfolio.savings.service.DepositAccountPreMatureCalculationPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/recurringdepositaccounts")
@Component
@Tag(name="Recurring Deposit Account", description="Recurring Deposit accounts are instances of a praticular recurring deposit product created. An application process around the creation of accounts is also supported.")
public class RecurringDepositAccountsApiResource {
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<DepositAccountData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService;
    private final FromJsonHelper fromJsonHelper;
    private final DepositAccountPreMatureCalculationPlatformService accountPreMatureCalculationPlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve recurring Deposit Account Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for recurring deposit applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Requests:\n\nrecurringdepositaccounts/template?clientId=1\n\n\nrecurringdepositaccounts/template?clientId=1&productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.GetRecurringDepositAccountsTemplateResponse.class))})})
    public String template(@QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="groupId") @Parameter(description="groupId") Long groupId, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositaccount");
        DepositAccountData account = this.depositAccountReadPlatformService.retrieveTemplate(DepositAccountType.RECURRING_DEPOSIT, clientId, groupId, productId, staffInSelectedOfficeOnly);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)account, DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Recurring deposit applications/accounts", description="Lists Recurring deposit applications/accounts\n\nExample Requests:\n\nrecurringdepositaccounts\n\n\nrecurringdepositaccounts?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.GetRecurringDepositAccountsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="paged") @Parameter(description="paged") Boolean paged, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositaccount");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        PaginationParameters paginationParameters = PaginationParameters.builder().paged(Boolean.TRUE.equals(paged)).limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (paginationParameters.isPaged()) {
            Page account = this.depositAccountReadPlatformService.retrieveAllPaged(DepositAccountType.RECURRING_DEPOSIT, paginationParameters);
            return this.toApiJsonSerializer.serialize(settings, account, DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
        }
        Collection account = this.depositAccountReadPlatformService.retrieveAll(DepositAccountType.RECURRING_DEPOSIT, paginationParameters);
        return this.toApiJsonSerializer.serialize(settings, account, DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Submit new recurring deposit application", description="Submits new recurring deposit application\n\nMandatory Fields: clientId or groupId, productId, submittedOnDate, depositAmount, depositPeriod, depositPeriodFrequencyId\n\nOptional Fields: accountNo, externalId, fieldOfficerId,linkAccountId(if provided initial deposit amount will be collected from this account),transferInterestToSavings(By enabling this flag all interest postings will be transferred to linked saving account )\n\nInherited from Product (if not provided): interestCompoundingPeriodType, interestCalculationType, interestCalculationDaysInYearType, lockinPeriodFrequency, lockinPeriodFrequencyType, preClosurePenalApplicable, preClosurePenalInterest, preClosurePenalInterestOnTypeId, charts, withHoldTax")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.PostRecurringDepositAccountsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.PostRecurringDepositAccountsResponse.class))})})
    public String submitApplication(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createRecurringDepositAccount().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a recurring deposit application/account", description="Retrieves a recurring deposit application/account\n\nExample Requests :\n\nrecurringdepositaccounts/1\n\n\nrecurringdepositaccounts/1?associations=all")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.GetRecurringDepositAccountsAccountIdResponse.class))})})
    public String retrieveOne(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositaccount");
        if (!(this.is(chargeStatus, "all") || this.is(chargeStatus, "active") || this.is(chargeStatus, "inactive"))) {
            throw new UnrecognizedQueryParamException("status", chargeStatus, new Object[]{"all", "active", "inactive"});
        }
        RecurringDepositAccountData account = (RecurringDepositAccountData)this.depositAccountReadPlatformService.retrieveOneWithChartSlabs(DepositAccountType.RECURRING_DEPOSIT, accountId);
        HashSet mandatoryResponseParameters = new HashSet();
        RecurringDepositAccountData accountTemplate = this.populateTemplateAndAssociations(accountId, account, staffInSelectedOfficeOnly, chargeStatus, uriInfo, mandatoryResponseParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters(), mandatoryResponseParameters);
        return this.toApiJsonSerializer.serialize(settings, (Object)accountTemplate, DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    private RecurringDepositAccountData populateTemplateAndAssociations(Long accountId, RecurringDepositAccountData savingsAccount, boolean staffInSelectedOfficeOnly, String chargeStatus, UriInfo uriInfo, Set<String> mandatoryResponseParameters) {
        Collection transactions = null;
        Collection charges = null;
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("transactions", "charges"));
            }
            if (associationParameters.contains("transactions")) {
                mandatoryResponseParameters.add("transactions");
                Collection currentTransactions = this.depositAccountReadPlatformService.retrieveAllTransactions(DepositAccountType.RECURRING_DEPOSIT, accountId);
                if (!CollectionUtils.isEmpty((Collection)currentTransactions)) {
                    transactions = currentTransactions;
                }
            }
            if (associationParameters.contains("charges")) {
                mandatoryResponseParameters.add("charges");
                Collection currentCharges = this.savingsAccountChargeReadPlatformService.retrieveSavingsAccountCharges(accountId, chargeStatus);
                if (!CollectionUtils.isEmpty((Collection)currentCharges)) {
                    charges = currentCharges;
                }
            }
        }
        RecurringDepositAccountData templateData = null;
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            templateData = (RecurringDepositAccountData)this.depositAccountReadPlatformService.retrieveTemplate(DepositAccountType.RECURRING_DEPOSIT, savingsAccount.getClientId(), savingsAccount.getGroupId(), savingsAccount.getDepositProductId(), staffInSelectedOfficeOnly);
        }
        return RecurringDepositAccountData.withTemplateOptions((RecurringDepositAccountData)savingsAccount, templateData, transactions, charges);
    }

    @PUT
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a recurring deposit application", description="Recurring deposit application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method. Specific api endpoints will be created to allow change of interest detail such as rate, compounding period, posting period etc")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.PutRecurringDepositAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.PutRecurringDepositAccountsAccountIdResponse.class))})})
    public String update(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateRecurringDepositAccount(accountId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve recurring deposit application | Undo approval recurring deposit application | Reject recurring deposit application | Withdraw recurring deposit application | Activate a recurring deposit account | Update the recommended deposit amount for a recurring deposit account | Close a recurring deposit account | Premature Close a recurring deposit account | Calculate Premature amount on Recurring deposit account | Calculate Interest on recurring Deposit Account | Post Interest on recurring Deposit Account", description="Approve recurring deposit application:\n\nApproves recurring deposit application so long as its in 'Submitted and pending approval' state.\n\nUndo approval recurring deposit application:\n\nWill move 'approved' recurring deposit application back to 'Submitted and pending approval' state.\n\nReject recurring deposit application\n\nRejects recurring deposit application so long as its in 'Submitted and pending approval' state.\n\nWithdraw recurring deposit application:\n\nUsed when an applicant withdraws from the recurring deposit application. It must be in 'Submitted and pending approval' state.\n\nActivate a recurring deposit account:\n\nResults in an approved recurring deposit application being converted into an 'active' recurring deposit account.\n\nUpdate the recommended deposit amount for a recurring deposit account:\n\nUpdates the recommended deposit amount for a RD account as on the effective date.\n\nClose a recurring deposit account\n\nResults in a Matured recurring deposit account being converted into a 'closed' recurring deposit account.\n\nOn account close allowed actions are.Premature Close a recurring deposit account:\n\nResults in an Active recurring deposit account being converted into a 'Premature Closed' recurring deposit account with options to withdraw prematured amount. (premature amount is calculated using interest rate chart applicable along with penal interest if any.)\n\nOn account premature closure allowed actions are.\n\nCalculate Premature amount on Recurring deposit account:\n\nCalculate premature amount on recurring deposit till premature close date. Premature amount is calculated based on interest chart and penal interest applicable if any.\n\nCalculate Interest on recurring Deposit Account:\n\nCalculates interest earned on a recurring deposit account based on todays date. It does not attempt to post or credit the interest on the account. That is responsibility of the Post Interest API that will likely be called by overnight process.\n\nPost Interest on recurring Deposit Account:\n\nCalculates and Posts interest earned on a recurring deposit account based on todays date and whether an interest posting or crediting event is due.\n\nShowing request/response for 'Post Interest on recurring Deposit Account'")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.PostRecurringDepositAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.PostRecurringDepositAccountsAccountIdResponse.class))})})
    public String handleCommands(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "reject")) {
            CommandWrapper commandRequest = builder.rejectRecurringDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "withdrawnByApplicant")) {
            CommandWrapper commandRequest = builder.withdrawRecurringDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "approve")) {
            CommandWrapper commandRequest = builder.approveRecurringDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "undoapproval")) {
            CommandWrapper commandRequest = builder.undoRecurringDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.recurringDepositAccountActivation(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "calculateInterest")) {
            CommandWrapper commandRequest = builder.withNoJsonBody().recurringDepositAccountInterestCalculation(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "updateDepositAmount")) {
            CommandWrapper commandRequest = builder.updateDepositAmountForRecurringDepositAccount(accountId).withJson(apiRequestBodyAsJson).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "postInterest")) {
            CommandWrapper commandRequest = builder.recurringDepositAccountInterestPosting(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeRecurringDepositAccount(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "prematureClose")) {
            CommandWrapper commandRequest = builder.prematureCloseRecurringDepositAccount(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "calculatePrematureAmount")) {
            JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
            JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            DepositAccountData account = this.accountPreMatureCalculationPlatformService.calculatePreMatureAmount(accountId, query, DepositAccountType.RECURRING_DEPOSIT);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)account, DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"reject", "withdrawnByApplicant", "approve", "undoapproval", "activate", "calculateInterest", "postInterest", "close", "prematureClose", "calculatePrematureAmount"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @DELETE
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a recurring deposit application", description="At present we support hard delete of recurring deposit application so long as its in 'Submitted and pending approval' state. One the application is moves past this state, it is not possible to do a 'hard' delete of the application or the account. An API endpoint will be added to close/de-activate the recurring deposit account.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RecurringDepositAccountsApiResourceSwagger.DeleteRecurringDepositAccountsResponse.class))})})
    public String delete(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteRecurringDepositAccount(accountId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{accountId}/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String accountClosureTemplate(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("recurringdepositaccount");
        DepositAccountData account = null;
        if (this.is(commandParam, "close")) {
            account = this.depositAccountReadPlatformService.retrieveOneWithClosureTemplate(DepositAccountType.RECURRING_DEPOSIT, accountId);
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)account, DepositsApiConstants.RECURRING_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getRecurringDepositTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS.toString(), officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload recurring deposit template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postRecurringDepositTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @GET
    @Path(value="transactions/downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getRecurringDepositTransactionTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS_TRANSACTIONS.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="transactions/uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload recurring deposit transactions template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postRecurringDepositTransactionsTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.RECURRING_DEPOSIT_ACCOUNTS_TRANSACTIONS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @Generated
    public RecurringDepositAccountsApiResource(DepositAccountReadPlatformService depositAccountReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<DepositAccountData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService, FromJsonHelper fromJsonHelper, DepositAccountPreMatureCalculationPlatformService accountPreMatureCalculationPlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, SqlValidator sqlValidator) {
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.savingsAccountChargeReadPlatformService = savingsAccountChargeReadPlatformService;
        this.fromJsonHelper = fromJsonHelper;
        this.accountPreMatureCalculationPlatformService = accountPreMatureCalculationPlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.sqlValidator = sqlValidator;
    }
}

