/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.account.data;

import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.account.data.SelfAccountTemplateData;
import org.apache.fineract.portfolio.self.account.service.SelfAccountTransferReadService;
import org.apache.fineract.portfolio.self.account.service.SelfBeneficiariesTPTReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SelfAccountTransferDataValidator {
    private final PlatformSecurityContext context;
    private final SelfAccountTransferReadService selfAccountTransferReadService;
    private final SelfBeneficiariesTPTReadPlatformService tptBeneficiaryReadPlatformService;
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public SelfAccountTransferDataValidator(PlatformSecurityContext context, SelfAccountTransferReadService selfAccountTransferReadService, SelfBeneficiariesTPTReadPlatformService tptBeneficiaryReadPlatformService, FromJsonHelper fromApiJsonHelper) {
        this.context = context;
        this.selfAccountTransferReadService = selfAccountTransferReadService;
        this.tptBeneficiaryReadPlatformService = tptBeneficiaryReadPlatformService;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public Map<String, Object> validateCreate(String type, String apiRequestBodyAsJson) {
        if (StringUtils.isBlank((CharSequence)apiRequestBodyAsJson)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.fromApiJsonHelper.parse(apiRequestBodyAsJson);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("accounttransfer");
        Long fromOfficeId = this.fromApiJsonHelper.extractLongNamed("fromOfficeId", element);
        baseDataValidator.reset().parameter("fromOfficeId").value((Object)fromOfficeId).notNull().integerGreaterThanZero();
        Long fromClientId = this.fromApiJsonHelper.extractLongNamed("fromClientId", element);
        baseDataValidator.reset().parameter("fromClientId").value((Object)fromClientId).notNull().integerGreaterThanZero();
        Long fromAccountId = this.fromApiJsonHelper.extractLongNamed("fromAccountId", element);
        baseDataValidator.reset().parameter("fromAccountId").value((Object)fromAccountId).notNull().integerGreaterThanZero();
        Integer fromAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("fromAccountType", element);
        baseDataValidator.reset().parameter("fromAccountType").value((Object)fromAccountType).notNull().isOneOfTheseValues(new Object[]{1, 2});
        Long toOfficeId = this.fromApiJsonHelper.extractLongNamed("toOfficeId", element);
        baseDataValidator.reset().parameter("toOfficeId").value((Object)toOfficeId).notNull().integerGreaterThanZero();
        Long toClientId = this.fromApiJsonHelper.extractLongNamed("toClientId", element);
        baseDataValidator.reset().parameter("toClientId").value((Object)toClientId).notNull().integerGreaterThanZero();
        Long toAccountId = this.fromApiJsonHelper.extractLongNamed("toAccountId", element);
        baseDataValidator.reset().parameter("toAccountId").value((Object)toAccountId).notNull().integerGreaterThanZero();
        Integer toAccountType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("toAccountType", element);
        baseDataValidator.reset().parameter("toAccountType").value((Object)toAccountType).notNull().isOneOfTheseValues(new Object[]{1, 2});
        if (fromAccountType != null && fromAccountType == 1 && toAccountType != null && toAccountType == 1) {
            baseDataValidator.reset().failWithCode("loan.to.loan.transfer.not.allowed", new Object[]{"Cannot transfer from Loan account to another Loan account."});
        }
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transferDate", element);
        baseDataValidator.reset().parameter("transferDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transferAmount", element);
        baseDataValidator.reset().parameter("transferAmount").value((Object)transactionAmount).notNull().positiveAmount();
        String transactionDescription = this.fromApiJsonHelper.extractStringNamed("transferDescription", element);
        baseDataValidator.reset().parameter("transferDescription").value((Object)transactionDescription).notBlank().notExceedingLengthOf(Integer.valueOf(200));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        SelfAccountTemplateData fromAccount = new SelfAccountTemplateData(fromAccountId, fromAccountType, fromClientId, fromOfficeId);
        SelfAccountTemplateData toAccount = new SelfAccountTemplateData(toAccountId, toAccountType, toClientId, toOfficeId);
        this.validateUserAccounts(fromAccount, toAccount, baseDataValidator, type);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("fromAccount", fromAccount);
        ret.put("toAccount", toAccount);
        ret.put("transactionDate", transactionDate);
        ret.put("transactionAmount", transactionAmount);
        return ret;
    }

    private void validateUserAccounts(SelfAccountTemplateData fromAccount, SelfAccountTemplateData toAccount, DataValidatorBuilder baseDataValidator, String type) {
        Collection validFromAccounts;
        AppUser user = this.context.authenticatedUser();
        Collection validToAccounts = validFromAccounts = this.selfAccountTransferReadService.retrieveSelfAccountTemplateData(user);
        if (type.equals("tpt")) {
            validToAccounts = this.tptBeneficiaryReadPlatformService.retrieveTPTSelfAccountTemplateData(user);
        }
        boolean validFromAccount = false;
        for (SelfAccountTemplateData validAccount : validFromAccounts) {
            if (!validAccount.equals((Object)fromAccount)) continue;
            validFromAccount = true;
            break;
        }
        boolean validToAccount = false;
        for (SelfAccountTemplateData validAccount : validToAccounts) {
            if (!validAccount.equals((Object)toAccount)) continue;
            validToAccount = true;
            break;
        }
        if (!validFromAccount) {
            baseDataValidator.reset().failWithCode("invalid.from.account.details", new Object[]{"Source account details doesn't match with valid user account details."});
        }
        if (!validToAccount) {
            baseDataValidator.reset().failWithCode("invalid.to.account.details", new Object[]{"Destination account details doesn't match with valid user account details."});
        }
        if (fromAccount.equals((Object)toAccount)) {
            baseDataValidator.reset().failWithCode("same.from.to.account.details", new Object[]{"Source and Destination account details are same."});
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

