/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.spm.data.ScorecardData;
import org.apache.fineract.spm.domain.Scorecard;
import org.apache.fineract.spm.domain.Survey;
import org.apache.fineract.spm.service.ScorecardReadPlatformService;
import org.apache.fineract.spm.service.ScorecardService;
import org.apache.fineract.spm.service.SpmService;
import org.apache.fineract.spm.util.ScorecardMapper;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="/v1/surveys/scorecards")
@Component
@Tag(name="Score Card", description="")
public class ScorecardApiResource {
    private final PlatformSecurityContext securityContext;
    private final SpmService spmService;
    private final ScorecardService scorecardService;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final ScorecardReadPlatformService scorecardReadPlatformService;

    @GET
    @Path(value="{surveyId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="List all Scorecard entries", description="List all Scorecard entries for a survey.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Scorecard.class)))})})
    public List<ScorecardData> findBySurvey(@PathParam(value="surveyId") @Parameter(description="Enter surveyId") Long surveyId) {
        this.securityContext.authenticatedUser();
        this.spmService.findById(surveyId);
        return (List)this.scorecardReadPlatformService.retrieveScorecardBySurvey(surveyId);
    }

    @POST
    @Path(value="{surveyId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="Create a Scorecard entry", description="Add a new entry to a survey.\n\nMandatory Fields\nclientId, createdOn, questionId, responseId, staffId")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public void createScorecard(@PathParam(value="surveyId") @Parameter(description="Enter surveyId") Long surveyId, @Parameter(description="scorecardData") ScorecardData scorecardData) {
        AppUser appUser = this.securityContext.authenticatedUser();
        Survey survey = this.spmService.findById(surveyId);
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(scorecardData.getClientId());
        this.scorecardService.createScorecard(ScorecardMapper.map((ScorecardData)scorecardData, (Survey)survey, (AppUser)appUser, (Client)client));
    }

    @GET
    @Path(value="{surveyId}/clients/{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public List<ScorecardData> findBySurveyAndClient(@PathParam(value="surveyId") @Parameter(description="Enter surveyId") Long surveyId, @PathParam(value="clientId") @Parameter(description="Enter clientId") Long clientId) {
        this.securityContext.authenticatedUser();
        this.spmService.findById(surveyId);
        this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        return (List)this.scorecardReadPlatformService.retrieveScorecardBySurveyAndClient(surveyId, clientId);
    }

    @GET
    @Path(value="clients/{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public List<ScorecardData> findByClient(@PathParam(value="clientId") Long clientId) {
        this.securityContext.authenticatedUser();
        this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        return (List)this.scorecardReadPlatformService.retrieveScorecardByClient(clientId);
    }

    @Generated
    public ScorecardApiResource(PlatformSecurityContext securityContext, SpmService spmService, ScorecardService scorecardService, ClientRepositoryWrapper clientRepositoryWrapper, ScorecardReadPlatformService scorecardReadPlatformService) {
        this.securityContext = securityContext;
        this.spmService = spmService;
        this.scorecardService = scorecardService;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.scorecardReadPlatformService = scorecardReadPlatformService;
    }
}

