/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackReverseIndexWriterV1;
import org.eclipse.jgit.internal.storage.file.SimpleDataOutput;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.transport.PackedObjectInfo;

public abstract class PackReverseIndexWriter {
    protected final DigestOutputStream out;
    protected final DataOutput dataOutput;
    private static final int DEFAULT_VERSION = 1;

    protected PackReverseIndexWriter(OutputStream dst) {
        this.out = new DigestOutputStream(dst instanceof BufferedOutputStream ? dst : new BufferedOutputStream(dst), Constants.newMessageDigest());
        this.dataOutput = new SimpleDataOutput(this.out);
    }

    public static PackReverseIndexWriter createWriter(OutputStream dst) {
        return PackReverseIndexWriter.createWriter(dst, 1);
    }

    public static PackReverseIndexWriter createWriter(OutputStream dst, int version) {
        if (version == 1) {
            return new PackReverseIndexWriterV1(dst);
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unsupportedPackReverseIndexVersion, Integer.toString(version)));
    }

    public void write(List<? extends PackedObjectInfo> objectsByIndexPos, byte[] packChecksum) throws IOException {
        this.writeHeader();
        this.writeBody(objectsByIndexPos);
        this.writeFooter(packChecksum);
        this.out.flush();
    }

    protected abstract void writeHeader() throws IOException;

    protected abstract void writeBody(List<? extends PackedObjectInfo> var1) throws IOException;

    private void writeFooter(byte[] packChecksum) throws IOException {
        this.out.write(packChecksum);
        byte[] selfChecksum = this.out.getMessageDigest().digest();
        this.out.write(selfChecksum);
    }
}

