/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.analytics;

import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.grails.forge.analytics.SelectedFeature;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.ServletImpl;
import org.grails.forge.options.TestFramework;
import org.grails.forge.util.VersionInfo;

@Introspected
public class Generated {
    private final ApplicationType type;
    private final GormImpl gorm;
    private final ServletImpl servlet;
    private final TestFramework testFramework;
    private final JdkVersion jdkVersion;
    private Collection<? extends SelectedFeature> features = new ArrayList<SelectedFeature>();
    private final String grailsVersion;

    @Creator
    public Generated(@NonNull ApplicationType type, @NonNull GormImpl gorm, @NonNull ServletImpl servlet, @NonNull TestFramework testFramework, @NonNull JdkVersion jdkVersion) {
        this.type = Objects.requireNonNull(type, "Type cannot be null");
        this.gorm = Objects.requireNonNull(gorm, "GORM cannot be null");
        this.servlet = Objects.requireNonNull(servlet, "Embedded Servlet cannot be null");
        this.testFramework = Objects.requireNonNull(testFramework, "Test framework cannot be null");
        this.jdkVersion = Objects.requireNonNull(jdkVersion, "JDK version cannot be null");
        this.grailsVersion = VersionInfo.getGrailsVersion();
    }

    public Collection<? extends SelectedFeature> getSelectedFeatures() {
        return this.features;
    }

    public void setSelectedFeatures(Collection<? extends SelectedFeature> features) {
        if (features != null) {
            this.features = features;
        }
    }

    @NonNull
    public ApplicationType getType() {
        return this.type;
    }

    @NonNull
    public GormImpl getGorm() {
        return this.gorm;
    }

    @NonNull
    public ServletImpl getServlet() {
        return this.servlet;
    }

    @NonNull
    public TestFramework getTestFramework() {
        return this.testFramework;
    }

    @NonNull
    public JdkVersion getJdkVersion() {
        return this.jdkVersion;
    }

    @NonNull
    public String getGrailsVersion() {
        return this.grailsVersion;
    }
}

