/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.application.generator;

import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.ContextFactory;
import org.grails.forge.application.OperatingSystem;
import org.grails.forge.application.Project;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.application.generator.ProjectGenerator;
import org.grails.forge.feature.AvailableFeatures;
import org.grails.forge.feature.FeatureContext;
import org.grails.forge.feature.cli;
import org.grails.forge.io.ConsoleOutput;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.options.BuildTool;
import org.grails.forge.options.Language;
import org.grails.forge.options.Options;
import org.grails.forge.template.RenderResult;
import org.grails.forge.template.RockerTemplate;
import org.grails.forge.template.Template;
import org.grails.forge.template.TemplateRenderer;

@Singleton
public class DefaultProjectGenerator
implements ProjectGenerator {
    private final ContextFactory contextFactory;
    private final BeanContext beanContext;

    public DefaultProjectGenerator(ContextFactory contextFactory, BeanContext beanContext) {
        this.contextFactory = contextFactory;
        this.beanContext = beanContext;
    }

    @Override
    public void generate(ApplicationType applicationType, Project project, Options options, @Nullable OperatingSystem operatingSystem, List<String> selectedFeatures, OutputHandler outputHandler, ConsoleOutput consoleOutput) throws Exception {
        GeneratorContext generatorContext = this.createGeneratorContext(applicationType, project, options, operatingSystem, selectedFeatures, consoleOutput);
        this.generate(applicationType, project, outputHandler, generatorContext);
    }

    @Override
    public void generate(ApplicationType applicationType, Project project, OutputHandler outputHandler, GeneratorContext generatorContext) throws Exception {
        ArrayList<String> features = new ArrayList<String>(generatorContext.getFeatures().size());
        features.addAll(generatorContext.getFeatures());
        features.sort(Comparator.comparing(Function.identity()));
        generatorContext.addTemplate("grailsCli", new RockerTemplate("grails-forge-cli.yml", cli.template(Language.DEFAULT_OPTION, generatorContext.getTestFramework(), BuildTool.DEFAULT_OPTION, generatorContext.getGorm(), generatorContext.getServlet(), generatorContext.getProject(), features, applicationType)));
        generatorContext.applyFeatures();
        try (TemplateRenderer templateRenderer = TemplateRenderer.create(project, outputHandler);){
            for (Template template : generatorContext.getTemplates().values()) {
                RenderResult renderResult = templateRenderer.render(template);
                if (renderResult.getError() == null) continue;
                throw renderResult.getError();
            }
        }
    }

    @Override
    public GeneratorContext createGeneratorContext(ApplicationType applicationType, Project project, Options options, @Nullable OperatingSystem operatingSystem, List<String> selectedFeatures, ConsoleOutput consoleOutput) {
        AvailableFeatures availableFeatures = this.beanContext.getBean(AvailableFeatures.class, Qualifiers.byName(applicationType.getName()));
        FeatureContext featureContext = this.contextFactory.createFeatureContext(availableFeatures, selectedFeatures, applicationType, options, operatingSystem);
        return this.contextFactory.createGeneratorContext(project, featureContext, consoleOutput);
    }
}

