/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.template;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.grails.forge.template.Template;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlTemplate
implements Template {
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");
    private final String path;
    private final Map<String, Object> config;

    public YamlTemplate(String path, Map<String, Object> config) {
        this.path = path;
        this.config = this.transform(config);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        if (!this.config.isEmpty()) {
            Yaml yaml = new Yaml(options);
            yaml.dump(this.config, new OutputStreamWriter(outputStream));
        } else {
            outputStream.write("# Place application configuration here".getBytes());
        }
    }

    private Map<String, Object> transform(Map<String, Object> config) {
        LinkedHashMap<String, Object> transformed = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            Map<String, Object> finalMap = transformed;
            String key = entry.getKey();
            Object value = entry.getValue();
            int index2 = key.indexOf(46);
            if (index2 != -1) {
                String[] keys = DOT_PATTERN.split(key);
                if (!keys[0].equals("micronaut") && config.keySet().stream().filter(k -> k.startsWith(keys[0] + ".")).count() == 1L) {
                    finalMap.put(key, value);
                    continue;
                }
                for (int i2 = 0; i2 < keys.length - 1; ++i2) {
                    Object next;
                    String subKey = keys[i2];
                    if (!finalMap.containsKey(subKey)) {
                        finalMap.put(subKey, new LinkedHashMap());
                    }
                    if (!((next = finalMap.get(subKey)) instanceof Map)) continue;
                    finalMap = (Map)next;
                }
                finalMap.put(keys[keys.length - 1], value);
                continue;
            }
            finalMap.put(key, value);
        }
        return transformed;
    }
}

