/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.transform.Sealed;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.transform.sc.StaticCompilationVisitor;
import org.codehaus.groovy.transform.trait.Traits;

public class ClassCompletionVerifier
extends ClassCodeVisitorSupport {
    private static final String[] INVALID_NAME_CHARS = new String[]{".", ":", "/", ";", "[", "<", ">"};
    private final boolean strictNames = Boolean.getBoolean("groovy.compiler.strictNames");
    private boolean inConstructor;
    private boolean inStaticConstructor;
    private final SourceUnit source;
    private ClassNode currentClass;

    public ClassCompletionVerifier(SourceUnit source) {
        this.source = source;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    public ClassNode getClassNode() {
        return this.currentClass;
    }

    @Override
    public void visitClass(ClassNode node) {
        ClassNode previousClass = this.currentClass;
        this.currentClass = node;
        try {
            this.checkImplementsAndExtends(node);
            if (this.source != null && !this.source.getErrorCollector().hasErrors()) {
                this.checkClassForIncorrectModifiers(node);
                this.checkInterfaceMethodVisibility(node);
                this.checkAbstractMethodVisibility(node);
                this.checkClassForExtendingFinalOrSealed(node);
                this.checkMethodsForIncorrectName(node);
                this.checkMethodsForWeakerAccess(node);
                this.checkMethodsForOverridingFinal(node);
                this.checkMethodsForOverridingIssue(node);
                this.checkNoAbstractMethodsNonAbstractClass(node);
                this.checkClassExtendsOrImplementsSelfTypes(node);
                this.checkNoStaticMethodWithSameSignatureAsNonStatic(node);
                this.checkGenericsUsage((ASTNode)node, node.getUnresolvedInterfaces());
                this.checkGenericsUsage((ASTNode)node, node.getUnresolvedSuperClass());
            }
            super.visitClass(node);
        }
        finally {
            this.currentClass = previousClass;
        }
    }

    private void checkNoStaticMethodWithSameSignatureAsNonStatic(ClassNode node) {
        ClassNode parent = node.getSuperClass();
        Map<String, MethodNode> result = parent != null ? parent.getDeclaredMethodsMap() : new HashMap<String, MethodNode>();
        ClassNodeUtils.addDeclaredMethodsFromInterfaces(node, result);
        for (MethodNode methodNode : node.getMethods()) {
            MethodNode mn = result.get(methodNode.getTypeDescriptor());
            if (mn != null && mn.isStatic() ^ methodNode.isStatic() && !methodNode.isStaticConstructor()) {
                if (!mn.isAbstract()) continue;
                ClassNode declaringClass = mn.getDeclaringClass();
                ClassNode cn = declaringClass.getOuterClass();
                if (cn == null && declaringClass.isResolved()) {
                    Class<?> typeClass = declaringClass.getTypeClass();
                    if ((typeClass = typeClass.getEnclosingClass()) != null) {
                        cn = ClassHelper.make(typeClass);
                    }
                }
                if (!Traits.isTrait(cn)) {
                    AnnotatedNode errorNode = methodNode;
                    String name = mn.getName();
                    if (errorNode.getLineNumber() == -1) {
                        for (PropertyNode propertyNode : node.getProperties()) {
                            String shortName;
                            String propName;
                            if (!name.startsWith("set") && !name.startsWith("get") && !name.startsWith("is") || !(propName = Verifier.capitalize(propertyNode.getField().getName())).equals(shortName = name.substring(name.startsWith("is") ? 2 : 3))) continue;
                            errorNode = propertyNode;
                            break;
                        }
                    }
                    this.addError("The " + ClassCompletionVerifier.getDescription(methodNode) + " is already defined in " + ClassCompletionVerifier.getDescription(node) + ". You cannot have both a static and an instance method with the same signature", errorNode);
                }
            }
            result.put(methodNode.getTypeDescriptor(), methodNode);
        }
    }

    private void checkInterfaceMethodVisibility(ClassNode node) {
        if (!node.isInterface()) {
            return;
        }
        for (MethodNode method : node.getMethods()) {
            if (method.isPublic()) continue;
            if (method.isAbstract()) {
                this.addError("The method '" + method.getName() + "' must be public as it is declared abstract in " + ClassCompletionVerifier.getDescription(node) + ".", method);
                continue;
            }
            if (method.isPrivate() || method.isStaticConstructor()) continue;
            this.addError("The method '" + method.getName() + "' is " + (method.isProtected() ? "protected" : "package-private") + " but must be " + (method.isStatic() ? "public" : "default") + " or private in " + ClassCompletionVerifier.getDescription(node) + ".", method);
        }
    }

    private void checkAbstractMethodVisibility(ClassNode node) {
        if (!node.isAbstract() || node.isInterface()) {
            return;
        }
        for (MethodNode method : node.getAbstractMethods()) {
            if (!method.isPrivate()) continue;
            this.addError("The method '" + method.getName() + "' must not be private as it is declared abstract in " + ClassCompletionVerifier.getDescription(node) + ".", method);
        }
    }

    private void checkNoAbstractMethodsNonAbstractClass(ClassNode node) {
        if (node.isAbstract()) {
            return;
        }
        for (MethodNode method : node.getAbstractMethods()) {
            String what;
            MethodNode sameArgsMethod = node.getMethod(method.getName(), method.getParameters());
            AnnotatedNode where = node;
            if (sameArgsMethod == null || sameArgsMethod.getReturnType().equals(method.getReturnType())) {
                what = "Can't have an abstract method in a non-abstract class. The " + ClassCompletionVerifier.getDescription(node) + " must be declared abstract or the " + ClassCompletionVerifier.getDescription(method) + " must be implemented.";
            } else {
                what = "Abstract " + ClassCompletionVerifier.getDescription(method) + " is not implemented but a method of the same name but different return type is defined: " + (sameArgsMethod.isStatic() ? "static " : "") + ClassCompletionVerifier.getDescription(sameArgsMethod);
                where = method;
            }
            this.addError(what, where);
        }
    }

    private void checkClassExtendsOrImplementsSelfTypes(ClassNode node) {
        if (node.isInterface()) {
            return;
        }
        for (ClassNode anInterface : GeneralUtils.getInterfacesAndSuperInterfaces(node)) {
            if (!Traits.isTrait(anInterface)) continue;
            for (ClassNode selfType : Traits.collectSelfTypes(anInterface, new LinkedHashSet<ClassNode>(), true, false)) {
                ClassNode superClass;
                if (!(selfType.isInterface() ? !node.implementsInterface(selfType) : !node.isDerivedFrom(selfType) && ((superClass = (ClassNode)node.getNodeMetaData("super.class")) == null || !superClass.isDerivedFrom(selfType)))) continue;
                this.addError(ClassCompletionVerifier.getDescription(node) + " implements " + ClassCompletionVerifier.getDescription(anInterface) + " but does not " + (selfType.isInterface() ? "implement" : "extend") + " self type " + ClassCompletionVerifier.getDescription(selfType), anInterface);
            }
        }
    }

    private void checkClassForIncorrectModifiers(ClassNode node) {
        if (node.isAbstract() && Modifier.isFinal(node.getModifiers())) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " cannot be " + (node.isInterface() ? "final. It is by nature abstract" : "both abstract and final") + ".", node);
        }
        ArrayList<String> modifiers = new ArrayList<String>();
        if (!(node instanceof InnerClassNode)) {
            if (Modifier.isProtected(node.getModifiers())) {
                modifiers.add("protected");
            }
            if (Modifier.isPrivate(node.getModifiers())) {
                modifiers.add("private");
            }
            if (Modifier.isStatic(node.getModifiers())) {
                modifiers.add("static");
            }
        }
        if (Modifier.isTransient(node.getModifiers())) {
            modifiers.add("transient");
        }
        if (Modifier.isVolatile(node.getModifiers())) {
            modifiers.add("volatile");
        }
        if (Modifier.isNative(node.getModifiers())) {
            modifiers.add("native");
        }
        for (String modifier : modifiers) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " has invalid modifier " + modifier + ".", node);
        }
    }

    private static String getDescription(ClassNode node) {
        String kind = node.isInterface() ? (Traits.isTrait(node) ? "trait" : "interface") : (node.isEnum() ? "enum" : "class");
        return kind + " '" + node.getName() + "'";
    }

    private static String getDescription(MethodNode node) {
        return "method '" + MethodNodeUtils.methodDescriptor(node, true) + "'";
    }

    private static String getDescription(FieldNode node) {
        return "field '" + node.getName() + "'";
    }

    private static String getDescription(PropertyNode node) {
        return "property '" + node.getName() + "'";
    }

    private static String getDescription(Parameter node) {
        return "parameter '" + node.getName() + "'";
    }

    private void checkAbstractDeclaration(MethodNode methodNode) {
        if (!methodNode.isAbstract() || this.currentClass.isAbstract() || methodNode.isDefault()) {
            return;
        }
        this.addError("Can't have an abstract method in a non-abstract class. The " + ClassCompletionVerifier.getDescription(this.currentClass) + " must be declared abstract or the method '" + MethodNodeUtils.methodDescriptor(methodNode, true) + "' must not be abstract.", methodNode);
    }

    private void checkClassForExtendingFinalOrSealed(ClassNode cn) {
        boolean isFinal = Modifier.isFinal(cn.getModifiers());
        boolean isSealed = Boolean.TRUE.equals(cn.getNodeMetaData(Sealed.class));
        boolean isNonSealed = cn.getAnnotations().stream().anyMatch(an -> an.getClassNode().getName().equals("groovy.transform.NonSealed"));
        ClassNode sc = cn.getSuperClass();
        if (sc != null && Modifier.isFinal(sc.getModifiers())) {
            this.addError("You are not allowed to extend the final " + ClassCompletionVerifier.getDescription(sc) + ".", cn);
        }
        if (isFinal && isNonSealed) {
            this.addError("The " + ClassCompletionVerifier.getDescription(cn) + " cannot be both final and non-sealed.", cn);
        }
        if (isSealed) {
            if (isFinal) {
                this.addError("The " + ClassCompletionVerifier.getDescription(cn) + " cannot be both final and sealed.", cn);
            }
            if (isNonSealed) {
                this.addError("The " + ClassCompletionVerifier.getDescription(cn) + " cannot be both sealed and non-sealed.", cn);
            }
            if (cn.getPermittedSubclasses().isEmpty()) {
                this.addError("Sealed " + ClassCompletionVerifier.getDescription(cn) + " has no explicit or implicit permitted subclasses.", cn);
            }
        }
        boolean sealedSuper = sc != null && sc.isSealed();
        boolean nonSealedSuper = sc != null && ClassNodeUtils.isNonSealed(sc);
        boolean sealedInterface = Arrays.stream(cn.getInterfaces()).anyMatch(ClassNode::isSealed);
        boolean nonSealedInterface = Arrays.stream(cn.getInterfaces()).anyMatch(ClassNodeUtils::isNonSealed);
        if (!(!isNonSealed || sealedSuper || sealedInterface || nonSealedSuper || nonSealedInterface)) {
            this.addError("The " + ClassCompletionVerifier.getDescription(cn) + " cannot be non-sealed as it has no sealed parent.", cn);
        }
        if (sealedSuper) {
            this.checkSealedParent(cn, sc);
        }
        if (sealedInterface) {
            for (ClassNode si : cn.getInterfaces()) {
                if (!si.isSealed()) continue;
                this.checkSealedParent(cn, si);
            }
        }
    }

    private void checkSealedParent(ClassNode cn, ClassNode parent) {
        boolean found = false;
        for (ClassNode permitted : parent.getPermittedSubclasses()) {
            if (!permitted.equals(cn)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addError("The " + ClassCompletionVerifier.getDescription(cn) + " is not a permitted subclass of the sealed " + ClassCompletionVerifier.getDescription(parent) + ".", cn);
        }
    }

    private void checkImplementsAndExtends(ClassNode node) {
        ClassNode type;
        if (!node.isInterface() && (type = node.getUnresolvedSuperClass()) != null && type.isInterface()) {
            this.addError("You are not allowed to extend the " + ClassCompletionVerifier.getDescription(type) + ", use implements instead.", node);
        }
        for (ClassNode type2 : node.getInterfaces()) {
            if (!type2.isInterface()) {
                this.addError("You are not allowed to implement the " + ClassCompletionVerifier.getDescription(type2) + ", use extends instead.", node);
                continue;
            }
            if (!type2.isSealed()) continue;
            this.checkSealedParent(node, type2);
        }
    }

    private void checkMethodsForIncorrectName(ClassNode cn) {
        if (!this.strictNames) {
            return;
        }
        List<MethodNode> methods = cn.getAllDeclaredMethods();
        for (MethodNode mNode : methods) {
            if (mNode.isConstructor() || mNode.isStaticConstructor()) continue;
            String name = mNode.getName();
            for (String ch : INVALID_NAME_CHARS) {
                if (!name.contains(ch)) continue;
                this.addError("You are not allowed to have '" + ch + "' in a method name", mNode);
            }
        }
    }

    private void checkMethodsForWeakerAccess(ClassNode cn) {
        block0: for (MethodNode cnMethod : cn.getMethods()) {
            if (cnMethod.isPublic() || cnMethod.isStatic()) continue;
            for (MethodNode scMethod : cn.getSuperClass().getMethods(cnMethod.getName())) {
                if (scMethod.isStatic() || scMethod.isPrivate() || !cnMethod.isPrivate() && (!cnMethod.isProtected() || !scMethod.isPublic()) && (!cnMethod.isPackageScope() || !scMethod.isPublic() && !scMethod.isProtected()) || !ParameterUtils.parametersEqual(cnMethod.getParameters(), scMethod.getParameters())) continue;
                this.addWeakerAccessError(cn, cnMethod, scMethod);
                continue block0;
            }
        }
        Map<String, MethodNode> interfaceMethods = ClassNodeUtils.getDeclaredMethodsFromInterfaces(cn);
        if (!interfaceMethods.isEmpty()) {
            for (MethodNode cnMethod : cn.getMethods()) {
                if (cnMethod.isPrivate() || cnMethod.isStatic()) continue;
                interfaceMethods.remove(cnMethod.getTypeDescriptor());
            }
            for (MethodNode publicMethod : interfaceMethods.values()) {
                for (MethodNode scMethod : cn.getSuperClass().getMethods(publicMethod.getName())) {
                    if (!scMethod.isFinal() || scMethod.isPublic() || scMethod.isPrivate() || scMethod.isStatic() || !ParameterUtils.parametersEqual(scMethod.getParameters(), publicMethod.getParameters())) continue;
                    this.addWeakerAccessError2(cn, scMethod, publicMethod);
                }
            }
        }
    }

    private void addWeakerAccessError(ClassNode cn, MethodNode cnMethod, MethodNode scMethod) {
        StringBuilder msg = new StringBuilder();
        msg.append(cnMethod.getName());
        this.appendParamsDescription(cnMethod.getParameters(), msg);
        msg.append(" in ");
        msg.append(cn.getName());
        msg.append(" cannot override ");
        msg.append(scMethod.getName());
        msg.append(" in ");
        msg.append(scMethod.getDeclaringClass().getName());
        msg.append("; attempting to assign weaker access privileges; was ");
        msg.append(scMethod.isPublic() ? "public" : (scMethod.isProtected() ? "protected" : "package-private"));
        this.addError(msg.toString(), cnMethod);
    }

    private void addWeakerAccessError2(ClassNode cn, MethodNode scMethod, MethodNode ifMethod) {
        StringBuilder msg = new StringBuilder();
        msg.append("inherited final method ");
        msg.append(scMethod.getName());
        this.appendParamsDescription(scMethod.getParameters(), msg);
        msg.append(" from ");
        msg.append(scMethod.getDeclaringClass().getName());
        msg.append(" cannot shadow the public method in ");
        msg.append(ifMethod.getDeclaringClass().getName());
        this.addError(msg.toString(), cn);
    }

    private void checkMethodsForOverridingFinal(ClassNode cn) {
        int skips = 4106;
        block0: for (MethodNode method : cn.getMethods()) {
            if ((method.getModifiers() & 0x100A) != 0) continue;
            Parameter[] params = method.getParameters();
            for (MethodNode superMethod : cn.getSuperClass().getMethods(method.getName())) {
                if ((superMethod.getModifiers() & 0x101A) != 16 || !ParameterUtils.parametersEqual(params, superMethod.getParameters())) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("You are not allowed to override the final method ");
                if (method.getName().contains(" ")) {
                    sb.append('\"').append(method.getName()).append('\"');
                } else {
                    sb.append(method.getName());
                }
                this.appendParamsDescription(params, sb);
                sb.append(" from ");
                sb.append(ClassCompletionVerifier.getDescription(superMethod.getDeclaringClass()));
                sb.append(".");
                this.addError(sb.toString(), method.getLineNumber() > 0 ? method : cn);
                continue block0;
            }
        }
    }

    private void checkMethodsForOverridingIssue(ClassNode cn) {
        Set<ClassNode> superTypes = ClassCompletionVerifier.getAllSuperTypes(cn);
        superTypes.remove(ClassHelper.GROOVY_OBJECT_TYPE);
        superTypes.remove(ClassHelper.OBJECT_TYPE);
        if (superTypes.isEmpty()) {
            return;
        }
        block0: for (MethodNode mn : cn.getMethods()) {
            Parameter[] pa = mn.getParameters();
            if (pa.length == 0 || (mn.getModifiers() & 0x100A) != 0) continue;
            for (ClassNode sc : superTypes) {
                Map<String, ClassNode> cspec = GenericsUtils.createGenericsSpec(sc);
                for (MethodNode sm : sc.getDeclaredMethods(mn.getName())) {
                    if (sm.isStatic() || sm.isPrivate() || !ParameterUtils.parametersEqual(pa, sm.getParameters())) continue;
                    Map<String, ClassNode> mspec = GenericsUtils.addMethodGenerics(sm, cspec);
                    int n = pa.length;
                    for (int i = 0; i < n; ++i) {
                        ClassNode t0 = sm.getParameters()[i].getType();
                        ClassNode t1 = pa[i].getType();
                        if (t0.isGenericsPlaceHolder() || ClassHelper.isPrimitiveType(t0) || t1.isGenericsPlaceHolder() || ClassHelper.isPrimitiveType(t1) || GenericsUtils.buildWildcardType(t0 = GenericsUtils.correctToGenericsSpecRecurse(mspec, t0)).isCompatibleWith(t1)) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("name clash: ");
                        if (mn.getName().contains(" ")) {
                            sb.append('\"').append(mn.getName()).append('\"');
                        } else {
                            sb.append(mn.getName());
                        }
                        this.appendParamsDescription(pa, sb);
                        sb.append(" in ");
                        sb.append(ClassCompletionVerifier.getDescription(cn));
                        sb.append(" and ");
                        if (sm.getName().contains(" ")) {
                            sb.append('\"').append(sm.getName()).append('\"');
                        } else {
                            sb.append(sm.getName());
                        }
                        this.appendParamsDescription(sm.getParameters(), sb);
                        sb.append(" in ");
                        sb.append(ClassCompletionVerifier.getDescription(sc));
                        sb.append(" have the same erasure, yet neither overrides the other.");
                        this.addError(sb.toString(), mn.getLineNumber() > 0 ? mn : cn);
                        continue block0;
                    }
                    continue block0;
                }
            }
        }
    }

    private static Set<ClassNode> getAllSuperTypes(ClassNode cn) {
        Set<ClassNode> interfaces = GeneralUtils.getInterfacesAndSuperInterfaces(cn);
        LinkedHashSet<ClassNode> superTypes = new LinkedHashSet<ClassNode>();
        interfaces.remove(cn);
        while ((cn = cn.getSuperClass()) != null) {
            superTypes.add(cn);
        }
        superTypes.addAll(interfaces);
        return superTypes;
    }

    private void appendParamsDescription(Parameter[] parameters, StringBuilder msg) {
        msg.append('(');
        boolean needsComma = false;
        for (Parameter parameter : parameters) {
            if (needsComma) {
                msg.append(',');
            } else {
                needsComma = true;
            }
            msg.append(parameter.getType().toString(false));
        }
        msg.append(')');
    }

    @Override
    public void visitMethod(MethodNode node) {
        this.inConstructor = false;
        this.inStaticConstructor = node.isStaticConstructor();
        this.checkAbstractDeclaration(node);
        if (!this.inStaticConstructor) {
            this.checkRepetitiveMethod(node);
            this.checkOverloadingPrivateAndPublic(node);
        }
        this.checkMethodForIncorrectModifiers(node);
        this.checkGenericsUsage((ASTNode)node, node.getReturnType());
        this.checkGenericsUsage((ASTNode)node, node.getParameters());
        for (Parameter param : node.getParameters()) {
            if (!ClassHelper.isPrimitiveVoid(param.getType())) continue;
            this.addError("The " + ClassCompletionVerifier.getDescription(param) + " in " + ClassCompletionVerifier.getDescription(node) + " has invalid type void", param);
        }
        super.visitMethod(node);
    }

    private void checkMethodForIncorrectModifiers(MethodNode node) {
        if (node.isAbstract() && (node.isStatic() || node.isFinal() && !this.currentClass.isInterface())) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " can only be one of abstract, static, " + (this.currentClass.isInterface() ? "default" : "final") + ".", node);
        }
        ArrayList<String> modifiers = new ArrayList<String>();
        if (this.currentClass.isInterface()) {
            if (Modifier.isFinal(node.getModifiers())) {
                modifiers.add("final");
            }
            if (Modifier.isNative(node.getModifiers())) {
                modifiers.add("native");
            }
            if (Modifier.isStrict(node.getModifiers())) {
                modifiers.add("strictfp");
            }
            if (Modifier.isSynchronized(node.getModifiers())) {
                modifiers.add("synchronized");
            }
        }
        if (!AnnotatedNodeUtils.isGenerated(node) && Modifier.isTransient(node.getModifiers())) {
            modifiers.add("transient");
        }
        for (String modifier : modifiers) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " has invalid modifier " + modifier + ".", node);
        }
    }

    private void checkOverloadingPrivateAndPublic(MethodNode node) {
        if (StaticCompilationVisitor.isStaticallyCompiled(this.currentClass)) {
            return;
        }
        boolean mixed = false;
        if (node.isPublic()) {
            for (MethodNode mn : this.currentClass.getDeclaredMethods(node.getName())) {
                if (mn == node || mn.isPublic() || mn.isProtected()) continue;
                mixed = true;
                break;
            }
        } else if (node.isPrivate()) {
            for (MethodNode mn : this.currentClass.getDeclaredMethods(node.getName())) {
                if (mn == node || !mn.isPublic() && !mn.isProtected()) continue;
                mixed = true;
                break;
            }
        }
        if (mixed) {
            this.addError("Mixing private and public/protected methods of the same name causes multimethods to be disabled and is forbidden to avoid surprising behaviour. Renaming the private methods will solve the problem.", node);
        }
    }

    private void checkRepetitiveMethod(MethodNode node) {
        for (MethodNode method : this.currentClass.getMethods(node.getName())) {
            Parameter[] p2;
            Parameter[] p1;
            if (method == node || !method.getDeclaringClass().equals(node.getDeclaringClass()) || (p1 = node.getParameters()).length != (p2 = method.getParameters()).length) continue;
            this.addErrorIfParamsAndReturnTypeEqual(p2, p1, node, method);
        }
    }

    private void addErrorIfParamsAndReturnTypeEqual(Parameter[] p2, Parameter[] p1, MethodNode node, MethodNode element) {
        boolean isEqual = true;
        for (int i = 0; i < p2.length && (isEqual &= p1[i].getType().equals(p2[i].getType())); ++i) {
        }
        if (isEqual &= node.getReturnType().equals(element.getReturnType())) {
            this.addError("Repetitive method name/signature for " + ClassCompletionVerifier.getDescription(node) + " in " + ClassCompletionVerifier.getDescription(this.currentClass) + ".", node);
        }
    }

    @Override
    public void visitField(FieldNode node) {
        if (this.currentClass.getDeclaredField(node.getName()) != node) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " is declared multiple times.", node);
        }
        this.checkInterfaceFieldModifiers(node);
        this.checkInvalidFieldModifiers(node);
        this.checkGenericsUsage((ASTNode)node, node.getType());
        if (ClassHelper.isPrimitiveVoid(node.getType())) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " has invalid type void", node);
        }
        super.visitField(node);
    }

    @Override
    public void visitProperty(PropertyNode node) {
        if (this.currentClass.getProperty(node.getName()) != node) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " is declared multiple times.", node);
        }
        this.checkDuplicateProperties(node);
        this.checkGenericsUsage((ASTNode)node, node.getType());
        super.visitProperty(node);
    }

    private void checkDuplicateProperties(PropertyNode node) {
        ClassNode cn = node.getDeclaringClass();
        String name = node.getName();
        String getterName = node.getGetterNameOrDefault();
        if (Character.isUpperCase(name.charAt(0))) {
            for (PropertyNode otherNode : cn.getProperties()) {
                String otherName = otherNode.getName();
                if (node == otherNode || !getterName.equals(otherNode.getGetterNameOrDefault())) continue;
                String msg = "The field " + name + " and " + otherName + " on the class " + cn.getName() + " will result in duplicate JavaBean properties, which is not allowed";
                this.addError(msg, node);
            }
        }
    }

    private void checkInterfaceFieldModifiers(FieldNode node) {
        if (!(!this.currentClass.isInterface() || node.isPublic() && node.isStatic() && node.isFinal())) {
            this.addError("The " + ClassCompletionVerifier.getDescription(node) + " is not 'public static final' but is defined in " + ClassCompletionVerifier.getDescription(this.currentClass) + ".", node);
        }
    }

    private void checkInvalidFieldModifiers(FieldNode node) {
        if ((node.getModifiers() & 0x50) == 80) {
            this.addError("Illegal combination of modifiers, final and volatile, for field '" + node.getName() + "'", node);
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression) {
        if (expression.getOperation().getType() == 30 && expression.getRightExpression() instanceof MapEntryExpression) {
            this.addError("You tried to use a map entry for an index operation, this is not allowed. Maybe something should be set in parentheses or a comma is missing?", expression.getRightExpression());
        }
        super.visitBinaryExpression(expression);
        if (Types.isAssignment(expression.getOperation().getType())) {
            this.checkFinalFieldAccess(expression.getLeftExpression());
            this.checkSuperOrThisOnLHS(expression.getLeftExpression());
        }
    }

    private void checkSuperOrThisOnLHS(Expression expression) {
        if (!(expression instanceof VariableExpression)) {
            return;
        }
        VariableExpression ve = (VariableExpression)expression;
        if (ve.isThisExpression()) {
            this.addError("cannot have 'this' as LHS of an assignment", expression);
        } else if (ve.isSuperExpression()) {
            this.addError("cannot have 'super' as LHS of an assignment", expression);
        }
    }

    private void checkFinalFieldAccess(Expression expression) {
        if (!(expression instanceof VariableExpression) && !(expression instanceof PropertyExpression)) {
            return;
        }
        Variable v = null;
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            v = ve.getAccessedVariable();
        } else {
            VariableExpression varExp;
            PropertyExpression propExp = (PropertyExpression)expression;
            Expression objectExpression = propExp.getObjectExpression();
            if (objectExpression instanceof VariableExpression && (varExp = (VariableExpression)objectExpression).isThisExpression()) {
                v = this.currentClass.getDeclaredField(propExp.getPropertyAsString());
            }
        }
        if (v instanceof FieldNode) {
            boolean error;
            FieldNode fn = (FieldNode)v;
            boolean isFinal = fn.isFinal();
            boolean isStatic = fn.isStatic();
            boolean bl = error = isFinal && (isStatic && !this.inStaticConstructor || !isStatic && !this.inConstructor);
            if (error) {
                this.addError("cannot modify" + (isStatic ? " static" : "") + " final field '" + fn.getName() + "' outside of " + (isStatic ? "static initialization block." : "constructor."), expression);
            }
        }
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        this.inConstructor = true;
        this.inStaticConstructor = node.isStaticConstructor();
        this.checkGenericsUsage((ASTNode)node, node.getParameters());
        super.visitConstructor(node);
    }

    @Override
    public void visitCatchStatement(CatchStatement cs) {
        ArrayList<String> modifiers = new ArrayList<String>();
        int mods = cs.getVariable().getModifiers();
        if (Modifier.isAbstract(mods)) {
            modifiers.add("abstract");
        }
        if (Modifier.isPrivate(mods)) {
            modifiers.add("private");
        }
        if (Modifier.isProtected(mods)) {
            modifiers.add("protected");
        }
        if (Modifier.isPublic(mods)) {
            modifiers.add("public");
        }
        if (Modifier.isStatic(mods)) {
            modifiers.add("static");
        }
        if (Modifier.isStrict(mods)) {
            modifiers.add("strictfp");
        }
        for (String modifier : modifiers) {
            this.addError("The catch " + ClassCompletionVerifier.getDescription(cs.getVariable()) + " has invalid modifier " + modifier + ".", cs);
        }
        if (!cs.getExceptionType().isDerivedFrom(ClassHelper.THROWABLE_TYPE)) {
            this.addError("Catch statement parameter type is not a subclass of Throwable.", cs);
        }
        super.visitCatchStatement(cs);
    }

    @Override
    public void visitForLoop(ForStatement fs) {
        ArrayList<String> modifiers = new ArrayList<String>();
        int mods = fs.getVariable().getModifiers();
        if (Modifier.isAbstract(mods)) {
            modifiers.add("abstract");
        }
        if (Modifier.isPrivate(mods)) {
            modifiers.add("private");
        }
        if (Modifier.isProtected(mods)) {
            modifiers.add("protected");
        }
        if (Modifier.isPublic(mods)) {
            modifiers.add("public");
        }
        if (Modifier.isStatic(mods)) {
            modifiers.add("static");
        }
        if (Modifier.isStrict(mods)) {
            modifiers.add("strictfp");
        }
        for (String modifier : modifiers) {
            this.addError("The variable '" + fs.getVariable().getName() + "' has invalid modifier " + modifier + ".", fs);
        }
        super.visitForLoop(fs);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression mce) {
        super.visitMethodCallExpression(mce);
        Expression aexp = mce.getArguments();
        if (aexp instanceof TupleExpression) {
            TupleExpression arguments = (TupleExpression)aexp;
            for (Expression e : arguments.getExpressions()) {
                this.checkForInvalidDeclaration(e);
            }
        } else {
            this.checkForInvalidDeclaration(aexp);
        }
    }

    private void checkForInvalidDeclaration(Expression exp) {
        if (!(exp instanceof DeclarationExpression)) {
            return;
        }
        this.addError("Invalid use of declaration inside method call.", exp);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        super.visitDeclarationExpression(expression);
        if (expression.isMultipleAssignmentDeclaration()) {
            return;
        }
        VariableExpression vexp = expression.getVariableExpression();
        ArrayList<String> modifiers = new ArrayList<String>();
        int mods = vexp.getModifiers();
        if (Modifier.isAbstract(mods)) {
            modifiers.add("abstract");
        }
        if (Modifier.isNative(mods)) {
            modifiers.add("native");
        }
        if (Modifier.isPrivate(mods)) {
            modifiers.add("private");
        }
        if (Modifier.isProtected(mods)) {
            modifiers.add("protected");
        }
        if (Modifier.isPublic(mods)) {
            modifiers.add("public");
        }
        if (Modifier.isStatic(mods)) {
            modifiers.add("static");
        }
        if (Modifier.isStrict(mods)) {
            modifiers.add("strictfp");
        }
        if (Modifier.isSynchronized(mods)) {
            modifiers.add("synchronized");
        }
        if (Modifier.isTransient(mods)) {
            modifiers.add("transient");
        }
        if (Modifier.isVolatile(mods)) {
            modifiers.add("volatile");
        }
        for (String modifier : modifiers) {
            this.addError("The variable '" + vexp.getName() + "' has invalid modifier " + modifier + ".", expression);
        }
        if (ClassHelper.isPrimitiveVoid(vexp.getOriginType())) {
            this.addError("The variable '" + vexp.getName() + "' has invalid type void.", expression);
        }
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression) {
        super.visitConstantExpression(expression);
        this.checkStringExceedingMaximumLength(expression);
    }

    @Override
    public void visitGStringExpression(GStringExpression expression) {
        super.visitGStringExpression(expression);
        for (ConstantExpression ce : expression.getStrings()) {
            this.checkStringExceedingMaximumLength(ce);
        }
    }

    private void checkStringExceedingMaximumLength(ConstantExpression expression) {
        String s;
        Object value = expression.getValue();
        if (value instanceof String && (s = (String)value).length() > 65535) {
            this.addError("String too long. The given string is " + s.length() + " Unicode code units long, but only a maximum of 65535 is allowed.", expression);
        }
    }

    private void checkGenericsUsage(ASTNode ref, ClassNode[] nodes) {
        for (ClassNode node : nodes) {
            this.checkGenericsUsage(ref, node);
        }
    }

    private void checkGenericsUsage(ASTNode ref, Parameter[] params) {
        for (Parameter p : params) {
            this.checkGenericsUsage(ref, p.getType());
        }
    }

    private void checkGenericsUsage(ASTNode ref, ClassNode node) {
        if (node.isArray()) {
            this.checkGenericsUsage(ref, node.getComponentType());
        } else if (!node.isRedirectNode() && node.isUsingGenerics()) {
            this.addError("A transform used a generics-containing ClassNode " + node + " for " + ClassCompletionVerifier.getRefDescriptor(ref) + "directly. You are not supposed to do this. Please create a clean ClassNode using ClassNode#getPlainNodeReference() and #setGenericsTypes(GenericsType[]) on it or use GenericsUtils.makeClassSafe* and use the new ClassNode instead of the original one. Otherwise, the compiler will create incorrect descriptors potentially leading to NullPointerExceptions in the TypeResolver class. If this is not your own doing, please report this bug to the writer of the transform.", ref);
        }
    }

    private static String getRefDescriptor(ASTNode ref) {
        if (ref instanceof FieldNode) {
            FieldNode f = (FieldNode)ref;
            return "the field " + f.getName() + " ";
        }
        if (ref instanceof PropertyNode) {
            PropertyNode p = (PropertyNode)ref;
            return "the property " + p.getName() + " ";
        }
        if (ref instanceof ConstructorNode) {
            return "the constructor " + ref.getText() + " ";
        }
        if (ref instanceof MethodNode) {
            return "the method " + ref.getText() + " ";
        }
        if (ref instanceof ClassNode) {
            return "the super class " + ref + " ";
        }
        return "<unknown with class " + ref.getClass() + "> ";
    }
}

