/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.net.URI;
import java.util.Collection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.shaded.javax.websocket.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class NameNodeUtils {
    public static final Logger LOG = LoggerFactory.getLogger(NameNodeUtils.class);

    @Nullable
    @VisibleForTesting
    static String getClientNamenodeAddress(Configuration conf, @Nullable String nsId) {
        Collection namenodes;
        Collection nameservices = DFSUtilClient.getNameServiceIds((Configuration)conf);
        String nnAddr = conf.getTrimmed("fs.defaultFS");
        if (nnAddr == null) {
            return null;
        }
        LOG.info("{} is {}", (Object)"fs.defaultFS", (Object)nnAddr);
        URI nnUri = URI.create(nnAddr);
        String defaultNnHost = nnUri.getHost();
        if (defaultNnHost == null) {
            return null;
        }
        if (nsId != null && nameservices.contains(nsId) && (namenodes = conf.getTrimmedStringCollection("dfs.ha.namenodes." + nsId)).size() > 1) {
            return nsId;
        }
        String currentNnAddress = null;
        if (nsId != null) {
            String hostNameKey = "dfs.namenode.rpc-address." + nsId;
            currentNnAddress = conf.get(hostNameKey);
        }
        if (currentNnAddress == null) {
            currentNnAddress = nnUri.getAuthority();
        }
        int port = 0;
        if (currentNnAddress.contains(":")) {
            port = Integer.parseInt(currentNnAddress.split(":")[1]);
        }
        if (port > 0) {
            return currentNnAddress;
        }
        return null;
    }

    private NameNodeUtils() {
    }
}

