/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.lib.server;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.lib.server.Server;
import org.apache.hadoop.lib.server.Service;
import org.apache.hadoop.lib.server.ServiceException;
import org.apache.hadoop.lib.util.ConfigurationUtils;

@InterfaceAudience.Private
public abstract class BaseService
implements Service {
    private String prefix;
    private Server server;
    private Configuration serviceConfig;

    public BaseService(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public final void init(Server server) throws ServiceException {
        this.server = server;
        String servicePrefix = this.getPrefixedName("");
        this.serviceConfig = new Configuration(false);
        for (Map.Entry entry : ConfigurationUtils.resolve(server.getConfig())) {
            String key = (String)entry.getKey();
            if (!key.startsWith(servicePrefix)) continue;
            this.serviceConfig.set(key.substring(servicePrefix.length()), (String)entry.getValue());
        }
        this.init();
    }

    @Override
    public void postInit() throws ServiceException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class[] getServiceDependencies() {
        return new Class[0];
    }

    @Override
    public void serverStatusChange(Server.Status oldStatus, Server.Status newStatus) throws ServiceException {
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected Server getServer() {
        return this.server;
    }

    protected String getPrefixedName(String name) {
        return this.server.getPrefixedName(this.prefix + "." + name);
    }

    protected Configuration getServiceConfig() {
        return this.serviceConfig;
    }

    protected abstract void init() throws ServiceException;
}

