/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.util.Map;

public class PartitionKeyRangeIsSplittingException
extends DocumentClientException {
    private static final long serialVersionUID = 1L;

    public PartitionKeyRangeIsSplittingException() {
        this("The requested resource is no longer available at the server.");
    }

    public PartitionKeyRangeIsSplittingException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public PartitionKeyRangeIsSplittingException(String msg) {
        super(410, msg);
        this.setSubStatus();
    }

    public PartitionKeyRangeIsSplittingException(String msg, String resourceAddress) {
        super(msg, null, null, 410, resourceAddress);
        this.setSubStatus();
    }

    public PartitionKeyRangeIsSplittingException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public PartitionKeyRangeIsSplittingException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, null, null);
    }

    public PartitionKeyRangeIsSplittingException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "The requested resource is no longer available at the server.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 410, requestUri);
        this.setSubStatus();
    }

    private void setSubStatus() {
        this.getResponseHeaders().put("x-ms-substatus", Integer.toString(1007));
    }
}

