/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSpecialCharactersInOutputPath {
    private static final Logger LOG = LoggerFactory.getLogger(TestSpecialCharactersInOutputPath.class);
    private static final String OUTPUT_FILENAME = "result[0]";

    public static boolean launchJob(URI fileSys, JobConf conf, int numMaps, int numReduces) throws IOException {
        Path inDir = new Path("/testing/input");
        Path outDir = new Path("/testing/output");
        FileSystem fs = FileSystem.get((URI)fileSys, (Configuration)conf);
        fs.delete(outDir, true);
        if (!fs.mkdirs(inDir)) {
            LOG.warn("Can't create " + inDir);
            return false;
        }
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("foo foo2 foo3");
        file.close();
        FileSystem.setDefaultUri((Configuration)conf, (URI)fileSys);
        conf.setJobName("foo");
        conf.setInputFormat(TextInputFormat.class);
        conf.setOutputFormat(SpecialTextOutputFormat.class);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setMapperClass(IdentityMapper.class);
        conf.setReducerClass(IdentityReducer.class);
        FileInputFormat.setInputPaths((JobConf)conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)outDir);
        conf.setNumMapTasks(numMaps);
        conf.setNumReduceTasks(numReduces);
        RunningJob runningJob = JobClient.runJob((JobConf)conf);
        try {
            Assert.assertTrue((boolean)runningJob.isComplete());
            Assert.assertTrue((boolean)runningJob.isSuccessful());
            Assert.assertTrue((String)"Output folder not found!", (boolean)fs.exists(new Path("/testing/output/result[0]")));
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"A NPE should not have happened.");
        }
        LOG.info("job is complete: " + runningJob.isSuccessful());
        return runningJob.isSuccessful();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobWithDFS() throws IOException {
        String namenode = null;
        MiniDFSCluster dfs = null;
        MiniMRCluster mr = null;
        DistributedFileSystem fileSys = null;
        try {
            int taskTrackers = 4;
            int jobTrackerPort = 60050;
            Configuration conf = new Configuration();
            dfs = new MiniDFSCluster.Builder(conf).build();
            fileSys = dfs.getFileSystem();
            namenode = fileSys.getUri().toString();
            mr = new MiniMRCluster(4, namenode, 2);
            JobConf jobConf = new JobConf();
            boolean result = TestSpecialCharactersInOutputPath.launchJob(fileSys.getUri(), jobConf, 3, 1);
            Assert.assertTrue((boolean)result);
        }
        finally {
            if (dfs != null) {
                dfs.shutdown();
            }
            if (mr != null) {
                mr.shutdown();
            }
        }
    }

    static class SpecialTextOutputFormat<K, V>
    extends TextOutputFormat<K, V> {
        SpecialTextOutputFormat() {
        }

        public RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
            return super.getRecordWriter(ignored, job, TestSpecialCharactersInOutputPath.OUTPUT_FILENAME, progress);
        }
    }
}

