/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.geometric;

import com.xugu.cloudjdbc.Error;
import com.xugu.common.ReplaceEnum;
import com.xugu.geometric.DBpoint;
import com.xugu.util.DBobject;
import com.xugu.util.DBtokenizer;
import java.io.Serializable;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DBcircle
extends DBobject
implements Serializable,
Cloneable {
    public @Nullable DBpoint center;
    public double radius;

    public DBcircle(double x, double y, double r) {
        this(new DBpoint(x, y), r);
    }

    public DBcircle(DBpoint c, double r) {
        this();
        this.center = c;
        this.radius = r;
    }

    public DBcircle(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public DBcircle() {
        this.type = "circle";
    }

    @Override
    public void setValue(@Nullable String s) throws SQLException {
        if (s == null) {
            this.center = null;
            return;
        }
        DBtokenizer t = new DBtokenizer(DBtokenizer.removeAngle(s), ',');
        if (t.getSize() != 2) {
            throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
        }
        try {
            this.center = new DBpoint(t.getToken(0));
            this.radius = Double.parseDouble(t.getToken(1));
        }
        catch (NumberFormatException e) {
            throw Error.createSQLException("[E50044]Callable: Required type conversion not allowed", ReplaceEnum.excStr.getReplaceStr() + 50044, 50044);
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DBcircle) {
            DBcircle p = (DBcircle)obj;
            DBpoint center = this.center;
            DBpoint pCenter = p.center;
            if (center == null) {
                return pCenter == null;
            }
            if (pCenter == null) {
                return false;
            }
            return p.radius == this.radius && DBcircle.equals(pCenter, center);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.center == null) {
            return 0;
        }
        long bits = Double.doubleToLongBits(this.radius);
        int v = (int)(bits ^ bits >>> 32);
        v = v * 31 + this.center.hashCode();
        return v;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DBcircle newDBcircle = (DBcircle)super.clone();
        if (newDBcircle.center != null) {
            newDBcircle.center = (DBpoint)newDBcircle.center.clone();
        }
        return newDBcircle;
    }

    @Override
    public @Nullable String getValue() {
        return this.center == null ? null : "<" + this.center + "," + this.radius + ">";
    }
}

