/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.Cache;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.config.PersistenceUnitProperties;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.CacheImpl;
import org.eclipse.persistence.internal.jpa.EntityGraphImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class EntityManagerFactoryDelegate
implements EntityManagerFactory,
PersistenceUnitUtil,
JpaEntityManagerFactory {
    protected Cache myCache;
    protected volatile AbstractSession session;
    protected EntityManagerSetupImpl setupImpl;
    protected boolean isOpen = true;
    protected Map properties;
    protected static final Set<String> supportedNonServerSessionProperties = PersistenceUnitProperties.getSupportedNonServerSessionProperties();
    protected boolean beginEarlyTransaction;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected ReferenceMode referenceMode = ReferenceMode.HARD;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit = true;
    protected String flushClearCache = "DropInvalidate";
    protected boolean shouldValidateExistence;
    protected UnitOfWork.CommitOrderType commitOrder = UnitOfWork.CommitOrderType.ID;
    protected boolean commitWithoutPersistRules;
    protected JpaEntityManagerFactory owner = null;

    public EntityManagerFactoryDelegate(AbstractSession databaseSession, JpaEntityManagerFactory owner) {
        this.session = databaseSession;
        this.owner = owner;
        this.processProperties(databaseSession.getProperties());
    }

    public EntityManagerFactoryDelegate(EntityManagerSetupImpl setupImpl, Map properties, JpaEntityManagerFactory owner) {
        this.setupImpl = setupImpl;
        this.owner = owner;
        this.properties = properties;
    }

    public EntityManagerFactoryDelegate(String persistenceUnitName, Map<String, Object> properties, List<ClassDescriptor> descriptors, JpaEntityManagerFactory owner) {
        this.properties = properties;
        this.owner = owner;
        SEPersistenceUnitInfo info = new SEPersistenceUnitInfo();
        info.setClassLoader((ClassLoader)properties.get("eclipselink.classloader"));
        info.setPersistenceUnitName(persistenceUnitName);
        info.getProperties().putAll(properties);
        this.setupImpl = new EntityManagerSetupImpl();
        this.setupImpl.predeploy(info, null);
        this.setupImpl.getDatabaseSession().addDescriptors(descriptors);
    }

    @Override
    public DatabaseSessionImpl getDatabaseSession() {
        return (DatabaseSessionImpl)this.getAbstractSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractSession getAbstractSession() {
        if (this.session == null) {
            EntityManagerFactoryDelegate entityManagerFactoryDelegate = this;
            synchronized (entityManagerFactoryDelegate) {
                if (this.session == null) {
                    ClassLoader realLoader = this.setupImpl.getPersistenceUnitInfo().getClassLoader();
                    Map<String, V>[] splitProperties = EntityManagerFactoryProvider.splitSpecifiedProperties(this.properties, supportedNonServerSessionProperties);
                    Map serverSessionProperties = splitProperties[1];
                    AbstractSession tempSession = this.setupImpl.deploy(realLoader, serverSessionProperties);
                    Map tempProperties = EntityManagerFactoryProvider.keepSpecifiedProperties(tempSession.getProperties(), supportedNonServerSessionProperties);
                    this.properties = splitProperties[0];
                    Map propertiesToProcess = EntityManagerFactoryProvider.mergeMaps(this.properties, tempProperties);
                    this.processProperties(propertiesToProcess);
                    this.session = tempSession;
                }
            }
        }
        return this.session;
    }

    public EntityManagerSetupImpl getSetupImpl() {
        return this.setupImpl;
    }

    @Override
    public ServerSession getServerSession() {
        return (ServerSession)this.getAbstractSession();
    }

    @Override
    public SessionBroker getSessionBroker() {
        return (SessionBroker)this.getAbstractSession();
    }

    @Override
    public synchronized void close() {
        this.verifyOpen();
        this.isOpen = false;
        if (this.setupImpl != null) {
            this.setupImpl.undeploy();
        }
        this.owner = null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(null, null);
    }

    public EntityManager createEntityManager(Map properties) {
        return this.createEntityManagerImpl(properties, null);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.createEntityManagerImpl(map, SynchronizationType.SYNCHRONIZED);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.createEntityManagerImpl(null, synchronizationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerImpl createEntityManagerImpl(Map properties, SynchronizationType syncType) {
        DatabaseSessionImpl databaseSession;
        this.verifyOpen();
        AbstractSession session = this.getAbstractSession();
        if (session.isDatabaseSession() && !(databaseSession = (DatabaseSessionImpl)session).isLoggedIn()) {
            DatabaseSessionImpl databaseSessionImpl = databaseSession;
            synchronized (databaseSessionImpl) {
                if (!databaseSession.isLoggedIn()) {
                    databaseSession.login();
                }
            }
        }
        if (syncType != null && !session.hasExternalTransactionController()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"pu_configured_for_resource_local"));
        }
        return new EntityManagerImpl(this, properties, syncType);
    }

    @Override
    public EntityManagerFactoryDelegate unwrap() {
        return this;
    }

    protected void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager_factory"));
        }
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    public Object getProperty(String name) {
        Object value;
        if (name == null) {
            return null;
        }
        if (this.properties != null && (value = this.properties.get(name)) != null) {
            return value;
        }
        AbstractSession tempSession = this.session;
        if (tempSession != null) {
            return tempSession.getProperty(name);
        }
        return null;
    }

    protected void processProperties(Map properties) {
        String flushClearCache;
        String commitOrder;
        String shouldOrderUpdates;
        String shouldValidateExistence;
        String commitWithoutPersist;
        String persistOnCommit;
        String closeOnCommit;
        String flushMode;
        String referenceMode;
        String beginEarlyTransactionProperty = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.transaction.join-existing", (Map)properties, (AbstractSession)this.session, (boolean)true);
        if (beginEarlyTransactionProperty != null) {
            this.beginEarlyTransaction = "true".equalsIgnoreCase(beginEarlyTransactionProperty);
        }
        if ((referenceMode = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.persistence-context.reference-mode", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.referenceMode = ReferenceMode.valueOf((String)referenceMode);
        }
        if ((flushMode = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.persistence-context.flush-mode", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.flushMode = FlushModeType.valueOf((String)flushMode);
        }
        if ((closeOnCommit = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.persistence-context.close-on-commit", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.closeOnCommit = "true".equalsIgnoreCase(closeOnCommit);
        }
        if ((persistOnCommit = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.persistence-context.persist-on-commit", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.persistOnCommit = "true".equalsIgnoreCase(persistOnCommit);
        }
        if ((commitWithoutPersist = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.persistence-context.commit-without-persist-rules", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.commitWithoutPersistRules = "true".equalsIgnoreCase(commitWithoutPersist);
        }
        if ((shouldValidateExistence = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.validate-existence", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.shouldValidateExistence = "true".equalsIgnoreCase(shouldValidateExistence);
        }
        if ((shouldOrderUpdates = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.order-updates", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.commitOrder = "true".equalsIgnoreCase(shouldOrderUpdates) ? UnitOfWork.CommitOrderType.ID : UnitOfWork.CommitOrderType.NONE;
        }
        if ((commitOrder = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.persistence-context.commit-order", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.commitOrder = UnitOfWork.CommitOrderType.valueOf((String)commitOrder.toUpperCase(Locale.ROOT));
        }
        if ((flushClearCache = PropertiesHandler.getPropertyValueLogDebug((String)"eclipselink.flush-clear.cache", (Map)properties, (AbstractSession)this.session, (boolean)true)) != null) {
            this.flushClearCache = flushClearCache;
        }
    }

    public void refreshMetadata(Map properties) {
        throw new UnsupportedOperationException();
    }

    public boolean getBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void setBeginEarlyTransaction(boolean beginEarlyTransaction) {
        this.beginEarlyTransaction = beginEarlyTransaction;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public void setReferenceMode(ReferenceMode referenceMode) {
        this.referenceMode = referenceMode;
    }

    public boolean getCloseOnCommit() {
        return this.closeOnCommit;
    }

    public void setCloseOnCommit(boolean closeOnCommit) {
        this.closeOnCommit = closeOnCommit;
    }

    public boolean getPersistOnCommit() {
        return this.persistOnCommit;
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"getpersistenceunitutil_called_on_closed_emf"));
        }
        return this;
    }

    public void setPersistOnCommit(boolean persistOnCommit) {
        this.persistOnCommit = persistOnCommit;
    }

    public boolean getCommitWithoutPersistRules() {
        return this.commitWithoutPersistRules;
    }

    public void setCommitWithoutPersistRules(boolean commitWithoutPersistRules) {
        this.commitWithoutPersistRules = commitWithoutPersistRules;
    }

    public String getFlushClearCache() {
        return this.flushClearCache;
    }

    public void setFlushClearCache(String flushClearCache) {
        this.flushClearCache = flushClearCache;
    }

    public boolean shouldValidateExistence() {
        return this.shouldValidateExistence;
    }

    public void setShouldValidateExistence(boolean shouldValidateExistence) {
        this.shouldValidateExistence = shouldValidateExistence;
    }

    public Cache getCache() {
        this.verifyOpen();
        if (null == this.myCache) {
            this.myCache = new CacheImpl(this);
        }
        return this.myCache;
    }

    public Map<String, Object> getProperties() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager_factory"));
        }
        AbstractSession tempSession = this.session;
        if (tempSession != null) {
            return Collections.unmodifiableMap(EntityManagerFactoryProvider.mergeMaps(this.properties, tempSession.getProperties()));
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return new CriteriaBuilderImpl(this.getMetamodel());
    }

    public Metamodel getMetamodel() {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager_factory"));
        }
        this.getAbstractSession();
        return this.setupImpl.getMetamodel(this.session.getLoader());
    }

    public JpaEntityManagerFactory getOwner() {
        return this.owner;
    }

    public void setMetamodel(Metamodel aMetamodel) {
        if (!this.isOpen()) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"operation_on_closed_entity_manager_factory"));
        }
        this.setupImpl.setMetamodel(aMetamodel);
    }

    public boolean isLoaded(Object entity, String attributeName) {
        return Boolean.TRUE.equals(EntityManagerFactoryImpl.isLoaded(entity, attributeName, this.session));
    }

    public boolean isLoaded(Object entity) {
        return Boolean.TRUE.equals(EntityManagerFactoryImpl.isLoaded(entity, this.session));
    }

    public Object getIdentifier(Object entity) {
        try {
            return EntityManagerFactoryImpl.getIdentifier(entity, this.session);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public UnitOfWork.CommitOrderType getCommitOrder() {
        return this.commitOrder;
    }

    public void setCommitOrder(UnitOfWork.CommitOrderType commitOrder) {
        this.commitOrder = commitOrder;
    }

    public void addNamedQuery(String name, Query query) {
        DatabaseQuery unwrapped = (DatabaseQuery)((DatabaseQuery)query.unwrap(DatabaseQuery.class)).clone();
        QueryImpl originalQuery = (QueryImpl)query.unwrap(QueryImpl.class);
        if (originalQuery.lockMode != null) {
            ((ObjectLevelReadQuery)unwrapped).setLockModeType(originalQuery.lockMode.name(), this.session);
        }
        if (unwrapped.isReadQuery()) {
            ((ReadQuery)unwrapped).setInternalMax(originalQuery.getMaxResultsInternal());
            if (query.getFirstResult() != -1) {
                ((ReadQuery)unwrapped).setFirstResult(query.getFirstResult());
            }
        }
        this.getServerSession().addQuery(name, unwrapped, true);
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.equals(JpaEntityManagerFactory.class) || cls.equals(EntityManagerFactoryImpl.class)) {
            return (T)this;
        }
        if (cls.equals(EntityManagerFactoryDelegate.class)) {
            return (T)this;
        }
        if (cls.equals(Session.class) || cls.equals(AbstractSession.class)) {
            return (T)this.getAbstractSession();
        }
        if (cls.equals(DatabaseSession.class) || cls.equals(DatabaseSessionImpl.class)) {
            return (T)this.getDatabaseSession();
        }
        if (cls.equals(Server.class) || cls.equals(ServerSession.class)) {
            return (T)this.getServerSession();
        }
        if (cls.equals(SessionBroker.class)) {
            return (T)this.getSessionBroker();
        }
        throw new PersistenceException(ExceptionLocalization.buildMessage((String)"unable_to_unwrap_jpa", (Object[])new String[]{EntityManagerFactory.class.getName(), cls.getName()}));
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        AttributeGroup group = ((EntityGraphImpl)entityGraph).getAttributeGroup().clone();
        group.setName(graphName);
        this.getAbstractSession().getAttributeGroups().put(graphName, group);
        this.getAbstractSession().getDescriptor(((EntityGraphImpl)entityGraph).getClassType()).addAttributeGroup((CoreAttributeGroup)group);
    }
}

