/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.serialize;

import io.lettuce.core.codec.RedisCodec;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisMetricsDataCodec
implements RedisCodec<String, CollectRep.MetricsData> {
    private static final Logger log = LoggerFactory.getLogger(RedisMetricsDataCodec.class);
    private final BufferAllocator allocator = new RootAllocator();

    public String decodeKey(ByteBuffer byteBuffer) {
        return Unpooled.wrappedBuffer((ByteBuffer)byteBuffer).toString(StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CollectRep.MetricsData decodeValue(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        try {
            byte[] bytes;
            if (byteBuffer.hasArray()) {
                bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
            } else {
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
            }
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                VectorSchemaRoot root;
                ArrowStreamReader reader;
                block17: {
                    CollectRep.MetricsData metricsData;
                    reader = new ArrowStreamReader(Channels.newChannel(in), this.allocator);
                    try {
                        reader.loadNextBatch();
                        root = reader.getVectorSchemaRoot();
                        if (root != null && root.getRowCount() != 0) break block17;
                        log.warn("Empty data received");
                        metricsData = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    reader.close();
                    return metricsData;
                }
                CollectRep.MetricsData metricsData = new CollectRep.MetricsData(root);
                reader.close();
                return metricsData;
            }
        }
        catch (Exception e) {
            log.error("Failed to decode metrics data", (Throwable)e);
            return null;
        }
    }

    public ByteBuffer encodeKey(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer encodeValue(CollectRep.MetricsData metricsData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

