/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.redis;

import java.util.List;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;

class PropertiesRedisConnectionDetails
implements RedisConnectionDetails {
    private final RedisProperties properties;

    PropertiesRedisConnectionDetails(RedisProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getUsername() {
        if (this.properties.getUrl() != null) {
            RedisConnectionConfiguration.ConnectionInfo connectionInfo = RedisConnectionConfiguration.ConnectionInfo.of(this.properties.getUrl());
            return connectionInfo.getUsername();
        }
        return this.properties.getUsername();
    }

    @Override
    public String getPassword() {
        if (this.properties.getUrl() != null) {
            RedisConnectionConfiguration.ConnectionInfo connectionInfo = RedisConnectionConfiguration.ConnectionInfo.of(this.properties.getUrl());
            return connectionInfo.getPassword();
        }
        return this.properties.getPassword();
    }

    @Override
    public RedisConnectionDetails.Standalone getStandalone() {
        if (this.properties.getUrl() != null) {
            RedisConnectionConfiguration.ConnectionInfo connectionInfo = RedisConnectionConfiguration.ConnectionInfo.of(this.properties.getUrl());
            return RedisConnectionDetails.Standalone.of(connectionInfo.getUri().getHost(), connectionInfo.getUri().getPort(), this.properties.getDatabase());
        }
        return RedisConnectionDetails.Standalone.of(this.properties.getHost(), this.properties.getPort(), this.properties.getDatabase());
    }

    @Override
    public RedisConnectionDetails.Sentinel getSentinel() {
        final RedisProperties.Sentinel sentinel = this.properties.getSentinel();
        if (sentinel == null) {
            return null;
        }
        return new RedisConnectionDetails.Sentinel(){

            @Override
            public int getDatabase() {
                return PropertiesRedisConnectionDetails.this.properties.getDatabase();
            }

            @Override
            public String getMaster() {
                return sentinel.getMaster();
            }

            @Override
            public List<RedisConnectionDetails.Node> getNodes() {
                return sentinel.getNodes().stream().map(PropertiesRedisConnectionDetails.this::asNode).toList();
            }

            @Override
            public String getUsername() {
                return sentinel.getUsername();
            }

            @Override
            public String getPassword() {
                return sentinel.getPassword();
            }
        };
    }

    @Override
    public RedisConnectionDetails.Cluster getCluster() {
        RedisProperties.Cluster cluster = this.properties.getCluster();
        List<RedisConnectionDetails.Node> nodes = cluster != null ? cluster.getNodes().stream().map(this::asNode).toList() : null;
        return nodes != null ? () -> nodes : null;
    }

    private RedisConnectionDetails.Node asNode(String node) {
        int portSeparatorIndex = node.lastIndexOf(58);
        String host = node.substring(0, portSeparatorIndex);
        int port = Integer.parseInt(node.substring(portSeparatorIndex + 1));
        return new RedisConnectionDetails.Node(host, port);
    }
}

