/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.BitIoConstraints;
import com.github.jinahya.bit.io.BitOutput;
import java.io.IOException;

public abstract class AbstractBitOutput
implements BitOutput {
    private int octet;
    private int available = 8;
    private long count;

    protected abstract void write(int var1) throws IOException;

    protected void unsigned8(int size, int value) throws IOException {
        BitIoConstraints.requireValidSizeUnsigned8(size);
        int required = size - this.available;
        if (required > 0) {
            this.unsigned8(this.available, value >> required);
            this.unsigned8(required, value);
            return;
        }
        this.octet <<= size;
        this.octet |= value & (1 << size) - 1;
        this.available -= size;
        if (this.available == 0) {
            this.write(this.octet);
            ++this.count;
            this.octet = 0;
            this.available = 8;
        }
    }

    protected void unsigned16(int size, int value) throws IOException {
        BitIoConstraints.requireValidSizeUnsigned16(size);
        int quotient = size / 8;
        int remainder = size % 8;
        if (remainder > 0) {
            this.unsigned8(remainder, value >> quotient * 8);
        }
        for (int i = quotient - 1; i >= 0; --i) {
            this.unsigned8(8, value >> 8 * i);
        }
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeInt(true, 1, value ? 1 : 0);
    }

    @Override
    public void writeByte(boolean unsigned, int size, byte value) throws IOException {
        this.writeInt(unsigned, BitIoConstraints.requireValidSizeByte(unsigned, size), value);
    }

    @Override
    public void writeShort(boolean unsigned, int size, short value) throws IOException {
        this.writeInt(unsigned, BitIoConstraints.requireValidSizeShort(unsigned, size), value);
    }

    @Override
    public void writeInt(boolean unsigned, int size, int value) throws IOException {
        BitIoConstraints.requireValidSizeInt(unsigned, size);
        int quotient = size / 16;
        int remainder = size % 16;
        if (remainder > 0) {
            this.unsigned16(remainder, value >> quotient * 16);
        }
        for (int i = 16 * (quotient - 1); i >= 0; i -= 16) {
            this.unsigned16(16, value >> i);
        }
    }

    @Override
    public void writeLong(boolean unsigned, int size, long value) throws IOException {
        BitIoConstraints.requireValidSizeLong(unsigned, size);
        int quotient = size / 32;
        int remainder = size % 32;
        if (remainder > 0) {
            this.writeInt(false, remainder, (int)(value >> quotient * 32));
        }
        for (int i = 32 * (quotient - 1); i >= 0; i -= 32) {
            this.writeInt(false, 32, (int)(value >> i));
        }
    }

    @Override
    public void writeChar(int size, char value) throws IOException {
        this.writeInt(true, BitIoConstraints.requireValidSizeChar(size), value);
    }

    @Override
    public long align(int bytes) throws IOException {
        if (bytes <= 0) {
            throw new IllegalArgumentException("bytes(" + bytes + ") <= 0");
        }
        long bits = 0L;
        if (this.available < 8) {
            bits += (long)this.available;
            this.writeInt(true, this.available, 0);
        }
        while (this.count % (long)bytes > 0L) {
            this.writeInt(true, 8, 0);
            bits += 8L;
        }
        return bits;
    }
}

