/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.flusher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hugegraph.computer.core.combiner.PointerCombiner;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.sort.flusher.InnerSortFlusher;
import org.apache.hugegraph.computer.core.sort.sorting.SortingFactory;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.entry.Pointer;
import org.apache.hugegraph.util.E;

public class CombineSubKvInnerSortFlusher
implements InnerSortFlusher {
    private final RandomAccessOutput output;
    private final PointerCombiner combiner;
    private final int subKvFlushThreshold;

    public CombineSubKvInnerSortFlusher(RandomAccessOutput output, PointerCombiner combiner, int subKvFlushThreshold) {
        this.output = output;
        this.combiner = combiner;
        this.subKvFlushThreshold = subKvFlushThreshold;
    }

    @Override
    public RandomAccessOutput output() {
        return this.output;
    }

    @Override
    public PointerCombiner combiner() {
        return this.combiner;
    }

    @Override
    public void flush(Iterator<KvEntry> entries) throws IOException {
        E.checkArgument((boolean)entries.hasNext(), (String)"Parameter entries can't be empty", (Object[])new Object[0]);
        KvEntry last = entries.next();
        ArrayList<KvEntry> sameKeyEntries = new ArrayList<KvEntry>();
        sameKeyEntries.add(last);
        while (true) {
            KvEntry current = null;
            if (entries.hasNext() && last.compareTo(current = entries.next()) == 0) {
                sameKeyEntries.add(current);
                continue;
            }
            this.writeSubKvs(last, this.sortedSubKvFromEntries(sameKeyEntries));
            if (current == null) break;
            sameKeyEntries.clear();
            sameKeyEntries.add(current);
            last = current;
        }
    }

    private Iterator<KvEntry> sortedSubKvFromEntries(List<KvEntry> entries) {
        Function<KvEntry, Iterator> kvEntryToSubKvs = EntriesUtil::subKvIterFromEntry;
        List subKvs = entries.stream().map(kvEntryToSubKvs).collect(Collectors.toList());
        return SortingFactory.createSorting(subKvs);
    }

    private void writeSubKvs(KvEntry kvEntry, Iterator<KvEntry> subKvIter) throws IOException {
        E.checkArgument((boolean)subKvIter.hasNext(), (String)"Parameter subKvs can't be empty", (Object[])new Object[0]);
        kvEntry.key().write(this.output);
        long position = this.output.position();
        this.output.writeFixedInt(0);
        this.output.writeFixedInt(0);
        KvEntry lastSubKv = subKvIter.next();
        Pointer lastSubValue = lastSubKv.value();
        int writtenCount = 0;
        while (true) {
            KvEntry current = null;
            if (subKvIter.hasNext() && lastSubKv.compareTo(current = subKvIter.next()) == 0) {
                lastSubValue = this.combiner.combine(lastSubValue, current.value());
                continue;
            }
            lastSubKv.key().write(this.output);
            lastSubValue.write(this.output);
            if (++writtenCount == this.subKvFlushThreshold || current == null) {
                long currentPosition = this.output.position();
                this.output.seek(position);
                this.output.writeFixedInt((int)(currentPosition - position - 4L));
                this.output.writeFixedInt(writtenCount);
                this.output.seek(currentPosition);
                if (current == null) break;
                kvEntry.key().write(this.output);
                position = this.output.position();
                this.output.writeFixedInt(0);
                this.output.writeFixedInt(0);
                writtenCount = 0;
            }
            lastSubKv = current;
            lastSubValue = current.value();
        }
    }
}

