/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.controller.graph;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.common.Constant;
import org.apache.hugegraph.controller.BaseController;
import org.apache.hugegraph.entity.graph.EdgeEntity;
import org.apache.hugegraph.entity.graph.VertexEntity;
import org.apache.hugegraph.entity.query.GraphView;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.service.graph.GraphService;
import org.apache.hugegraph.service.schema.EdgeLabelService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.structure.constant.IdStrategy;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.util.Ex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriUtils;

@RestController
@RequestMapping(value={"/api/v1.2/graph-connections/{connId}/graph"})
public class GraphController
extends BaseController {
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private EdgeLabelService elService;
    @Autowired
    private GraphService graphService;

    @PostMapping(value={"vertex"})
    public GraphView addVertex(@PathVariable(value="connId") int connId, @RequestBody VertexEntity entity) {
        this.checkParamsValid(connId, entity, true);
        return this.graphService.addVertex(connId, entity);
    }

    @PutMapping(value={"vertex/{id}"})
    public Vertex updateVertex(@PathVariable(value="connId") int connId, @PathVariable(value="id") String vertexId, @RequestBody VertexEntity entity) {
        vertexId = UriUtils.decode((String)vertexId, (Charset)Constant.CHARSET);
        this.checkParamsValid(connId, entity, false);
        this.checkIdSameAsBody(vertexId, entity);
        return this.graphService.updateVertex(connId, entity);
    }

    @PostMapping(value={"edge"})
    public GraphView addEdge(@PathVariable(value="connId") int connId, @RequestBody EdgeEntity entity) {
        this.checkParamsValid(connId, entity, true);
        return this.graphService.addEdge(connId, entity);
    }

    @PutMapping(value={"edge/{id}"})
    public Edge updateEdge(@PathVariable(value="connId") int connId, @PathVariable(value="id") String edgeId, @RequestBody EdgeEntity entity) {
        edgeId = UriUtils.decode((String)edgeId, (Charset)Constant.CHARSET);
        this.checkParamsValid(connId, entity, false);
        this.checkIdSameAsBody(edgeId, entity);
        return this.graphService.updateEdge(connId, entity);
    }

    private void checkParamsValid(int connId, VertexEntity entity, boolean create) {
        Ex.check(!StringUtils.isEmpty((CharSequence)entity.getLabel()), "common.param.cannot-be-null-or-empty", "label");
        VertexLabelEntity vlEntity = this.vlService.get(entity.getLabel(), connId);
        IdStrategy idStrategy = vlEntity.getIdStrategy();
        if (create) {
            Ex.check(idStrategy.isCustomize(), () -> entity.getId() != null, "common.param.cannot-be-null", "id");
        } else {
            Ex.check(entity.getId() != null, "common.param.cannot-be-null", "id");
        }
        Set<String> nonNullableProps = vlEntity.getNonNullableProps();
        Map<String, Object> properties = entity.getProperties();
        Ex.check(properties.keySet().containsAll(nonNullableProps), "graph.vertex.all-nonnullable-prop.should-be-setted", new Object[0]);
    }

    private void checkParamsValid(int connId, EdgeEntity entity, boolean create) {
        Ex.check(!StringUtils.isEmpty((CharSequence)entity.getLabel()), "common.param.cannot-be-null-or-empty", "label");
        EdgeLabelEntity elEntity = this.elService.get(entity.getLabel(), connId);
        if (create) {
            Ex.check(entity.getId() == null, "common.param.must-be-null", "id");
        } else {
            Ex.check(entity.getId() != null, "common.param.cannot-be-null", "id");
        }
        Ex.check(entity.getSourceId() != null, "common.param.must-be-null", "source_id");
        Ex.check(entity.getTargetId() != null, "common.param.must-be-null", "target_id");
        Set<String> nonNullableProps = elEntity.getNonNullableProps();
        Map<String, Object> properties = entity.getProperties();
        Ex.check(properties.keySet().containsAll(nonNullableProps), "graph.edge.all-nonnullable-prop.should-be-setted", new Object[0]);
    }
}

