/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.LongStream;
import org.apache.hadoop.hbase.procedure2.store.BitSetNode;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ProcedureStoreTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ProcedureStoreTracker.class);
    private final TreeMap<Long, BitSetNode> map = new TreeMap();
    private boolean keepDeletes = false;
    boolean partial = false;
    private long minModifiedProcId = Long.MAX_VALUE;
    private long maxModifiedProcId = Long.MIN_VALUE;

    public void resetToProto(ProcedureProtos.ProcedureStoreTracker trackerProtoBuf) {
        this.reset();
        for (ProcedureProtos.ProcedureStoreTracker.TrackerNode protoNode : trackerProtoBuf.getNodeList()) {
            BitSetNode node = new BitSetNode(protoNode);
            this.map.put(node.getStart(), node);
        }
    }

    public void resetTo(ProcedureStoreTracker tracker) {
        this.resetTo(tracker, false);
    }

    public void resetTo(ProcedureStoreTracker tracker, boolean resetDelete) {
        this.reset();
        this.partial = resetDelete ? false : tracker.partial;
        this.minModifiedProcId = tracker.minModifiedProcId;
        this.maxModifiedProcId = tracker.maxModifiedProcId;
        this.keepDeletes = tracker.keepDeletes;
        for (Map.Entry<Long, BitSetNode> entry : tracker.map.entrySet()) {
            this.map.put(entry.getKey(), new BitSetNode(entry.getValue(), resetDelete));
        }
    }

    public void insert(long procId) {
        this.insert(null, procId);
    }

    public void insert(long[] procIds) {
        for (int i = 0; i < procIds.length; ++i) {
            this.insert(procIds[i]);
        }
    }

    public void insert(long procId, long[] subProcIds) {
        BitSetNode node = this.update(null, procId);
        for (int i = 0; i < subProcIds.length; ++i) {
            node = this.insert(node, subProcIds[i]);
        }
    }

    private BitSetNode insert(BitSetNode node, long procId) {
        if (node == null || !node.contains(procId)) {
            node = this.getOrCreateNode(procId);
        }
        node.insertOrUpdate(procId);
        this.trackProcIds(procId);
        return node;
    }

    public void update(long procId) {
        this.update(null, procId);
    }

    private BitSetNode update(BitSetNode node, long procId) {
        node = this.lookupClosestNode(node, procId);
        assert (node != null) : "expected node to update procId=" + procId;
        assert (node.contains(procId)) : "expected procId=" + procId + " in the node";
        if (node == null) {
            throw new NullPointerException("pid=" + procId);
        }
        node.insertOrUpdate(procId);
        this.trackProcIds(procId);
        return node;
    }

    public void delete(long procId) {
        this.delete(null, procId);
    }

    public void delete(long[] procIds) {
        Arrays.sort(procIds);
        BitSetNode node = null;
        for (int i = 0; i < procIds.length; ++i) {
            node = this.delete(node, procIds[i]);
        }
    }

    private BitSetNode delete(BitSetNode node, long procId) {
        if ((node = this.lookupClosestNode(node, procId)) == null || !node.contains(procId)) {
            LOG.warn("The BitSetNode for procId={} does not exist, maybe a double deletion?", (Object)procId);
            return node;
        }
        node.delete(procId);
        if (!this.keepDeletes && node.isEmpty()) {
            this.map.remove(node.getStart());
        }
        this.trackProcIds(procId);
        return node;
    }

    public void setMinMaxModifiedProcIds(long min, long max) {
        this.minModifiedProcId = min;
        this.maxModifiedProcId = max;
    }

    public void setDeleted(long procId, boolean isDeleted) {
        BitSetNode node = this.getOrCreateNode(procId);
        assert (node.contains(procId)) : "expected procId=" + procId + " in the node=" + node;
        node.updateState(procId, isDeleted);
        this.trackProcIds(procId);
    }

    public void setDeletedIfModified(long ... procId) {
        BitSetNode node = null;
        for (int i = 0; i < procId.length; ++i) {
            if ((node = this.lookupClosestNode(node, procId[i])) == null || !node.isModified(procId[i])) continue;
            node.delete(procId[i]);
        }
    }

    private void setDeleteIf(ProcedureStoreTracker tracker, BiFunction<BitSetNode, Long, Boolean> func) {
        BitSetNode trackerNode = null;
        for (BitSetNode node : this.map.values()) {
            long minProcId = node.getStart();
            long maxProcId = node.getEnd();
            for (long procId = minProcId; procId <= maxProcId; ++procId) {
                if (!node.isModified(procId) || !func.apply(trackerNode = tracker.lookupClosestNode(trackerNode, procId), procId).booleanValue()) continue;
                node.delete(procId);
            }
        }
    }

    public void setDeletedIfDeletedByThem(ProcedureStoreTracker tracker) {
        this.setDeleteIf(tracker, (node, procId) -> node == null || !node.contains((long)procId) || node.isDeleted((long)procId) == DeleteState.YES);
    }

    public void setDeletedIfModifiedInBoth(ProcedureStoreTracker tracker) {
        this.setDeleteIf(tracker, (node, procId) -> node != null && node.isModified((long)procId));
    }

    private BitSetNode lookupClosestNode(BitSetNode node, long procId) {
        if (node != null && node.contains(procId)) {
            return node;
        }
        Map.Entry<Long, BitSetNode> entry = this.map.floorEntry(procId);
        return entry != null ? entry.getValue() : null;
    }

    private void trackProcIds(long procId) {
        this.minModifiedProcId = Math.min(this.minModifiedProcId, procId);
        this.maxModifiedProcId = Math.max(this.maxModifiedProcId, procId);
    }

    public long getModifiedMinProcId() {
        return this.minModifiedProcId;
    }

    public long getModifiedMaxProcId() {
        return this.maxModifiedProcId;
    }

    public void reset() {
        this.keepDeletes = false;
        this.partial = false;
        this.map.clear();
        this.minModifiedProcId = Long.MAX_VALUE;
        this.maxModifiedProcId = Long.MIN_VALUE;
    }

    public boolean isModified(long procId) {
        Map.Entry<Long, BitSetNode> entry = this.map.floorEntry(procId);
        return entry != null && entry.getValue().contains(procId) && entry.getValue().isModified(procId);
    }

    public DeleteState isDeleted(long procId) {
        Map.Entry<Long, BitSetNode> entry = this.map.floorEntry(procId);
        if (entry != null && entry.getValue().contains(procId)) {
            BitSetNode node = entry.getValue();
            DeleteState state = node.isDeleted(procId);
            return this.partial && !node.isModified(procId) ? DeleteState.MAYBE : state;
        }
        return this.partial ? DeleteState.MAYBE : DeleteState.YES;
    }

    public long getActiveMinProcId() {
        Map.Entry<Long, BitSetNode> entry = this.map.firstEntry();
        return entry == null ? -1L : entry.getValue().getActiveMinProcId();
    }

    public void setKeepDeletes(boolean keepDeletes) {
        this.keepDeletes = keepDeletes;
        if (!keepDeletes) {
            Iterator<Map.Entry<Long, BitSetNode>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, BitSetNode> entry = it.next();
                if (!entry.getValue().isEmpty()) continue;
                it.remove();
            }
        }
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartialFlag(boolean isPartial) {
        if (this.partial && !isPartial) {
            for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
                entry.getValue().unsetPartialFlag();
            }
        }
        this.partial = isPartial;
    }

    public boolean isEmpty() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllModified() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            if (entry.getValue().isAllModified()) continue;
            return false;
        }
        return true;
    }

    public long[] getAllActiveProcIds() {
        return this.map.values().stream().map(BitSetNode::getActiveProcIds).filter(p -> ((long[])p).length > 0).flatMapToLong(LongStream::of).toArray();
    }

    public void resetModified() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            entry.getValue().resetModified();
        }
        this.minModifiedProcId = Long.MAX_VALUE;
        this.maxModifiedProcId = Long.MIN_VALUE;
    }

    private BitSetNode getOrCreateNode(long procId) {
        BitSetNode leftNode = null;
        boolean leftCanGrow = false;
        Map.Entry<Long, BitSetNode> leftEntry = this.map.floorEntry(procId);
        if (leftEntry != null) {
            leftNode = leftEntry.getValue();
            if (leftNode.contains(procId)) {
                return leftNode;
            }
            leftCanGrow = leftNode.canGrow(procId);
        }
        BitSetNode rightNode = null;
        boolean rightCanGrow = false;
        Map.Entry<Long, BitSetNode> rightEntry = this.map.ceilingEntry(procId);
        if (rightEntry != null) {
            rightNode = rightEntry.getValue();
            rightCanGrow = rightNode.canGrow(procId);
            if (leftNode != null) {
                if (leftNode.canMerge(rightNode)) {
                    return this.mergeNodes(leftNode, rightNode);
                }
                if (leftCanGrow && rightCanGrow) {
                    if (procId - leftNode.getEnd() <= rightNode.getStart() - procId) {
                        return this.growNode(leftNode, procId);
                    }
                    return this.growNode(rightNode, procId);
                }
            }
        }
        if (leftCanGrow) {
            return this.growNode(leftNode, procId);
        }
        if (rightCanGrow) {
            return this.growNode(rightNode, procId);
        }
        BitSetNode node = new BitSetNode(procId, this.partial);
        this.map.put(node.getStart(), node);
        return node;
    }

    private BitSetNode growNode(BitSetNode node, long procId) {
        this.map.remove(node.getStart());
        node.grow(procId);
        this.map.put(node.getStart(), node);
        return node;
    }

    private BitSetNode mergeNodes(BitSetNode leftNode, BitSetNode rightNode) {
        assert (leftNode.getStart() < rightNode.getStart());
        leftNode.merge(rightNode);
        this.map.remove(rightNode.getStart());
        return leftNode;
    }

    public void dump() {
        System.out.println("map " + this.map.size());
        System.out.println("isAllModified " + this.isAllModified());
        System.out.println("isEmpty " + this.isEmpty());
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            entry.getValue().dump();
        }
    }

    public ProcedureProtos.ProcedureStoreTracker toProto() throws IOException {
        ProcedureProtos.ProcedureStoreTracker.Builder builder = ProcedureProtos.ProcedureStoreTracker.newBuilder();
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            builder.addNode(entry.getValue().convert());
        }
        return builder.build();
    }

    public static enum DeleteState {
        YES,
        NO,
        MAYBE;

    }
}

