/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.manager;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.hugegraph.base.Directory;
import org.apache.hugegraph.base.HdfsDirectory;
import org.apache.hugegraph.base.LocalDirectory;
import org.apache.hugegraph.base.Printer;
import org.apache.hugegraph.base.RetryManager;
import org.apache.hugegraph.base.ToolClient;
import org.apache.hugegraph.cmd.SubCommands;
import org.apache.hugegraph.concurrent.KeyLock;
import org.apache.hugegraph.exception.ToolsException;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.util.E;

public class BackupRestoreBaseManager
extends RetryManager {
    public static final int BATCH = 500;
    protected static final int LBUF_SIZE = 1024;
    protected AtomicLong propertyKeyCounter = new AtomicLong(0L);
    protected AtomicLong vertexLabelCounter = new AtomicLong(0L);
    protected AtomicLong edgeLabelCounter = new AtomicLong(0L);
    protected AtomicLong indexLabelCounter = new AtomicLong(0L);
    protected AtomicLong vertexCounter = new AtomicLong(0L);
    protected AtomicLong edgeCounter = new AtomicLong(0L);
    private long startTime = 0L;
    protected static KeyLock locks = new KeyLock();
    private String logDir;
    protected Directory directory;
    private Map<String, OutputStream> outputStreams = new ConcurrentHashMap<String, OutputStream>();
    private Map<String, InputStream> inputStreams = new ConcurrentHashMap<String, InputStream>();

    public BackupRestoreBaseManager(ToolClient.ConnectionInfo info, String type) {
        super(info, type);
    }

    public void init(SubCommands.BackupRestore cmd) {
        this.threadsNum(cmd.threadsNum());
        assert (cmd.retry() > 0);
        this.retry(cmd.retry());
        LocalDirectory.ensureDirectoryExist(cmd.logDir());
        this.logDir(cmd.logDir());
        this.directory(cmd.directory(), cmd.hdfsConf());
        this.initExecutors();
    }

    public void logDir(String logDir) {
        this.logDir = logDir;
    }

    public String logDir() {
        return this.logDir;
    }

    public Directory directory() {
        return this.directory;
    }

    protected void ensureDirectoryExist(boolean create) {
        this.directory.ensureDirectoryExist(create);
    }

    protected void removeDirectory() {
        this.directory.removeDirectory();
    }

    protected long write(String path, HugeType type, List<?> list, boolean compress) {
        OutputStream os = this.outputStream(path, compress);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            String key = String.format("{\"%s\": ", type.string());
            baos.write(key.getBytes("UTF-8"));
            this.client.mapper().writeValue((OutputStream)baos, list);
            baos.write("}\n".getBytes("UTF-8"));
            os.write(baos.toByteArray());
        }
        catch (Throwable e) {
            throw new ToolsException("Failed to serialize %s to %s", e, type, path);
        }
        return list.size();
    }

    protected long write(String path, HugeType type, List<?> list, boolean compress, String format, String label, boolean allProperties, List<String> properties) {
        if (format == null || format.equals("json")) {
            return this.write(path, type, list, compress);
        }
        assert (format.equals("text"));
        return this.writeText(path, type, list, compress, label, allProperties, properties);
    }

    protected long writeText(String path, HugeType type, List<?> list, boolean compress, String label, boolean allProperties, List<String> properties) {
        OutputStream os = this.outputStream(path, compress);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        StringBuilder builder = new StringBuilder(1024);
        long count = 0L;
        try {
            for (Object e : list) {
                GraphElement element = (GraphElement)e;
                if (label != null && !label.equals(element.label())) continue;
                ++count;
                if (type == HugeType.VERTEX) {
                    builder.append(element.id()).append("\t");
                } else {
                    Edge edge = (Edge)e;
                    builder.append(edge.sourceId()).append("\t").append(edge.targetId()).append("\t");
                }
                if (allProperties) {
                    for (String value : element.properties().values()) {
                        builder.append((Object)value).append(",");
                    }
                } else {
                    for (String property : properties) {
                        builder.append(element.property(property)).append(",");
                    }
                }
                builder.setCharAt(builder.length() - 1, '\n');
            }
            baos.write(builder.toString().getBytes("UTF-8"));
            os.write(baos.toByteArray());
        }
        catch (Throwable e) {
            throw new ToolsException("Failed to serialize %s to %s", e, type, path);
        }
        return count;
    }

    protected void read(String file, HugeType type, BiConsumer<String, String> consumer) {
        InputStream is = this.inputStream(file);
        try (InputStreamReader isr = new InputStreamReader(is, "UTF-8");
             BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(type.string(), line);
            }
        }
        catch (IOException e) {
            throw new ToolsException("Failed to deserialize %s from %s", (Throwable)e, type, file);
        }
    }

    protected OutputStream outputStream(String file, boolean compress) {
        OutputStream os = this.outputStreams.get(file);
        if (os != null) {
            return os;
        }
        os = this.directory.outputStream(file, compress, true);
        OutputStream prev = this.outputStreams.putIfAbsent(file, os);
        if (prev != null) {
            Directory.closeAndIgnoreException(os);
            os = prev;
        }
        return os;
    }

    protected InputStream inputStream(String file) {
        InputStream is = this.inputStreams.get(file);
        if (is != null) {
            return is;
        }
        is = this.directory.inputStream(file);
        InputStream prev = this.inputStreams.putIfAbsent(file, is);
        if (prev != null) {
            Directory.closeAndIgnoreException(is);
            is = prev;
        }
        return is;
    }

    protected void directory(String dir, Map<String, String> hdfsConf) {
        this.directory = hdfsConf == null || hdfsConf.isEmpty() ? LocalDirectory.constructDir(dir, this.graph()) : HdfsDirectory.constructDir(dir, this.graph(), hdfsConf);
    }

    protected String fileWithPrefix(HugeType type) {
        List<String> files = this.filesWithPrefix(type);
        E.checkState((files.size() == 1 ? 1 : 0) != 0, (String)"There should be only one file of '%s', but got '%s'", (Object[])new Object[]{type, files.size()});
        return files.get(0);
    }

    protected List<String> filesWithPrefix(HugeType type) {
        ArrayList<String> files = new ArrayList<String>();
        for (String file : this.directory.files()) {
            if (!file.startsWith(type.string())) continue;
            files.add(file);
        }
        return files;
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
    }

    public long elapseSeconds() {
        E.checkState((this.startTime != 0L ? 1 : 0) != 0, (String)"Must call startTimer() to set start time, before call elapse()", (Object[])new Object[0]);
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    protected void printSummary() {
        this.printSummary(this.type());
    }

    protected void printSummary(String type) {
        Printer.print("===============================================");
        ImmutableMap summary = ImmutableMap.builder().put((Object)"property key number", (Object)this.propertyKeyCounter.longValue()).put((Object)"vertex label number", (Object)this.vertexLabelCounter.longValue()).put((Object)"edge label number", (Object)this.edgeLabelCounter.longValue()).put((Object)"index label number", (Object)this.indexLabelCounter.longValue()).put((Object)"vertex number", (Object)this.vertexCounter.longValue()).put((Object)"edge number", (Object)this.edgeCounter.longValue()).build();
        Printer.printMap(type + " summary", summary);
        Printer.printKV("cost time(s)", this.elapseSeconds());
    }

    @Override
    public void shutdown(String taskType) {
        super.shutdown(taskType);
        for (Map.Entry<String, OutputStream> entry : this.outputStreams.entrySet()) {
            try {
                OutputStream os = entry.getValue();
                os.close();
            }
            catch (IOException exception) {
                Printer.print("Failed to close file '%s'", entry.getKey());
            }
        }
        for (Map.Entry<String, Closeable> entry : this.inputStreams.entrySet()) {
            try {
                InputStream is = (InputStream)entry.getValue();
                is.close();
            }
            catch (IOException exception) {
                Printer.print("Failed to close file '%s'", entry.getKey());
            }
        }
    }
}

