/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.progress;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.progress.InputItemProgress;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.util.InsertionOrderUtil;

public final class InputProgress {
    @JsonProperty(value="type")
    private final SourceType type;
    @JsonProperty(value="loaded_items")
    private final Set<InputItemProgress> loadedItems;
    @JsonProperty(value="loading_item")
    private InputItemProgress loadingItem;
    private final transient Set<InputItemProgress> loadingItems;

    @JsonCreator
    public InputProgress(@JsonProperty(value="type") SourceType type, @JsonProperty(value="loaded_items") Set<InputItemProgress> loadedItems, @JsonProperty(value="loading_item") InputItemProgress loadingItem) {
        this.type = type;
        this.loadedItems = loadedItems;
        this.loadingItem = loadingItem;
        this.loadingItems = InsertionOrderUtil.newSet();
    }

    public InputProgress(InputStruct struct) {
        this.type = struct.input().type();
        this.loadedItems = InsertionOrderUtil.newSet();
        this.loadingItem = null;
        this.loadingItems = InsertionOrderUtil.newSet();
    }

    public Set<InputItemProgress> loadedItems() {
        return this.loadedItems;
    }

    public InputItemProgress loadingItem() {
        return this.loadingItem;
    }

    public InputItemProgress matchLoadedItem(InputItemProgress inputItem) {
        for (InputItemProgress item : this.loadedItems) {
            if (!item.equals(inputItem)) continue;
            return item;
        }
        return null;
    }

    public InputItemProgress matchLoadingItem(InputItemProgress inputItem) {
        if (this.loadingItem != null && this.loadingItem.equals(inputItem)) {
            return this.loadingItem;
        }
        return null;
    }

    public void addLoadedItem(InputItemProgress inputItemProgress) {
        this.loadedItems.add(inputItemProgress);
    }

    public void addLoadingItem(InputItemProgress inputItemProgress) {
        if (this.loadingItem != null) {
            this.loadingItems.add(this.loadingItem);
        }
        this.loadingItem = inputItemProgress;
    }

    public long loadingOffset() {
        return this.loadingItem == null ? 0L : this.loadingItem.offset();
    }

    public void markLoaded(boolean markAll) {
        if (!this.loadingItems.isEmpty()) {
            this.loadedItems.addAll(this.loadingItems);
            this.loadingItems.clear();
        }
        if (markAll && this.loadingItem != null) {
            this.loadedItems.add(this.loadingItem);
            this.loadingItem = null;
        }
    }

    public void confirmOffset() {
        for (InputItemProgress item : this.loadingItems) {
            item.confirmOffset();
        }
        if (this.loadingItem != null) {
            this.loadingItem.confirmOffset();
        }
    }
}

