/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.exception;

import java.util.Map;
import okhttp3.Response;
import org.apache.hugegraph.rest.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerException
extends RuntimeException {
    private static final Logger LOG = LoggerFactory.getLogger(ServerException.class);
    private static final long serialVersionUID = 6335623004322652358L;
    private static final String[] EXCEPTION_KEYS = new String[]{"exception", "Exception-Class"};
    private static final String[] MESSAGE_KEYS = new String[]{"message"};
    private static final String[] CAUSE_KEYS = new String[]{"cause", "exceptions"};
    private static final String[] TRACE_KEYS = new String[]{"trace", "stackTrace"};
    private int status = 0;
    private String exception;
    private String message;
    private String cause;
    private Object trace;

    public static ServerException fromResponse(Response response) {
        RestResult rs = new RestResult(response);
        ServerException exception = new ServerException(rs.content());
        exception.status(response.code());
        try {
            Map json = (Map)rs.readObject(Map.class);
            exception.exception = (String)ServerException.getByKeys(json, EXCEPTION_KEYS);
            exception.message = (String)ServerException.getByKeys(json, MESSAGE_KEYS);
            exception.cause = (String)ServerException.getByKeys(json, CAUSE_KEYS);
            exception.trace = ServerException.getByKeys(json, TRACE_KEYS);
        }
        catch (Exception ignored) {
            LOG.error("ServerException fromResponse exception");
        }
        return exception;
    }

    public ServerException(String message) {
        this.message = message;
    }

    public ServerException(String message, Object ... args) {
        this(String.format(message, args));
    }

    public String exception() {
        return this.exception;
    }

    public String message() {
        return this.message;
    }

    public String cause() {
        return this.cause;
    }

    public Object trace() {
        return this.trace;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Throwable getCause() {
        if (this.cause() == null || this.cause().isEmpty()) {
            return null;
        }
        return new ServerCause(this.cause());
    }

    public void status(int status) {
        this.status = status;
    }

    public int status() {
        return this.status;
    }

    @Override
    public String toString() {
        String s = this.exception;
        String message = this.getLocalizedMessage();
        return message != null ? s + ": " + message : s;
    }

    private static Object getByKeys(Map<String, Object> json, String[] keys) {
        for (String key : keys) {
            if (!json.containsKey(key)) continue;
            return json.get(key);
        }
        return null;
    }

    private static class ServerCause
    extends RuntimeException {
        private static final long serialVersionUID = 8755660573085501031L;

        public ServerCause(String cause) {
            super(cause, null, true, false);
        }

        @Override
        public String toString() {
            return super.getMessage();
        }
    }
}

