/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class OverflowUtils {
    private OverflowUtils() {
    }

    public static void accountForOverflowLong(TypeInfo outputTypeInfo, LongColumnVector v, boolean selectedInUse, int[] sel, int n) {
        if (outputTypeInfo == null) {
            return;
        }
        switch (outputTypeInfo.getTypeName()) {
            case "tinyint": {
                if (v.isRepeating) {
                    v.vector[0] = (byte)v.vector[0];
                    break;
                }
                if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        v.vector[i] = (byte)v.vector[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        v.vector[i] = (byte)v.vector[i];
                    }
                }
                break;
            }
            case "smallint": {
                if (v.isRepeating) {
                    v.vector[0] = (short)v.vector[0];
                    break;
                }
                if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        v.vector[i] = (short)v.vector[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        v.vector[i] = (short)v.vector[i];
                    }
                }
                break;
            }
            case "int": {
                if (v.isRepeating) {
                    v.vector[0] = (int)v.vector[0];
                    break;
                }
                if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        v.vector[i] = (int)v.vector[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        v.vector[i] = (int)v.vector[i];
                    }
                }
                break;
            }
        }
    }

    public static void accountForOverflowDouble(TypeInfo outputTypeInfo, DoubleColumnVector v, boolean selectedInUse, int[] sel, int n) {
        if (outputTypeInfo == null) {
            return;
        }
        switch (outputTypeInfo.getTypeName()) {
            case "float": {
                if (v.isRepeating) {
                    v.vector[0] = (float)v.vector[0];
                    break;
                }
                if (selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        v.vector[i] = (float)v.vector[i];
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        v.vector[i] = (float)v.vector[i];
                    }
                }
                break;
            }
        }
    }
}

