/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.hlc;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.ignite.shaded.org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.shaded.org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.ClockUpdateListener;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.shaded.org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.shaded.org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.shaded.org.jetbrains.annotations.TestOnly;

public class HybridClockImpl
implements HybridClock {
    private final IgniteLogger log = Loggers.forClass(HybridClockImpl.class);
    @Nullable
    private final FailureProcessor failureProcessor;
    private static final AtomicLongFieldUpdater<HybridClockImpl> LATEST_TIME = AtomicLongFieldUpdater.newUpdater(HybridClockImpl.class, "latestTime");
    private volatile long latestTime;
    private final List<ClockUpdateListener> updateListeners = new CopyOnWriteArrayList<ClockUpdateListener>();

    @TestOnly
    public HybridClockImpl() {
        this.failureProcessor = null;
    }

    public HybridClockImpl(FailureProcessor failureProcessor) {
        this.failureProcessor = failureProcessor;
    }

    @Override
    public final long nowLong() {
        long now;
        long oldLatestTime;
        do {
            if ((oldLatestTime = this.latestTime) < (now = this.currentTime())) continue;
            return LATEST_TIME.incrementAndGet(this);
        } while (!LATEST_TIME.compareAndSet(this, oldLatestTime, now));
        return now;
    }

    @Override
    public final long currentLong() {
        long current = this.currentTime();
        return Math.max(this.latestTime, current);
    }

    @Override
    public final HybridTimestamp now() {
        return HybridTimestamp.hybridTimestamp(this.nowLong());
    }

    @Override
    public final HybridTimestamp current() {
        return HybridTimestamp.hybridTimestamp(this.currentLong());
    }

    @Override
    public final HybridTimestamp update(HybridTimestamp requestTime) {
        long newLatestTime;
        long requestTimeLong = requestTime.longValue();
        while (true) {
            long oldLatestTime;
            if ((oldLatestTime = this.latestTime) >= requestTimeLong) {
                return HybridTimestamp.hybridTimestamp(LATEST_TIME.incrementAndGet(this));
            }
            long now = this.currentTime();
            if (now > requestTimeLong) {
                if (!LATEST_TIME.compareAndSet(this, oldLatestTime, now)) continue;
                return HybridTimestamp.hybridTimestamp(now);
            }
            newLatestTime = requestTimeLong + 1L;
            if (LATEST_TIME.compareAndSet(this, oldLatestTime, newLatestTime)) break;
        }
        this.notifyUpdateListeners(newLatestTime);
        return HybridTimestamp.hybridTimestamp(newLatestTime);
    }

    protected long physicalTime() {
        return System.currentTimeMillis();
    }

    private long currentTime() {
        return this.physicalTime() << 16;
    }

    private void notifyUpdateListeners(long newTs) {
        for (ClockUpdateListener listener : this.updateListeners) {
            try {
                listener.onUpdate(newTs);
            }
            catch (Throwable e) {
                if (this.failureProcessor != null) {
                    String errorMessage = IgniteStringFormatter.format("ClockUpdateListener#onUpdate() failed for {} at {}", listener, newTs);
                    this.failureProcessor.process(new FailureContext(e, errorMessage));
                } else {
                    this.log.error("ClockUpdateListener#onUpdate() failed for {} at {}", e, listener, newTs);
                }
                if (!(e instanceof Error)) continue;
                throw e;
            }
        }
    }

    @Override
    public void addUpdateListener(ClockUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    @Override
    public void removeUpdateListener(ClockUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public String toString() {
        return S.toString(HybridClock.class, this);
    }
}

