/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.BitSet;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.DeclaredType;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.marshal.DefaultFieldsReaderWriter;
import org.apache.ignite.internal.network.serialization.marshal.LittleEndianBits;
import org.apache.ignite.internal.network.serialization.marshal.NullsBitsetReader;
import org.apache.ignite.internal.network.serialization.marshal.StructuredObjectMarshaller;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueReader;
import org.apache.ignite.internal.network.serialization.marshal.UncheckedUnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.jetbrains.annotations.Nullable;

class UosObjectInputStream
extends ObjectInputStream {
    private final IgniteDataInput input;
    private final TypedValueReader valueReader;
    private final TypedValueReader unsharedReader;
    private final DefaultFieldsReaderWriter defaultFieldsReaderWriter;
    private final UnmarshallingContext context;
    private UosGetField currentGet;

    UosObjectInputStream(IgniteDataInput input, TypedValueReader valueReader, TypedValueReader unsharedReader, DefaultFieldsReaderWriter defaultFieldsReaderWriter, UnmarshallingContext context) throws IOException {
        this.input = input;
        this.valueReader = valueReader;
        this.unsharedReader = unsharedReader;
        this.defaultFieldsReaderWriter = defaultFieldsReaderWriter;
        this.context = context;
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.input.read(buf);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.input.read(buf, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return super.readAllBytes();
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.readByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.input.readShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.input.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.input.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.input.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    @Override
    public char readChar() throws IOException {
        return this.input.readChar();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    @Override
    public String readUTF() throws IOException {
        return this.input.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.input.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.input.readUnsignedShort();
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.input.readFully(buf);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.input.readFully(buf, off, len);
    }

    @Override
    public String readLine() throws IOException {
        return this.input.readLine();
    }

    @Override
    protected Object readObjectOverride() throws IOException {
        return this.doReadObjectOfAnyType();
    }

    private Object doReadObjectOfAnyType() throws IOException {
        return this.doReadObjectOf(null);
    }

    private Object doReadObjectOf(@Nullable DeclaredType declaredType) throws IOException {
        try {
            return this.valueReader.read(this.input, declaredType, this.context);
        }
        catch (UnmarshalException e) {
            throw new UncheckedUnmarshalException("Cannot read an object", e);
        }
    }

    @Override
    public Object readUnshared() throws IOException {
        return this.doReadUnsharedOfAnyType();
    }

    private Object doReadUnsharedOfAnyType() throws IOException {
        return this.doReadUnsharedOf(null);
    }

    private Object doReadUnsharedOf(@Nullable DeclaredType declaredType) throws IOException {
        try {
            return this.unsharedReader.read(this.input, declaredType, this.context);
        }
        catch (UnmarshalException e) {
            throw new UncheckedUnmarshalException("Cannot read an unshared object", e);
        }
    }

    @Override
    public void defaultReadObject() throws IOException {
        try {
            this.defaultFieldsReaderWriter.defaultFillFieldsFrom(this.input, this.context.objectCurrentlyReadWithReadObject(), this.context.descriptorOfObjectCurrentlyReadWithReadObject(), this.context);
        }
        catch (UnmarshalException e) {
            throw new UncheckedUnmarshalException("Cannot read fields in a default way", e);
        }
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException {
        if (this.currentGet == null) {
            this.currentGet = new UosGetField(this.context.descriptorOfObjectCurrentlyReadWithReadObject());
            this.currentGet.readFields();
        }
        return this.currentGet;
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public int skipBytes(int len) throws IOException {
        return this.input.skipBytes(len);
    }

    @Override
    public void close() throws IOException {
    }

    UosGetField replaceCurrentGetFieldWithNull() {
        UosGetField oldGet = this.currentGet;
        this.currentGet = null;
        return oldGet;
    }

    void restoreCurrentGetFieldTo(UosGetField newGet) {
        this.currentGet = newGet;
    }

    class UosGetField
    extends ObjectInputStream.GetField {
        private final DataInput input;
        private final ClassDescriptor remoteDescriptor;
        private final byte[] primitiveFieldsData;
        private final Object[] objectFieldVals;

        private UosGetField(ClassDescriptor currentObjectDescriptor) {
            this.input = UosObjectInputStream.this;
            this.remoteDescriptor = currentObjectDescriptor;
            this.primitiveFieldsData = new byte[currentObjectDescriptor.primitiveFieldsDataSize()];
            this.objectFieldVals = new Object[currentObjectDescriptor.objectFieldsCount()];
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return ObjectStreamClass.lookupAny(this.remoteDescriptor.localClass());
        }

        @Override
        public boolean defaulted(String name) {
            return this.remoteDescriptor.isPrimitiveFieldAddedLocally(name) || this.remoteDescriptor.isObjectFieldAddedLocally(name);
        }

        @Override
        public boolean get(String name, boolean defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getBoolean(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Boolean.TYPE));
        }

        @Override
        public byte get(String name, byte defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return this.primitiveFieldsData[this.primitiveFieldDataOffset(name, Byte.TYPE)];
        }

        @Override
        public char get(String name, char defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getChar(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Character.TYPE));
        }

        @Override
        public short get(String name, short defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getShort(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Short.TYPE));
        }

        @Override
        public int get(String name, int defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getInt(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Integer.TYPE));
        }

        @Override
        public long get(String name, long defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getLong(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Long.TYPE));
        }

        @Override
        public float get(String name, float defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getFloat(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Float.TYPE));
        }

        @Override
        public double get(String name, double defaultValue) throws IOException {
            if (this.remoteDescriptor.isPrimitiveFieldAddedLocally(name)) {
                return defaultValue;
            }
            return LittleEndianBits.getDouble(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Double.TYPE));
        }

        @Override
        public Object get(String name, Object defaultValue) throws IOException {
            if (this.remoteDescriptor.isObjectFieldAddedLocally(name)) {
                return defaultValue;
            }
            return this.objectFieldVals[this.remoteDescriptor.objectFieldIndex(name)];
        }

        private int primitiveFieldDataOffset(String fieldName, Class<?> requiredType) {
            return this.remoteDescriptor.primitiveFieldDataOffset(fieldName, requiredType.getName());
        }

        private void readFields() throws IOException {
            @Nullable BitSet nullsBitSet = NullsBitsetReader.readNullsBitSet(this.input, this.remoteDescriptor);
            int objectFieldIndex = 0;
            for (FieldDescriptor fieldDesc : this.remoteDescriptor.fields()) {
                objectFieldIndex = this.readNext(fieldDesc, objectFieldIndex, nullsBitSet);
            }
        }

        private int readNext(FieldDescriptor fieldDesc, int objectFieldIndex, @Nullable BitSet nullsBitSet) throws IOException {
            if (fieldDesc.isPrimitive()) {
                this.readPrimitive(fieldDesc);
                return objectFieldIndex;
            }
            return this.readObject(fieldDesc, objectFieldIndex, nullsBitSet);
        }

        private void readPrimitive(FieldDescriptor fieldDesc) throws IOException {
            int offset = this.remoteDescriptor.primitiveFieldDataOffset(fieldDesc.name(), fieldDesc.typeName());
            int length = fieldDesc.primitiveWidthInBytes();
            this.input.readFully(this.primitiveFieldsData, offset, length);
        }

        private int readObject(FieldDescriptor fieldDesc, int objectFieldIndex, @Nullable BitSet nullsBitSet) throws IOException {
            if (!StructuredObjectMarshaller.nullWasSkippedWhileWriting(fieldDesc, this.remoteDescriptor, nullsBitSet)) {
                Object readObject = fieldDesc.isUnshared() ? UosObjectInputStream.this.doReadUnsharedOf(fieldDesc) : UosObjectInputStream.this.doReadObjectOf(fieldDesc);
                this.objectFieldVals[objectFieldIndex] = readObject;
            }
            return objectFieldIndex + 1;
        }
    }
}

