/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteTypeSystem
extends RelDataTypeSystemImpl {
    public static final int MIN_SCALE_OF_AVG_RESULT = 16;
    public static final IgniteTypeSystem INSTANCE = new IgniteTypeSystem();

    public int getMaxScale(SqlTypeName typeName) {
        if (typeName == SqlTypeName.DECIMAL) {
            return Short.MAX_VALUE;
        }
        return super.getMaxScale(typeName);
    }

    @Deprecated
    public int getMaxNumericScale() {
        return Short.MAX_VALUE;
    }

    @Deprecated
    public int getMaxNumericPrecision() {
        return Short.MAX_VALUE;
    }

    public int getMinPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 0;
            }
        }
        return super.getMinPrecision(typeName);
    }

    public int getMaxPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return Integer.MAX_VALUE;
            }
            case DECIMAL: {
                return Short.MAX_VALUE;
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 9;
            }
        }
        return super.getMaxPrecision(typeName);
    }

    public int getDefaultPrecision(SqlTypeName typeName) {
        switch (typeName) {
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return 6;
            }
            case FLOAT: {
                return super.getDefaultPrecision(typeName) - 1;
            }
        }
        return super.getDefaultPrecision(typeName);
    }

    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        RelDataType sumType;
        block11: {
            block10: {
                if (!(argumentType instanceof BasicSqlType)) break block10;
                switch (argumentType.getSqlTypeName()) {
                    case INTEGER: 
                    case TINYINT: 
                    case SMALLINT: {
                        sumType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), argumentType.isNullable());
                        break block11;
                    }
                    case DECIMAL: 
                    case BIGINT: {
                        sumType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, typeFactory.getTypeSystem().getMaxPrecision(SqlTypeName.DECIMAL), argumentType.getScale()), argumentType.isNullable());
                        break block11;
                    }
                    case FLOAT: 
                    case REAL: 
                    case DOUBLE: {
                        sumType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DOUBLE), argumentType.isNullable());
                        break block11;
                    }
                    default: {
                        return super.deriveSumType(typeFactory, argumentType);
                    }
                }
            }
            switch (argumentType.getSqlTypeName()) {
                case INTEGER: 
                case TINYINT: 
                case SMALLINT: {
                    sumType = typeFactory.createJavaType(Long.class);
                    break;
                }
                case DECIMAL: 
                case BIGINT: {
                    sumType = typeFactory.createJavaType(BigDecimal.class);
                    break;
                }
                case FLOAT: 
                case REAL: 
                case DOUBLE: {
                    sumType = typeFactory.createJavaType(Double.class);
                    break;
                }
                default: {
                    return super.deriveSumType(typeFactory, argumentType);
                }
            }
        }
        return typeFactory.createTypeWithNullability(sumType, argumentType.isNullable());
    }

    public RelDataType deriveAvgAggType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        RelDataType avgType = null;
        if (SqlTypeUtil.isExactNumeric((RelDataType)argumentType)) {
            int originalPrecision = argumentType.getPrecision();
            int originalScale = argumentType.getScale();
            int scale = Math.max(16, originalScale);
            int precision = originalPrecision + (scale - originalScale);
            avgType = typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
        } else if (SqlTypeUtil.isApproximateNumeric((RelDataType)argumentType)) {
            avgType = typeFactory.createSqlType(SqlTypeName.DOUBLE);
        }
        if (avgType != null) {
            return typeFactory.createTypeWithNullability(avgType, argumentType.isNullable());
        }
        return super.deriveAvgAggType(typeFactory, argumentType);
    }

    public @Nullable RelDataType deriveDecimalDivideType(RelDataTypeFactory typeFactory, RelDataType type1, RelDataType type2) {
        if (SqlTypeUtil.isExactNumeric((RelDataType)type1) && SqlTypeUtil.isExactNumeric((RelDataType)type2) && (SqlTypeUtil.isDecimal((RelDataType)type1) || SqlTypeUtil.isDecimal((RelDataType)type2))) {
            type1 = RelDataTypeFactoryImpl.isJavaType((RelDataType)type1) ? typeFactory.decimalOf(type1) : type1;
            type2 = RelDataTypeFactoryImpl.isJavaType((RelDataType)type2) ? typeFactory.decimalOf(type2) : type2;
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            int maxNumericPrecision = this.getMaxPrecision(SqlTypeName.DECIMAL);
            int dout = Math.min(p1 - s1 + s2, maxNumericPrecision);
            int scale = Math.max(6, s1 + p2 + 1);
            scale = Math.min(scale, maxNumericPrecision - dout);
            scale = Math.min(scale, this.getMaxScale(SqlTypeName.DECIMAL));
            int precision = dout + scale;
            assert (precision <= maxNumericPrecision);
            assert (precision > 0);
            RelDataType ret = typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
            return ret;
        }
        return null;
    }
}

