/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.io.InputStream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.query.Query;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.system.streammgr.StreamManager;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.sparql.lang.SPARQLParser;
import org.apache.jena.sparql.lang.SPARQLParserRegistry;
import org.apache.jena.sparql.lang.arq.ParserARQ;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.Template;

public class QueryFactory {
    public static Query create(String queryString) {
        return QueryFactory.create(queryString, Syntax.defaultQuerySyntax);
    }

    public static Query create(String queryString, Syntax syntax) {
        return QueryFactory.create(queryString, null, syntax);
    }

    public static Query create(String queryString, String baseURI) {
        Query query = new Query();
        return QueryFactory.parse(query, queryString, baseURI, Syntax.defaultQuerySyntax);
    }

    public static Query create(String queryString, String baseURI, Syntax syntax) {
        Query query = new Query();
        return QueryFactory.parse(query, queryString, baseURI, syntax);
    }

    public static Query create() {
        return new Query();
    }

    public static Query make() {
        return QueryFactory.create();
    }

    public static Query create(Query originalQuery) {
        return originalQuery.cloneQuery();
    }

    public static Query parse(Query query, String queryString, String baseURI, Syntax syntaxURI) {
        if (syntaxURI == null) {
            syntaxURI = query.getSyntax();
        } else {
            query.setSyntax(syntaxURI);
        }
        SPARQLParser parser = SPARQLParser.createParser(syntaxURI);
        if (parser == null) {
            throw new UnsupportedOperationException("Unrecognized syntax for parsing: " + String.valueOf(syntaxURI));
        }
        if (query.getBase() == null) {
            IRIx queryBase = null;
            try {
                queryBase = baseURI != null ? IRIs.resolveIRI((String)baseURI) : IRIs.getSystemBase();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (queryBase == null) {
                queryBase = IRIx.create((String)"http://localhost/query/defaultBase#");
            }
            query.setBase(queryBase);
        }
        return parser.parse(query, queryString);
    }

    static boolean knownParserSyntax(Syntax syntaxURI) {
        return SPARQLParserRegistry.get().containsFactory(syntaxURI);
    }

    public static Query read(String url) {
        return QueryFactory.read(url, null, null, null);
    }

    public static Query read(String url, String baseURI) {
        return QueryFactory.read(url, null, baseURI, null);
    }

    public static Query read(String url, Syntax langURI) {
        return QueryFactory.read(url, null, null, langURI);
    }

    public static Query read(String url, String baseURI, Syntax langURI) {
        return QueryFactory.read(url, null, baseURI, langURI);
    }

    public static Query read(String url, StreamManager streamManager, String baseURI, Syntax langURI) {
        TypedInputStream in;
        if (streamManager == null) {
            streamManager = StreamManager.get();
        }
        if ((in = streamManager.open(url)) == null) {
            throw new NotFoundException("Not found: " + url);
        }
        String qStr = IO.readWholeFileAsUTF8((InputStream)streamManager.open(url));
        if (baseURI == null) {
            baseURI = url;
        }
        if (langURI == null) {
            langURI = Syntax.guessFileSyntax(url);
        }
        return QueryFactory.create(qStr, baseURI, langURI);
    }

    public static Element createElement(String elementString) {
        return ParserARQ.parseElement(elementString);
    }

    public static Template createTemplate(String templateString) {
        return ParserARQ.parseTemplate(templateString);
    }
}

