/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.List;
import java.util.Objects;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.DatasetUtils;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class DatasetFactory {
    public static Dataset create() {
        return DatasetFactory.wrap(DatasetGraphFactory.create());
    }

    public static Dataset createTxnMem() {
        return DatasetFactory.wrap(DatasetGraphFactory.createTxnMem());
    }

    public static Dataset createGeneral() {
        return DatasetFactory.wrap(DatasetGraphFactory.createGeneral());
    }

    public static Dataset create(Model model) {
        Objects.requireNonNull(model, "Default model must be provided");
        return new DatasetImpl(model);
    }

    public static Dataset wrap(DatasetGraph dataset) {
        Objects.requireNonNull(dataset, "Can't wrap a null DatasetGraph reference");
        return DatasetImpl.wrap(dataset);
    }

    public static Dataset wrap(Model model) {
        Objects.requireNonNull(model, "Can't wrap a null Model reference");
        return DatasetFactory.wrap(DatasetGraphOne.create(model.getGraph()));
    }

    public static Dataset empty() {
        return DatasetFactory.wrap(DatasetGraphFactory.empty());
    }

    public static Dataset create(List<String> uriList) {
        return DatasetFactory.create(uriList, null, null);
    }

    public static Dataset create(String uri) {
        return DatasetFactory.create(uri, null, null);
    }

    public static Dataset createNamed(List<String> namedSourceList) {
        return DatasetFactory.create((List<String>)null, namedSourceList, null);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList) {
        return DatasetFactory.create(uriList, namedSourceList, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList) {
        return DatasetFactory.create(uri, namedSourceList, null);
    }

    public static Dataset create(String uri, List<String> namedSourceList, String baseURI) {
        return DatasetUtils.createDataset(uri, namedSourceList, baseURI);
    }

    public static Dataset create(List<String> uriList, List<String> namedSourceList, String baseURI) {
        return DatasetUtils.createDataset(uriList, namedSourceList, baseURI);
    }

    public static Dataset assemble(String filename) {
        Objects.requireNonNull(filename, "file name can not be null");
        Model model = RDFDataMgr.loadModel(filename);
        return DatasetFactory.assemble(model);
    }

    public static Dataset assemble(String filename, String resourceURI) {
        Objects.requireNonNull(filename, "file name can not be null");
        Objects.requireNonNull(resourceURI, "resourceURI can not be null");
        Model model = RDFDataMgr.loadModel(filename);
        Resource r = model.createResource(resourceURI);
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Model model, String resourceURI) {
        Objects.requireNonNull(model, "model can not be null");
        Objects.requireNonNull(resourceURI, "resourceURI can not be null");
        Resource r = model.createResource(resourceURI);
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Model model, Resource resource) {
        Objects.requireNonNull(model, "model can not be null");
        Objects.requireNonNull(resource, "resource can not be null");
        Resource r = model.createResource(resource);
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Model model) {
        Objects.requireNonNull(model, "model can not be null");
        Resource r = GraphUtils.findRootByType(model, DatasetAssembler.getGeneralType());
        if (r == null) {
            throw new ARQException("No root found for type <" + String.valueOf(DatasetAssembler.getGeneralType()) + ">");
        }
        return DatasetFactory.assemble(r);
    }

    public static Dataset assemble(Resource resource) {
        Objects.requireNonNull(resource, "resource can not be null");
        Dataset ds = (Dataset)Assembler.general().open(resource);
        return ds;
    }
}

