/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.operation.log;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.util.TempFileCleanupUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;

public final class OperationLog$
implements Logging {
    public static OperationLog$ MODULE$;
    private final InheritableThreadLocal<OperationLog> OPERATION_LOG;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new OperationLog$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private final InheritableThreadLocal<OperationLog> OPERATION_LOG() {
        return this.OPERATION_LOG;
    }

    public void setCurrentOperationLog(OperationLog operationLog) {
        this.OPERATION_LOG().set(operationLog);
    }

    public Option<OperationLog> getCurrentOperationLog() {
        return Option$.MODULE$.apply(this.OPERATION_LOG().get());
    }

    public void removeCurrentOperationLog() {
        this.OPERATION_LOG().remove();
    }

    public Path createOperationLogRootDirectory(Session session) {
        return (Path)session.sessionManager().operationLogRoot().map((Function1 & Serializable & scala.Serializable)operationLogRoot -> {
            Path path;
            Path path2 = Paths.get(operationLogRoot, session.handle().identifier().toString());
            try {
                Files.createDirectories(path2, new FileAttribute[0]);
                TempFileCleanupUtils$.MODULE$.deleteOnExit(path2);
                path = path2;
            }
            catch (IOException e) {
                MODULE$.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Failed to create operation log root directory: ").append(path2).toString(), e);
                path = null;
            }
            return path;
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public OperationLog createOperationLog(Session session, OperationHandle opHandle) {
        return (OperationLog)session.sessionManager().operationLogRoot().map((Function1 & Serializable & scala.Serializable)operationLogRoot -> {
            OperationLog operationLog;
            try {
                Path logPath = Paths.get(operationLogRoot, session.handle().identifier().toString());
                Path logFile = Paths.get(((Object)logPath.toAbsolutePath()).toString(), opHandle.identifier().toString());
                MODULE$.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Creating operation log file ").append(logFile).toString());
                operationLog = new OperationLog(logFile);
            }
            catch (IOException e) {
                MODULE$.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to create operation log for ").append(opHandle).append(" in ").append(session.handle()).toString(), e);
                operationLog = null;
            }
            return operationLog;
        }).orNull(Predef$.MODULE$.$conforms());
    }

    private OperationLog$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.OPERATION_LOG = new InheritableThreadLocal<OperationLog>(){

            public OperationLog initialValue() {
                return null;
            }
        };
    }
}

