/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.SparkSQLEngine$;
import org.apache.kyuubi.engine.spark.operation.SparkSQLOperationManager;
import org.apache.kyuubi.engine.spark.session.SparkSessionImpl;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.spark.api.python.KyuubiPythonGatewayServer$;
import org.apache.spark.sql.SparkSession;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001\u0002\u0011\"\u00019B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tI\u0001\u0011\t\u0011)A\u0005\u0005\")\u0011\n\u0001C\u0005\u0015\")\u0011\n\u0001C\u0001\u001f\"9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB-\u0001A\u0003%1\u000b\u0003\u0005[\u0001!\u0015\r\u0011\"\u0003\\\u0011!\u0001\u0007\u0001#b\u0001\n\u0013\t\u0007\u0002C6\u0001\u0011\u000b\u0007I\u0011B.\t\u00111\u0004\u0001R1A\u0005\n5D\u0001\"\u001d\u0001\t\u0006\u0004%I!\u001c\u0005\be\u0002\u0011\r\u0011\"\u0003t\u0011\u0019a\b\u0001)A\u0005i\"AQ\u0010\u0001EC\u0002\u0013%a\u0010\u0003\u0006\u0002\f\u0001A)\u0019!C\u0005\u0003\u001bA\u0011\"!\t\u0001\u0001\u0004%I!a\t\t\u0013\u0005]\u0002\u00011A\u0005\n\u0005e\u0002\u0002CA#\u0001\u0001\u0006K!!\n\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J!9\u00111\n\u0001\u0005B\u0005%\u0003bBA'\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003\u001f\u0002A\u0011BA)\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!a\u001b\u0001\t#\ni\u0007C\u0004\u0002$\u0002!\t%!*\t\u000f\u0005E\u0006\u0001\"\u0003\u0002J!1\u00111\u0017\u0001\u0005RmC\u0001\"!.\u0001\t\u0003\u0019\u0013q\u0017\u0005\b\u0003\u0013\u0004A\u0011BAf\u0011!\ty\r\u0001C\u0001G\u0005E\u0007bBAr\u0001\u0011\u0005se\u0017\u0002\u0017'B\f'o[*R\u0019N+7o]5p]6\u000bg.Y4fe*\u0011!eI\u0001\bg\u0016\u001c8/[8o\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051QM\\4j]\u0016T!\u0001K\u0015\u0002\r-LX/\u001e2j\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\f\t\u0003aIj\u0011!\r\u0006\u0003E\u001dJ!aM\u0019\u0003\u001dM+7o]5p]6\u000bg.Y4fe\u0006!a.Y7f!\t1tH\u0004\u00028{A\u0011\u0001hO\u0007\u0002s)\u0011!(L\u0001\u0007yI|w\u000e\u001e \u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}m\u0002\"aQ$\u000e\u0003\u0011S!!\u0012$\u0002\u0007M\fHN\u0003\u0002%S%\u0011\u0001\n\u0012\u0002\r'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-ke\n\u0005\u0002M\u00015\t\u0011\u0005C\u00035\u0007\u0001\u0007Q\u0007C\u0003%\u0007\u0001\u0007!\t\u0006\u0002L!\")A\u0005\u0002a\u0001\u0005\u0006\u0001r\u000e]3sCRLwN\\'b]\u0006<WM]\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011akI\u0001\n_B,'/\u0019;j_:L!\u0001W+\u00031M\u0003\u0018M]6T#2{\u0005/\u001a:bi&|g.T1oC\u001e,'/A\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4fe\u0002\n!c]5oO2,7\u000b]1sWN+7o]5p]V\tA\f\u0005\u0002^=6\t1(\u0003\u0002`w\t9!i\\8mK\u0006t\u0017AC:iCJ,G*\u001a<fYV\t!\r\u0005\u0002dO:\u0011A-Z\u0007\u0002K%\u0011a-J\u0001\u000b'\"\f'/\u001a'fm\u0016d\u0017B\u00015j\u0005\u00151\u0016\r\\;f\u0013\tQ7HA\u0006F]VlWM]1uS>t\u0017\u0001G;tKJL5o\u001c7bi\u0016$7\u000b]1sWN+7o]5p]\u0006ARo]3s\u0013N|G.\u0019;fI&#G.Z%oi\u0016\u0014h/\u00197\u0016\u00039\u0004\"!X8\n\u0005A\\$\u0001\u0002'p]\u001e\fq#^:fe&\u001bx\u000e\\1uK\u0012LE\r\\3US6,w.\u001e;\u0002+U\u001cXM]%t_2\fG/\u001a3DC\u000eDW\rT8dWV\tA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006!A.\u00198h\u0015\u0005I\u0018\u0001\u00026bm\u0006L!a\u001f<\u0003\r=\u0013'.Z2u\u0003Y)8/\u001a:Jg>d\u0017\r^3e\u0007\u0006\u001c\u0007.\u001a'pG.\u0004\u0013!E;tKJL5o\u001c7bi\u0016$7)Y2iKV\tq\u0010\u0005\u0004\u0002\u0002\u0005\u001dQGQ\u0007\u0003\u0003\u0007Q1!!\u0002y\u0003\u0011)H/\u001b7\n\t\u0005%\u00111\u0001\u0002\b\u0011\u0006\u001c\b.T1q\u0003Y)8/\u001a:Jg>d\u0017\r^3e\u0007\u0006\u001c\u0007.Z\"pk:$XCAA\b!\u001d\t\t!a\u00026\u0003#\u0001r!XA\n\u0003/\ti\"C\u0002\u0002\u0016m\u0012a\u0001V;qY\u0016\u0014\u0004cA;\u0002\u001a%\u0019\u00111\u0004<\u0003\u000f%sG/Z4feB\u0019Q/a\b\n\u0005A4\u0018AH;tKJL5o\u001c7bi\u0016$7\u000b]1sWN+7o]5p]RC'/Z1e+\t\t)\u0003E\u0003^\u0003O\tY#C\u0002\u0002*m\u0012aa\u00149uS>t\u0007\u0003BA\u0017\u0003gi!!a\f\u000b\t\u0005E\u00121A\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u001b\u0003_\u0011\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003\t*8/\u001a:Jg>d\u0017\r^3e'B\f'o[*fgNLwN\u001c+ie\u0016\fGm\u0018\u0013fcR!\u00111HA!!\ri\u0016QH\u0005\u0004\u0003\u007fY$\u0001B+oSRD\u0011\"a\u0011\u0012\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013'A\u0010vg\u0016\u0014\u0018j]8mCR,Gm\u00159be.\u001cVm]:j_:$\u0006N]3bI\u0002\nQd\u001d;beR,6/\u001a:Jg>d\u0017\r^3e\u0007\u0006\u001c\u0007.Z\"iK\u000e\\WM\u001d\u000b\u0003\u0003w\tQa\u001d;beR\fAa\u001d;pa\u0006!r-\u001a;Pe:+wo\u00159be.\u001cVm]:j_:$RAQA*\u0003/Ba!!\u0016\u0017\u0001\u0004)\u0014\u0001B;tKJDq!!\u0017\u0017\u0001\u0004\tY&A\u0006tKN\u001c\u0018n\u001c8D_:4\u0007#\u0002\u001c\u0002^U*\u0014bAA0\u0003\n\u0019Q*\u00199\u0002\u001f9,wo\u00159be.\u001cVm]:j_:$RAQA3\u0003SBa!a\u001a\u0018\u0001\u0004\u0011\u0015\u0001\u0005:p_R\u001c\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\tIf\u0006a\u0001\u00037\nQb\u0019:fCR,7+Z:tS>tG\u0003DA8\u0003k\n)*a&\u0002\u001c\u0006}\u0005c\u0001\u0019\u0002r%\u0019\u00111O\u0019\u0003\u000fM+7o]5p]\"9\u0011q\u000f\rA\u0002\u0005e\u0014\u0001\u00039s_R|7m\u001c7\u0011\t\u0005m\u0014\u0011S\u0007\u0003\u0003{RA!a \u0002\u0002\u00061A\u000f\u001b:jMRTA!a!\u0002\u0006\u0006\u0019!\u000f]2\u000b\t\u0005\u001d\u0015\u0011R\u0001\bg\u0016\u0014h/[2f\u0015\u0011\tY)!$\u0002\t!Lg/\u001a\u0006\u0004\u0003\u001f;\u0013AB:iC\u0012,G-\u0003\u0003\u0002\u0014\u0006u$\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0011\u0019\t)\u0006\u0007a\u0001k!1\u0011\u0011\u0014\rA\u0002U\n\u0001\u0002]1tg^|'\u000f\u001a\u0005\u0007\u0003;C\u0002\u0019A\u001b\u0002\u0013%\u0004\u0018\t\u001a3sKN\u001c\bbBAQ1\u0001\u0007\u00111L\u0001\u0005G>tg-\u0001\u0007dY>\u001cXmU3tg&|g\u000e\u0006\u0003\u0002<\u0005\u001d\u0006bBAU3\u0001\u0007\u00111V\u0001\u000eg\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u0011\u0007A\ni+C\u0002\u00020F\u0012QbU3tg&|g\u000eS1oI2,\u0017AC:u_B,enZ5oK\u0006A\u0011n]*feZ,'/A\fhKR,enZ5oKJ+7/\u001e7u'\u00064X\rU1uQR\u0011\u0011\u0011\u0018\t\u0005\u0003w\u000b)-\u0004\u0002\u0002>*!\u0011qXAa\u0003\t17OC\u0002\u0002D&\na\u0001[1e_>\u0004\u0018\u0002BAd\u0003{\u0013A\u0001U1uQ\u0006Ar-\u001a;TKN\u001c\u0018n\u001c8SKN,H\u000e^*bm\u0016\u0004\u0016\r\u001e5\u0015\t\u0005e\u0016Q\u001a\u0005\b\u0003Sk\u0002\u0019AAV\u0003i9W\r^(qKJ\fG/[8o%\u0016\u001cX\u000f\u001c;TCZ,\u0007+\u0019;i)\u0019\tI,a5\u0002V\"9\u0011\u0011\u0016\u0010A\u0002\u0005-\u0006bBAl=\u0001\u0007\u0011\u0011\\\u0001\t_BD\u0015M\u001c3mKB!\u00111\\Ap\u001b\t\tiN\u0003\u0002WO%!\u0011\u0011]Ao\u0005=y\u0005/\u001a:bi&|g\u000eS1oI2,\u0017AF5t\u000b:<\u0017N\\3D_:$X\r\u001f;Ti>\u0004\b/\u001a3")
public class SparkSQLSessionManager
extends SessionManager {
    private boolean singleSparkSession;
    private Enumeration.Value shareLevel;
    private boolean userIsolatedSparkSession;
    private long userIsolatedIdleInterval;
    private long userIsolatedIdleTimeout;
    private HashMap<String, SparkSession> userIsolatedCache;
    private HashMap<String, Tuple2<Integer, Long>> userIsolatedCacheCount;
    private final SparkSession spark;
    private final SparkSQLOperationManager operationManager;
    private final Object userIsolatedCacheLock;
    private Option<ScheduledExecutorService> userIsolatedSparkSessionThread;
    private volatile byte bitmap$0;

    @Override
    public SparkSQLOperationManager operationManager() {
        return this.operationManager;
    }

    private boolean singleSparkSession$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.singleSparkSession = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_SINGLE_SPARK_SESSION()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.singleSparkSession;
    }

    private boolean singleSparkSession() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.singleSparkSession$lzycompute();
        }
        return this.singleSparkSession;
    }

    private Enumeration.Value shareLevel$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.shareLevel = ShareLevel$.MODULE$.withName(this.conf().get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.shareLevel;
    }

    private Enumeration.Value shareLevel() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.shareLevel$lzycompute();
        }
        return this.shareLevel;
    }

    private boolean userIsolatedSparkSession$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.userIsolatedSparkSession = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_USER_ISOLATED_SPARK_SESSION()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.userIsolatedSparkSession;
    }

    private boolean userIsolatedSparkSession() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.userIsolatedSparkSession$lzycompute();
        }
        return this.userIsolatedSparkSession;
    }

    private long userIsolatedIdleInterval$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.userIsolatedIdleInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_USER_ISOLATED_SPARK_SESSION_IDLE_INTERVAL()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.userIsolatedIdleInterval;
    }

    private long userIsolatedIdleInterval() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.userIsolatedIdleInterval$lzycompute();
        }
        return this.userIsolatedIdleInterval;
    }

    private long userIsolatedIdleTimeout$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.userIsolatedIdleTimeout = BoxesRunTime.unboxToLong((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_USER_ISOLATED_SPARK_SESSION_IDLE_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.userIsolatedIdleTimeout;
    }

    private long userIsolatedIdleTimeout() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.userIsolatedIdleTimeout$lzycompute();
        }
        return this.userIsolatedIdleTimeout;
    }

    private Object userIsolatedCacheLock() {
        return this.userIsolatedCacheLock;
    }

    private HashMap<String, SparkSession> userIsolatedCache$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.userIsolatedCache = new HashMap();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.userIsolatedCache;
    }

    private HashMap<String, SparkSession> userIsolatedCache() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.userIsolatedCache$lzycompute();
        }
        return this.userIsolatedCache;
    }

    private HashMap<String, Tuple2<Integer, Long>> userIsolatedCacheCount$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.userIsolatedCacheCount = new HashMap();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.userIsolatedCacheCount;
    }

    private HashMap<String, Tuple2<Integer, Long>> userIsolatedCacheCount() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.userIsolatedCacheCount$lzycompute();
        }
        return this.userIsolatedCacheCount;
    }

    private Option<ScheduledExecutorService> userIsolatedSparkSessionThread() {
        return this.userIsolatedSparkSessionThread;
    }

    private void userIsolatedSparkSessionThread_$eq(Option<ScheduledExecutorService> x$1) {
        this.userIsolatedSparkSessionThread = x$1;
    }

    private void startUserIsolatedCacheChecker() {
        if (!this.userIsolatedSparkSession()) {
            this.userIsolatedSparkSessionThread_$eq((Option<ScheduledExecutorService>)new Some((Object)ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("user-isolated-cache-checker", ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2())));
            this.userIsolatedSparkSessionThread().foreach((Function1 & Serializable)thread -> {
                ThreadUtils$.MODULE$.scheduleTolerableRunnableWithFixedDelay(thread, () -> {
                    Object object = $this.userIsolatedCacheLock();
                    synchronized (object) {
                        Iterator<Map.Entry<String, Tuple2<Integer, Long>>> iter = $this.userIsolatedCacheCount().entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry<String, Tuple2<Integer, Long>> kv = iter.next();
                            if (!BoxesRunTime.equals((Object)kv.getValue()._1(), (Object)BoxesRunTime.boxToInteger((int)0)) || Predef$.MODULE$.Long2long((Long)kv.getValue()._2()) + $this.userIsolatedIdleTimeout() >= System.currentTimeMillis()) continue;
                            $this.userIsolatedCache().remove(kv.getKey());
                            iter.remove();
                        }
                    }
                }, this.userIsolatedIdleInterval(), this.userIsolatedIdleInterval(), TimeUnit.MILLISECONDS);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void start() {
        this.startUserIsolatedCacheChecker();
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        KyuubiPythonGatewayServer$.MODULE$.shutdown();
        this.userIsolatedSparkSessionThread().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    private SparkSession getOrNewSparkSession(String user, Map<String, String> sessionConf) {
        boolean bl;
        boolean bl2;
        if (this.singleSparkSession()) {
            return this.spark;
        }
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return this.spark;
        }
        Enumeration.Value value4 = ShareLevel$.MODULE$.USER();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return this.newSparkSession(this.spark, sessionConf);
        }
        Enumeration.Value value6 = ShareLevel$.MODULE$.GROUP();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value8 = ShareLevel$.MODULE$.SERVER();
            Enumeration.Value value9 = value;
            bl2 = !(value8 != null ? !value8.equals(value9) : value9 != null);
        }
        if (bl2 && this.userIsolatedSparkSession()) {
            return this.newSparkSession(this.spark, sessionConf);
        }
        Enumeration.Value value10 = ShareLevel$.MODULE$.GROUP();
        Enumeration.Value value11 = value;
        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
            bl = true;
        } else {
            Enumeration.Value value12 = ShareLevel$.MODULE$.SERVER();
            Enumeration.Value value13 = value;
            bl = !(value12 != null ? !value12.equals(value13) : value13 != null);
        }
        if (bl) {
            SparkSession sparkSession;
            Object object = this.userIsolatedCacheLock();
            synchronized (object) {
                SparkSession sparkSession2;
                if (this.userIsolatedCache().containsKey(user)) {
                    Tuple2<Integer, Long> tuple2 = this.userIsolatedCacheCount().get(user);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Integer count = (Integer)tuple2._1();
                    Integer count2 = count;
                    this.userIsolatedCacheCount().put(user, (Tuple2<Integer, Long>)new Tuple2((Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(count2) + 1), (Object)Predef$.MODULE$.long2Long(System.currentTimeMillis())));
                    sparkSession2 = this.userIsolatedCache().get(user);
                } else {
                    this.userIsolatedCacheCount().put(user, (Tuple2<Integer, Long>)new Tuple2((Object)Predef$.MODULE$.int2Integer(1), (Object)Predef$.MODULE$.long2Long(System.currentTimeMillis())));
                    SparkSession newSession = this.newSparkSession(this.spark, sessionConf);
                    this.userIsolatedCache().put(user, newSession);
                    sparkSession2 = newSession;
                }
                sparkSession = sparkSession2;
            }
            return sparkSession;
        }
        throw new MatchError((Object)value);
    }

    private SparkSession newSparkSession(SparkSession rootSparkSession, Map<String, String> sessionConf) {
        SparkSession newSparkSession = rootSparkSession.newSession();
        KyuubiSparkUtil$.MODULE$.initializeSparkSession(newSparkSession, (Seq<String>)((Seq)sessionConf.get((Object)KyuubiConf$.MODULE$.ENGINE_SESSION_SPARK_INITIALIZE_SQL().key()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2)))).map((Function1 & Serializable)x$3 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])x$3.split(";")))).getOrElse((Function0 & Serializable)() -> this.conf().get(KyuubiConf$.MODULE$.ENGINE_SESSION_SPARK_INITIALIZE_SQL()))));
        return newSparkSession;
    }

    @Override
    public Session createSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        return (Session)conf.get((Object)"kyuubi.session.handle").map((Function1 & Serializable)uuid -> SessionHandle$.MODULE$.fromUUID((String)uuid)).flatMap((Function1 & Serializable)sessionHandle -> this.getSessionOption((SessionHandle)sessionHandle)).getOrElse((Function0 & Serializable)() -> {
            SparkSession sparkSession;
            try {
                sparkSession = this.getOrNewSparkSession(user, conf);
            }
            catch (Exception e) {
                throw KyuubiSQLException$.MODULE$.apply(e);
            }
            SparkSession sparkSession2 = sparkSession;
            return new SparkSessionImpl(protocol, user, password, ipAddress, conf, this, sparkSession2);
        });
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) {
        BoxedUnit boxedUnit;
        if (!this.userIsolatedSparkSession()) {
            Session session = this.getSession(sessionHandle);
            if (session != null) {
                Object object = this.userIsolatedCacheLock();
                synchronized (object) {
                    Tuple2<Integer, Long> tuple2;
                    if (this.userIsolatedCacheCount().containsKey(session.user())) {
                        Tuple2<Integer, Long> tuple22 = this.userIsolatedCacheCount().get(session.user());
                        if (tuple22 == null) {
                            throw new MatchError(tuple22);
                        }
                        Integer count = (Integer)tuple22._1();
                        Integer count2 = count;
                        tuple2 = this.userIsolatedCacheCount().put(session.user(), (Tuple2<Integer, Long>)new Tuple2((Object)Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(count2) - 1), (Object)Predef$.MODULE$.long2Long(System.currentTimeMillis())));
                    } else {
                        tuple2 = BoxedUnit.UNIT;
                    }
                    Tuple2<Integer, Long> tuple23 = tuple2;
                    // MONITOREXIT @DISABLED, blocks:[0, 17, 19, 5] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                    boxedUnit = tuple23;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            try {
                super.closeSession(sessionHandle);
            }
            catch (KyuubiSQLException e) {
                this.warn((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(22).append("Error closing session ").append(sessionHandle).toString(), e);
            }
        }
        finally {
            if (BoxesRunTime.unboxToBoolean((Object)KyuubiSparkUtil$.MODULE$.getSessionConf(KyuubiConf$.MODULE$.OPERATION_RESULT_SAVE_TO_FILE(), this.spark))) {
                Path sessionSavePath = this.getSessionResultSavePath(sessionHandle);
                try {
                    FileSystem fs = sessionSavePath.getFileSystem(this.spark.sparkContext().hadoopConfiguration());
                    if (fs.exists(sessionSavePath)) {
                        fs.delete(sessionSavePath, true);
                        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(29).append("Deleted session result path: ").append(sessionSavePath).toString());
                    }
                }
                catch (Throwable e) {
                    this.error((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(36).append("Error cleaning session result path: ").append(sessionSavePath).toString(), e);
                }
            }
        }
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.info((Function0<Object>)(Function0 & Serializable)() -> "Spark engine stopped due to session stopped and shared level is CONNECTION.");
            this.stopEngine();
            return;
        }
    }

    private void stopEngine() {
        SparkSQLEngine$.MODULE$.currentEngine().foreach((Function1 & Serializable)x$4 -> {
            x$4.stop();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public Path getEngineResultSavePath() {
        return new Path(this.conf().get(KyuubiConf$.MODULE$.OPERATION_RESULT_SAVE_TO_FILE_DIR()), KyuubiSparkUtil$.MODULE$.engineId());
    }

    private Path getSessionResultSavePath(SessionHandle sessionHandle) {
        return new Path(this.getEngineResultSavePath(), sessionHandle.identifier().toString());
    }

    public Path getOperationResultSavePath(SessionHandle sessionHandle, OperationHandle opHandle) {
        return new Path(this.getSessionResultSavePath(sessionHandle), opHandle.identifier().toString());
    }

    @Override
    public boolean isEngineContextStopped() {
        return this.spark.sparkContext().isStopped();
    }

    private SparkSQLSessionManager(String name, SparkSession spark) {
        this.spark = spark;
        super(name);
        this.operationManager = new SparkSQLOperationManager();
        this.userIsolatedCacheLock = new Object();
        this.userIsolatedSparkSessionThread = None$.MODULE$;
    }

    public SparkSQLSessionManager(SparkSession spark) {
        this(SparkSQLSessionManager.class.getSimpleName(), spark);
    }
}

