/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.EngineSecuritySecretProvider;
import org.apache.kyuubi.service.authentication.EngineSecuritySecretProvider$;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.service.authentication.KyuubiInternalAccessIdentifier;
import org.apache.kyuubi.service.authentication.KyuubiInternalAccessIdentifier$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ee\u0001B\u0014)\u0001MB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0003\u0002\u0011)\u0019!C\u0001\u0005\"Aa\t\u0001B\u0001B\u0003%1\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0004N\u0001\t\u0007I\u0011\u0001(\t\rI\u0003\u0001\u0015!\u0003P\u0011\u001d\u0019\u0006A1A\u0005\u00029Ca\u0001\u0016\u0001!\u0002\u0013y\u0005bB+\u0001\u0005\u0004%\tA\u0016\u0005\u0007E\u0002\u0001\u000b\u0011B,\t\u000f\r\u0004!\u0019!C\u0001-\"1A\r\u0001Q\u0001\n]Cq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004k\u0001\u0001\u0006Ia\u001a\u0005\bW\u0002\u0011\r\u0011\"\u0003m\u0011\u0019\u0001\b\u0001)A\u0005[\"Q\u0011\u000f\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002:\t\u000fu\u0004!\u0019!C\u0005}\"1q\u0010\u0001Q\u0001\nUD\u0001\"!\u0001\u0001\u0005\u0004%IA \u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003v\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u0011\u0005\r\u0002\u0001\"\u0001)\u0003KA\u0001\"a\u000b\u0001\t\u0003A\u0013Q\u0006\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t9\u0004\u0001C\u0005\u0003sAq!a\u0013\u0001\t\u0013\tieB\u0004\u0002T!B\t!!\u0016\u0007\r\u001dB\u0003\u0012AA,\u0011\u00199u\u0004\"\u0001\u0002b!Y\u00111M\u0010A\u0002\u0003\u0007I\u0011BA3\u0011-\t9g\ba\u0001\u0002\u0004%I!!\u001b\t\u0015\u00055t\u00041A\u0001B\u0003&\u0011\nC\u0004\u0002x}!\t!!\u001f\t\u000f\u0005}t\u0004\"\u0001\u0002\u0002\"9\u00111Q\u0010\u0005\u0002\u0005\u0015%\u0001G%oi\u0016\u0014h.\u00197TK\u000e,(/\u001b;z\u0003\u000e\u001cWm]:pe*\u0011\u0011FK\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tYC&A\u0004tKJ4\u0018nY3\u000b\u00055r\u0013AB6zkV\u0014\u0017N\u0003\u00020a\u00051\u0011\r]1dQ\u0016T\u0011!M\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0017\u0001B2p]\u001a\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0017\u0002\r\r|gNZ5h\u0013\t\u0001UH\u0001\u0006LsV,(-[\"p]\u001a\f\u0001\"[:TKJ4XM]\u000b\u0002\u0007B\u0011Q\u0007R\u0005\u0003\u000bZ\u0012qAQ8pY\u0016\fg.A\u0005jgN+'O^3sA\u00051A(\u001b8jiz\"2!S&M!\tQ\u0005!D\u0001)\u0011\u0015QD\u00011\u0001<\u0011\u0015\tE\u00011\u0001D\u0003Q\u0019'/\u001f9u_.+\u0017\u0010T3oORD')\u001f;fgV\tq\n\u0005\u00026!&\u0011\u0011K\u000e\u0002\u0004\u0013:$\u0018!F2ssB$xnS3z\u0019\u0016tw\r\u001e5CsR,7\u000fI\u0001\u000fGJL\b\u000f^8Jm2+gn\u001a;i\u0003=\u0019'/\u001f9u_&3H*\u001a8hi\"\u0004\u0013AE2ssB$xnS3z\u00032<wN]5uQ6,\u0012a\u0016\t\u00031~s!!W/\u0011\u0005i3T\"A.\u000b\u0005q\u0013\u0014A\u0002\u001fs_>$h(\u0003\u0002_m\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tqf'A\ndef\u0004Ho\\&fs\u0006cwm\u001c:ji\"l\u0007%\u0001\u0007def\u0004Ho\\\"ja\",'/A\u0007def\u0004Ho\\\"ja\",'\u000fI\u0001\u0011i>\\WM\\'bq2Kg-\u001a+j[\u0016,\u0012a\u001a\t\u0003k!L!!\u001b\u001c\u0003\t1{gnZ\u0001\u0012i>\\WM\\'bq2Kg-\u001a+j[\u0016\u0004\u0013\u0001\u00039s_ZLG-\u001a:\u0016\u00035\u0004\"A\u00138\n\u0005=D#\u0001H#oO&tWmU3dkJLG/_*fGJ,G\u000f\u0015:pm&$WM]\u0001\naJ|g/\u001b3fe\u0002\n1\u0001\u001f\u00132!\u0011)4/^;\n\u0005Q4$A\u0002+va2,'\u0007\u0005\u0002ww6\tqO\u0003\u0002ys\u000611M]=qi>T\u0011A_\u0001\u0006U\u00064\u0018\r_\u0005\u0003y^\u0014aaQ5qQ\u0016\u0014\u0018!C3oGJL\b\u000f^8s+\u0005)\u0018AC3oGJL\b\u000f^8sA\u0005IA-Z2ssB$xN]\u0001\u000bI\u0016\u001c'/\u001f9u_J\u0004\u0013!E5oSRL\u0017\r\\5{K\u001a{'/Q;uQR)!/!\u0003\u0002\u000e!1\u00111\u0002\fA\u0002]\u000baaY5qQ\u0016\u0014\bBBA\b-\u0001\u0007q+\u0001\u0004tK\u000e\u0014X\r^\u0001\u000bSN\u001cX/\u001a+pW\u0016tG#A,\u0002\u0013\u0005,H\u000f\u001b+pW\u0016tG\u0003BA\r\u0003?\u00012!NA\u000e\u0013\r\tiB\u000e\u0002\u0005+:LG\u000f\u0003\u0004\u0002\"a\u0001\raV\u0001\ti>\\WM\\*ue\u00069QM\\2ssB$HcA,\u0002(!1\u0011\u0011F\rA\u0002]\u000bQA^1mk\u0016\fq\u0001Z3def\u0004H\u000fF\u0002X\u0003_Aa!!\u000b\u001b\u0001\u00049\u0016a\u00048pe6\fG.\u001b>f'\u0016\u001c'/\u001a;\u0015\u0007]\u000b)\u0004\u0003\u0004\u0002\u0010m\u0001\raV\u0001\u0015Q\u0016D8\u000b\u001e:j]\u001e$vNQ=uK\u0006\u0013(/Y=\u0015\t\u0005m\u0012q\t\t\u0006k\u0005u\u0012\u0011I\u0005\u0004\u0003\u007f1$!B!se\u0006L\bcA\u001b\u0002D%\u0019\u0011Q\t\u001c\u0003\t\tKH/\u001a\u0005\u0007\u0003\u0013b\u0002\u0019A,\u0002\u0007M$(/\u0001\u000bcsR,\u0017I\u001d:bsR{\u0007*\u001a=TiJLgn\u001a\u000b\u0004/\u0006=\u0003bBA);\u0001\u0007\u00111H\u0001\u0006Ef$Xm]\u0001\u0019\u0013:$XM\u001d8bYN+7-\u001e:jif\f5mY3tg>\u0014\bC\u0001& '\u0011yB'!\u0017\u0011\t\u0005m\u0013QL\u0007\u0002Y%\u0019\u0011q\f\u0017\u0003\u000f1{wmZ5oOR\u0011\u0011QK\u0001\u0018?\u0016tw-\u001b8f'\u0016\u001cWO]5us\u0006\u001b7-Z:t_J,\u0012!S\u0001\u001c?\u0016tw-\u001b8f'\u0016\u001cWO]5us\u0006\u001b7-Z:t_J|F%Z9\u0015\t\u0005e\u00111\u000e\u0005\bc\n\n\t\u00111\u0001J\u0003ayVM\\4j]\u0016\u001cVmY;sSRL\u0018iY2fgN|'\u000f\t\u0015\u0004G\u0005E\u0004cA\u001b\u0002t%\u0019\u0011Q\u000f\u001c\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001b8ji&\fG.\u001b>f)\u0019\tI\"a\u001f\u0002~!)!\b\na\u0001w!)\u0011\t\na\u0001\u0007\u0006\u0019q-\u001a;\u0015\u0003%\u000bQA]3tKR$\"!!\u0007)\u0007\u0019\nI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0019\u00111\u0013\u0018\u0002\r!\fGm\\8q\u0013\u0011\t9*!$\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw\r")
public class InternalSecurityAccessor {
    private final boolean isServer;
    private final int cryptoKeyLengthBytes;
    private final int cryptoIvLength;
    private final String cryptoKeyAlgorithm;
    private final String cryptoCipher;
    private final long tokenMaxLifeTime;
    private final EngineSecuritySecretProvider provider;
    private final /* synthetic */ Tuple2 x$1;
    private final Cipher encryptor;
    private final Cipher decryptor;

    @VisibleForTesting
    public static void reset() {
        InternalSecurityAccessor$.MODULE$.reset();
    }

    public static InternalSecurityAccessor get() {
        return InternalSecurityAccessor$.MODULE$.get();
    }

    public static void initialize(KyuubiConf conf, boolean isServer) {
        InternalSecurityAccessor$.MODULE$.initialize(conf, isServer);
    }

    public static void error(Function0<Object> message) {
        InternalSecurityAccessor$.MODULE$.error(message);
    }

    public static void error(Function0<Object> message, Throwable t) {
        InternalSecurityAccessor$.MODULE$.error(message, t);
    }

    public static void warn(Function0<Object> message, Throwable t) {
        InternalSecurityAccessor$.MODULE$.warn(message, t);
    }

    public static void warn(Function0<Object> message) {
        InternalSecurityAccessor$.MODULE$.warn(message);
    }

    public static void info(Function0<Object> message, Throwable t) {
        InternalSecurityAccessor$.MODULE$.info(message, t);
    }

    public static void info(Function0<Object> message) {
        InternalSecurityAccessor$.MODULE$.info(message);
    }

    public static void debug(Function0<Object> message, Throwable t) {
        InternalSecurityAccessor$.MODULE$.debug(message, t);
    }

    public static void debug(Function0<Object> message) {
        InternalSecurityAccessor$.MODULE$.debug(message);
    }

    public boolean isServer() {
        return this.isServer;
    }

    public int cryptoKeyLengthBytes() {
        return this.cryptoKeyLengthBytes;
    }

    public int cryptoIvLength() {
        return this.cryptoIvLength;
    }

    public String cryptoKeyAlgorithm() {
        return this.cryptoKeyAlgorithm;
    }

    public String cryptoCipher() {
        return this.cryptoCipher;
    }

    private long tokenMaxLifeTime() {
        return this.tokenMaxLifeTime;
    }

    private EngineSecuritySecretProvider provider() {
        return this.provider;
    }

    private Cipher encryptor() {
        return this.encryptor;
    }

    private Cipher decryptor() {
        return this.decryptor;
    }

    private Tuple2<Cipher, Cipher> initializeForAuth(String cipher, String secret) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(), this.cryptoKeyAlgorithm());
        byte[] nonce = new byte[this.cryptoIvLength()];
        IvParameterSpec iv = new IvParameterSpec(nonce);
        Cipher _encryptor = Cipher.getInstance(cipher);
        _encryptor.init(1, (Key)secretKeySpec, iv);
        Cipher _decryptor = Cipher.getInstance(cipher);
        _decryptor.init(2, (Key)secretKeySpec, iv);
        return new Tuple2((Object)_encryptor, (Object)_decryptor);
    }

    public String issueToken() {
        return this.encrypt(KyuubiInternalAccessIdentifier$.MODULE$.newIdentifier(this.tokenMaxLifeTime()).toJson());
    }

    public void authToken(String tokenStr) {
        KyuubiInternalAccessIdentifier kyuubiInternalAccessIdentifier;
        try {
            kyuubiInternalAccessIdentifier = KyuubiInternalAccessIdentifier$.MODULE$.fromJson(this.decrypt(tokenStr));
        }
        catch (Exception exception) {
            throw KyuubiSQLException$.MODULE$.apply("Invalid engine access token", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        KyuubiInternalAccessIdentifier identifier = kyuubiInternalAccessIdentifier;
        if (identifier.issueDate() + identifier.maxDate() < System.currentTimeMillis()) {
            throw KyuubiSQLException$.MODULE$.apply("The engine access token is expired", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
    }

    public synchronized String encrypt(String value) {
        return this.byteArrayToHexString(this.encryptor().doFinal(value.getBytes()));
    }

    public synchronized String decrypt(String value) {
        return new String(this.decryptor().doFinal(this.hexStringToByteArray(value)));
    }

    private String normalizeSecret(String secret) {
        char[] normalizedSecret = new char[this.cryptoKeyLengthBytes()];
        char placeHolder = ' ';
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cryptoKeyLengthBytes()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            if (i < secret.length()) {
                normalizedSecret$1[i] = secret.charAt(i);
                return;
            }
            normalizedSecret$1[i] = placeHolder;
        });
        return new String(normalizedSecret);
    }

    private byte[] hexStringToByteArray(String str) {
        int len = str.length();
        Predef$.MODULE$.assert(len % 2 == 0);
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return data;
    }

    private String byteArrayToHexString(byte[] bytes) {
        return (String)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)object -> InternalSecurityAccessor.$anonfun$byteArrayToHexString$1(BoxesRunTime.unboxToByte((Object)object)), ClassTag$.MODULE$.apply(String.class))).reduce((Function2 & Serializable)(x$2, x$3) -> new StringBuilder(0).append((String)x$2).append((String)x$3).toString());
    }

    public static final /* synthetic */ String $anonfun$byteArrayToHexString$1(byte by) {
        return new StringBuilder(0).append(Integer.toHexString(by >> 4 & 0xF)).append(Integer.toHexString(by & 0xF)).toString();
    }

    public InternalSecurityAccessor(KyuubiConf conf, boolean isServer) {
        this.isServer = isServer;
        this.cryptoKeyLengthBytes = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_KEY_LENGTH())) / 8;
        this.cryptoIvLength = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_IV_LENGTH()));
        this.cryptoKeyAlgorithm = conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_KEY_ALGORITHM());
        this.cryptoCipher = conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_CIPHER_TRANSFORMATION());
        this.tokenMaxLifeTime = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_TOKEN_MAX_LIFETIME()));
        this.provider = EngineSecuritySecretProvider$.MODULE$.create(conf);
        Tuple2<Cipher, Cipher> tuple2 = this.initializeForAuth(this.cryptoCipher(), this.normalizeSecret(this.provider().getSecret()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Cipher encryptor = (Cipher)tuple2._1();
        Cipher decryptor = (Cipher)tuple2._2();
        this.x$1 = new Tuple2((Object)encryptor, (Object)decryptor);
        this.encryptor = (Cipher)this.x$1._1();
        this.decryptor = (Cipher)this.x$1._2();
    }
}

