/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.maybe;

import io.reactivex.MaybeObserver;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicQueueDisposable;
import java.util.Iterator;

public final class MaybeFlatMapIterableObservable<T, R>
extends Observable<R> {
    final MaybeSource<T> source;
    final Function<? super T, ? extends Iterable<? extends R>> mapper;

    public MaybeFlatMapIterableObservable(MaybeSource<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Observer<? super R> s) {
        this.source.subscribe(new FlatMapIterableObserver<T, R>(s, this.mapper));
    }

    static final class FlatMapIterableObserver<T, R>
    extends BasicQueueDisposable<R>
    implements MaybeObserver<T> {
        final Observer<? super R> actual;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        Disposable d;
        volatile Iterator<? extends R> it;
        volatile boolean cancelled;
        boolean outputFused;

        FlatMapIterableObserver(Observer<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            boolean b;
            boolean has;
            Iterator<R> iter;
            Observer<R> a = this.actual;
            try {
                iter = this.mapper.apply(value).iterator();
                has = iter.hasNext();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                a.onError(ex);
                return;
            }
            if (!has) {
                a.onComplete();
                return;
            }
            this.it = iter;
            if (this.outputFused && iter != null) {
                a.onNext(null);
                a.onComplete();
                return;
            }
            do {
                R v;
                if (this.cancelled) {
                    return;
                }
                try {
                    v = iter.next();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
                a.onNext(v);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = iter.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    a.onError(ex);
                    return;
                }
            } while (b);
            a.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            this.d = DisposableHelper.DISPOSED;
            this.actual.onError(e);
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.d.dispose();
            this.d = DisposableHelper.DISPOSED;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public void clear() {
            this.it = null;
        }

        @Override
        public boolean isEmpty() {
            return this.it == null;
        }

        @Override
        public R poll() throws Exception {
            Iterator<R> iter = this.it;
            if (iter != null) {
                R v = ObjectHelper.requireNonNull(iter.next(), "The iterator returned a null value");
                if (!iter.hasNext()) {
                    this.it = null;
                }
                return v;
            }
            return null;
        }
    }
}

